/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.craftingframe;

import edgarallen.mods.scf.blocks.common.TileEntityBaseFrame;
import edgarallen.mods.scf.blocks.craftingframe.BlockCraftingFrame;
import edgarallen.mods.scf.blocks.craftingframe.core.InventoryMode;
import edgarallen.mods.scf.blocks.craftingframe.core.SubFrame;
import edgarallen.mods.scf.blocks.craftingframe.nbt.CraftingFrameNBTReader;
import edgarallen.mods.scf.blocks.craftingframe.nbt.CraftingFrameNBTWriter;
import edgarallen.mods.scf.util.CombinedInvWrapper;
import edgarallen.mods.scf.util.CommonUtils;
import edgarallen.mods.scf.util.EnumType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class TileEntityCraftingFrame
extends TileEntityBaseFrame {
    private SubFrame[] subFrames;

    @Override
    public void initFrame(EnumType type) {
        super.initFrame(type);
        this.subFrames = new SubFrame[type.getIndex() + 1];
        for (int i = 0; i < this.subFrames.length; ++i) {
            this.subFrames[i] = new SubFrame();
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        CraftingFrameNBTWriter.writeToNBT(this.type, this.subFrames, compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        CraftingFrameNBTReader.readFromNBT(this, compound);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        CraftingFrameNBTWriter.writeToNBT(this.type, this.subFrames, compound);
        return compound;
    }

    boolean shouldShowGuiOnBlockPlace() {
        for (SubFrame frame : this.subFrames) {
            if (frame == null || !frame.hasValidRecipeOutput()) continue;
            return false;
        }
        return true;
    }

    SubFrame[] getSubFrames() {
        return this.subFrames;
    }

    public SubFrame getSubFrame(int subFrameIndex) {
        return this.subFrames != null && subFrameIndex < this.subFrames.length && this.subFrames[subFrameIndex] != null ? this.subFrames[subFrameIndex] : new SubFrame();
    }

    public void setSubFrame(SubFrame subFrame, int subFrameIndex) {
        this.subFrames[subFrameIndex] = subFrame;
    }

    public void performInstantBreak() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        if (!block.isAir(state, (IBlockAccess)this.field_145850_b, this.field_174879_c) && block instanceof BlockCraftingFrame) {
            block.func_176226_b(this.field_145850_b, this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()), 0);
            this.field_145850_b.func_175698_g(this.func_174877_v());
        }
    }

    public void performCraft(EntityPlayer player, int subFrameIndex, boolean fullStack) {
        if (!this.isRecipeValid(subFrameIndex)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.super_crafting_frame.recipe.invalid", new Object[0]));
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.55f);
            return;
        }
        IItemHandler inventory = this.getInventories(player, this.subFrames[subFrameIndex].getMode());
        if (fullStack) {
            int crafted = 0;
            while (crafted < this.subFrames[subFrameIndex].getRecipeOutput().func_77976_d()) {
                ArrayList<String> missing = new ArrayList<String>();
                if (this.getMissingIngredients(inventory, subFrameIndex, missing)) {
                    player.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
                    HashSet<String> unique = new HashSet<String>(missing);
                    for (String name : unique) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.super_crafting_frame.recipe.missing_ingredient", new Object[]{name, Collections.frequency(missing, name)}));
                    }
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.55f);
                    return;
                }
                ItemStack result = this.craftItem(player, subFrameIndex, inventory);
                CommonUtils.ejectItem(this.field_145850_b, this.field_174879_c, subFrameIndex, result);
                if (result == null) continue;
                crafted += result.field_77994_a;
            }
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187897_gY, SoundCategory.BLOCKS, 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.55f);
        } else {
            ArrayList<String> missing = new ArrayList<String>();
            if (this.getMissingIngredients(inventory, subFrameIndex, missing)) {
                player.func_184185_a(SoundEvents.field_187632_cP, 1.0f, 1.0f);
                HashSet<String> unique = new HashSet<String>(missing);
                for (String name : unique) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.super_crafting_frame.recipe.missing_ingredient", new Object[]{name, Collections.frequency(missing, name)}));
                }
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.55f);
                return;
            }
            ItemStack result = this.craftItem(player, subFrameIndex, inventory);
            CommonUtils.ejectItem(this.field_145850_b, this.field_174879_c, subFrameIndex, result);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187897_gY, SoundCategory.BLOCKS, 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.55f);
        }
    }

    private boolean getMissingIngredients(IItemHandler inventory, int subFrameIndex, List<String> outMissing) {
        int[] hitCount = new int[inventory.getSlots()];
        for (ItemStack recipeItem : this.subFrames[subFrameIndex].getRecipeItems()) {
            if (recipeItem == null) continue;
            boolean wasFound = false;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack == null || !ItemStack.func_185132_d((ItemStack)recipeItem, (ItemStack)stack) || hitCount[i] >= stack.field_77994_a || hitCount[i] >= stack.func_77976_d()) continue;
                int n = i;
                hitCount[n] = hitCount[n] + 1;
                wasFound = true;
                break;
            }
            if (wasFound) continue;
            outMissing.add(recipeItem.func_82833_r());
        }
        return !outMissing.isEmpty();
    }

    private ItemStack craftItem(EntityPlayer player, int subFrameIndex, IItemHandler inventory) {
        InventoryCrafting craftMatrix = this.getTempCraftingMatrix();
        InventoryCraftResult craftResult = new InventoryCraftResult();
        SlotCrafting slotCrafting = new SlotCrafting(player, craftMatrix, (IInventory)craftResult, 0, 0, 0);
        int[] binding = new int[this.subFrames[subFrameIndex].getRecipeItems().length];
        block0: for (int i = 0; i < this.subFrames[subFrameIndex].getRecipeItems().length; ++i) {
            ItemStack recipeItem = this.subFrames[subFrameIndex].getRecipeItem(i);
            if (recipeItem == null) continue;
            for (int j = 0; j < inventory.getSlots(); ++j) {
                ItemStack stack = inventory.getStackInSlot(j);
                if (stack == null || !ItemStack.func_185132_d((ItemStack)recipeItem, (ItemStack)stack)) continue;
                binding[i] = j;
                craftMatrix.func_70299_a(i, inventory.extractItem(j, 1, false));
                continue block0;
            }
        }
        ItemStack result = this.findMatchingRecipe(craftMatrix);
        if (result != null) {
            slotCrafting.func_82870_a(player, result);
            for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                ItemStack failedStack;
                ItemStack stack = craftMatrix.func_70301_a(i);
                if (stack == null || (failedStack = inventory.insertItem(binding[i], stack, false)) == null || (failedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)failedStack, (boolean)false)) == null) continue;
                CommonUtils.ejectItem(this.field_145850_b, this.field_174879_c, subFrameIndex, failedStack);
            }
        }
        return result;
    }

    private boolean isRecipeValid(int subFrameIndex) {
        return this.subFrames[subFrameIndex].getRecipeOutput() != null;
    }

    public boolean areRecipeItemsSet(int subFrameIndex) {
        for (int i = 0; i < this.subFrames[subFrameIndex].getRecipeItems().length; ++i) {
            if (this.subFrames[subFrameIndex].getRecipeItem(i) == null) continue;
            return true;
        }
        return false;
    }

    private ItemStack findMatchingRecipe(InventoryCrafting craftMatrix) {
        return CraftingManager.func_77594_a().func_82787_a(craftMatrix, this.field_145850_b);
    }

    private InventoryCrafting getTempCraftingMatrix() {
        return new InventoryCrafting(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer entityplayer) {
                return true;
            }
        }, 3, 3);
    }

    private IItemHandler getInventories(EntityPlayer player, InventoryMode inventoryMode) {
        switch (inventoryMode) {
            case BOTH: {
                IItemHandler connectedInv = CommonUtils.getConnectedInventory(this.field_145850_b, this.field_174879_c);
                PlayerMainInvWrapper playerInv = new PlayerMainInvWrapper(player.field_71071_by);
                return new CombinedInvWrapper(new IItemHandler[]{connectedInv, playerInv});
            }
            case PLAYER: {
                return new PlayerMainInvWrapper(player.field_71071_by);
            }
            case INVENTORY: {
                return CommonUtils.getConnectedInventory(this.field_145850_b, this.field_174879_c);
            }
        }
        return new EmptyHandler();
    }

    public void selectNextMode(int subFrameIndex) {
        this.subFrames[subFrameIndex].selectNextMode();
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    boolean areAnySubFramesSet() {
        boolean flag = false;
        for (SubFrame frame : this.subFrames) {
            flag |= frame != null && !frame.isSubFrameDefault();
        }
        return flag;
    }
}

