/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.craftingframe.compat;

import edgarallen.mods.scf.blocks.ModBlocks;
import edgarallen.mods.scf.blocks.craftingframe.BlockCraftingFrame;
import edgarallen.mods.scf.blocks.craftingframe.TileEntityCraftingFrame;
import edgarallen.mods.scf.blocks.craftingframe.core.SubFrame;
import edgarallen.mods.scf.blocks.craftingframe.utils.TooltipHelper;
import edgarallen.mods.scf.util.CommonUtils;
import edgarallen.mods.scf.util.EnumPlacement;
import edgarallen.mods.scf.util.EnumType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class CraftingFrameWailaDataProvider
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntityCraftingFrame tile = (TileEntityCraftingFrame)accessor.getTileEntity();
        if (tile != null) {
            switch (tile.getType()) {
                case SINGLE: {
                    return null;
                }
                case DOUBLE: {
                    return new ItemStack((Block)ModBlocks.craftingFrame, 1, 1);
                }
                case TRIPLE: {
                    return new ItemStack((Block)ModBlocks.craftingFrame, 1, 2);
                }
                case QUAD: {
                    return new ItemStack((Block)ModBlocks.craftingFrame, 1, 3);
                }
            }
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntityCraftingFrame tile = (TileEntityCraftingFrame)accessor.getTileEntity();
        EnumType type = tile.getType();
        switch (type) {
            case SINGLE: {
                tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.single.tooltip.subheader"));
                break;
            }
            case DOUBLE: {
                tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.double.tooltip.subheader"));
                break;
            }
            case TRIPLE: {
                tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.triple.tooltip.subheader"));
                break;
            }
            case QUAD: {
                tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.quad.tooltip.subheader"));
            }
        }
        RayTraceResult ray = Minecraft.func_71410_x().field_71476_x;
        BlockPos hitPos = ray.func_178782_a();
        float hitX = (float)(ray.field_72307_f.field_72450_a - (double)hitPos.func_177958_n());
        float hitY = (float)(ray.field_72307_f.field_72448_b - (double)hitPos.func_177956_o());
        float hitZ = (float)(ray.field_72307_f.field_72449_c - (double)hitPos.func_177952_p());
        IBlockState state = accessor.getBlockState();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockCraftingFrame.FACING);
        EnumPlacement placement = (EnumPlacement)((Object)state.func_177229_b((IProperty)BlockCraftingFrame.PLACEMENT));
        int subFrameIndex = CommonUtils.getSubFrameIndex(type, facing, placement, hitX, hitY, hitZ);
        SubFrame subFrame = tile.getSubFrame(subFrameIndex);
        ItemStack output = subFrame.getRecipeOutput();
        if (output != null) {
            tooltip.add(I18n.func_74837_a((String)"item.super_crafting_frame.tooltip.recipe", (Object[])new Object[]{output.func_82833_r(), output.field_77994_a}));
        } else if (tile.areRecipeItemsSet(subFrameIndex)) {
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.invalid"));
        } else {
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            return tooltip;
        }
        if (config.getConfig("super_crafting_frame.shift_for_more_info")) {
            if (GuiScreen.func_146272_n()) {
                tooltip.add(I18n.func_74837_a((String)"item.super_crafting_frame.tooltip.mode", (Object[])new Object[]{I18n.func_74838_a((String)subFrame.getMode().getUnlocalizedName())}));
                tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.ingredient.header"));
                List<String> list = TooltipHelper.getIngredientNames(subFrame.getRecipeItems());
                if (list.size() > 0) {
                    HashSet<String> unique = new HashSet<String>(list);
                    tooltip.addAll(unique.stream().map(key -> I18n.func_74837_a((String)"item.super_crafting_frame.tooltip.recipe.ingredient", (Object[])new Object[]{key, Collections.frequency(list, key)})).collect(Collectors.toList()));
                } else {
                    tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.ingredient.none"));
                }
            } else {
                tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.shift"));
            }
        }
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.addConfig("Super Crafting Frame", "super_crafting_frame.shift_for_more_info", I18n.func_74838_a((String)"waila.super_crafting_frame.shift_for_more_info"), true);
        registrar.registerBodyProvider((IWailaDataProvider)new CraftingFrameWailaDataProvider(), TileEntityCraftingFrame.class);
        registrar.registerStackProvider((IWailaDataProvider)new CraftingFrameWailaDataProvider(), TileEntityCraftingFrame.class);
    }
}

