/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.craftingframe.nbt;

import edgarallen.mods.scf.blocks.craftingframe.TileEntityCraftingFrame;
import edgarallen.mods.scf.blocks.craftingframe.core.InventoryMode;
import edgarallen.mods.scf.blocks.craftingframe.core.SubFrame;
import edgarallen.mods.scf.blocks.craftingframe.nbt.legacy.CraftingFrameLegacyNBTReader;
import edgarallen.mods.scf.util.EnumType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CraftingFrameNBTReader {
    public static void readFromNBT(TileEntityCraftingFrame tile, NBTTagCompound compound) {
        NBTTagCompound rootCompound = CraftingFrameNBTReader.readRootTagCompoundFromNBT(compound);
        int version = CraftingFrameNBTReader.readVersionFromNBT(rootCompound);
        if (CraftingFrameNBTReader.shouldUseLegacyReader(version)) {
            CraftingFrameLegacyNBTReader.readFromNBT(version, tile, compound);
            return;
        }
        CraftingFrameNBTReader.readFrameTypeFromNBT(tile, rootCompound);
        CraftingFrameNBTReader.readSubFramesFromNBT(tile, rootCompound);
    }

    public static NBTTagCompound readRootTagCompoundFromNBT(NBTTagCompound compound) {
        NBTTagList craftingFrameTagList = compound.func_150295_c("craftingFrame", 10);
        return craftingFrameTagList.func_150305_b(0);
    }

    private static int readVersionFromNBT(NBTTagCompound compound) {
        return compound.func_74771_c("version");
    }

    private static void readFrameTypeFromNBT(TileEntityCraftingFrame tile, NBTTagCompound compound) {
        tile.initFrame(EnumType.getType(compound.func_74771_c("type")));
    }

    public static EnumType readFrameTypeFromNBT(NBTTagCompound compound) {
        return EnumType.getType(compound.func_74771_c("type"));
    }

    private static void readSubFramesFromNBT(TileEntityCraftingFrame tile, NBTTagCompound rootCompound) {
        NBTTagList subFramesTagList = rootCompound.func_150295_c("subFrames", 10);
        for (int i = 0; i < subFramesTagList.func_74745_c(); ++i) {
            NBTTagCompound compound = subFramesTagList.func_150305_b(i);
            int subFrameIndex = CraftingFrameNBTReader.readSubFrameIndexFromNBT(compound);
            InventoryMode mode = CraftingFrameNBTReader.readSubFrameModeFromNBT(compound);
            ItemStack[] recipeItems = CraftingFrameNBTReader.readSubFrameRecipeFromNBT(compound);
            ItemStack recipeOutput = CraftingFrameNBTReader.readSubFrameRecipeOutputFromNBT(compound);
            SubFrame subFrame = new SubFrame(mode, recipeItems, recipeOutput);
            tile.setSubFrame(subFrame, subFrameIndex);
        }
    }

    private static int readSubFrameIndexFromNBT(NBTTagCompound compound) {
        return compound.func_74771_c("index");
    }

    private static InventoryMode readSubFrameModeFromNBT(NBTTagCompound compound) {
        return InventoryMode.values()[compound.func_74771_c("mode")];
    }

    private static ItemStack[] readSubFrameRecipeFromNBT(NBTTagCompound compound) {
        ItemStack[] recipeItems = new ItemStack[9];
        NBTTagList recipeItemsList = compound.func_150295_c("recipeItems", 10);
        for (int i = 0; i < recipeItemsList.func_74745_c(); ++i) {
            ItemStack stack;
            NBTTagCompound itemCompound = recipeItemsList.func_150305_b(i);
            byte slot = itemCompound.func_74771_c("slot");
            recipeItems[slot] = stack = CraftingFrameNBTReader.readItemStackFromNBT(itemCompound);
        }
        return recipeItems;
    }

    private static ItemStack readSubFrameRecipeOutputFromNBT(NBTTagCompound compound) {
        NBTTagList itemRoot = compound.func_150295_c("recipeOutput", 10);
        NBTTagCompound itemCompound = itemRoot.func_150305_b(0);
        return ItemStack.func_77949_a((NBTTagCompound)itemCompound);
    }

    private static ItemStack readItemStackFromNBT(NBTTagCompound compound) {
        NBTTagList itemRoot = compound.func_150295_c("item", 10);
        NBTTagCompound itemCompound = itemRoot.func_150305_b(0);
        return ItemStack.func_77949_a((NBTTagCompound)itemCompound);
    }

    public static SubFrame[] readSubFramesFromNBT(int size, NBTTagCompound rootCompound) {
        SubFrame[] subFrames = new SubFrame[size];
        NBTTagList subFramesTagList = rootCompound.func_150295_c("subFrames", 10);
        for (int i = 0; i < subFramesTagList.func_74745_c(); ++i) {
            SubFrame subFrame;
            NBTTagCompound compound = subFramesTagList.func_150305_b(i);
            int subFrameIndex = CraftingFrameNBTReader.readSubFrameIndexFromNBT(compound);
            InventoryMode mode = CraftingFrameNBTReader.readSubFrameModeFromNBT(compound);
            ItemStack[] recipeItems = CraftingFrameNBTReader.readSubFrameRecipeFromNBT(compound);
            ItemStack recipeOutput = CraftingFrameNBTReader.readSubFrameRecipeOutputFromNBT(compound);
            subFrames[subFrameIndex] = subFrame = new SubFrame(mode, recipeItems, recipeOutput);
        }
        return subFrames;
    }

    private static boolean shouldUseLegacyReader(int version) {
        return version < 1;
    }
}

