/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.itemframe;

import com.google.common.collect.Maps;
import edgarallen.mods.scf.blocks.common.TileEntityBaseFrame;
import edgarallen.mods.scf.blocks.itemframe.BlockItemFrame;
import edgarallen.mods.scf.blocks.itemframe.nbt.ItemFrameNBTReader;
import edgarallen.mods.scf.blocks.itemframe.nbt.ItemFrameNBTWriter;
import edgarallen.mods.scf.util.CommonUtils;
import edgarallen.mods.scf.util.EnumType;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityItemFrame
extends TileEntityBaseFrame {
    private ItemStack[] filters = new ItemStack[1];

    @Override
    public void initFrame(EnumType type) {
        super.initFrame(type);
        this.filters = new ItemStack[type.getIndex() + 1];
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        ItemFrameNBTReader.readFromNBT(this, data);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        ItemFrameNBTWriter.writeToNBT(this.type, this.filters, data);
        return data;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        ItemFrameNBTWriter.writeToNBT(this.type, this.filters, compound);
        return compound;
    }

    private void trySetFilter(ItemStack stack, int subFrameIndex) {
        if (this.filters[subFrameIndex] == null && stack != null) {
            ItemStack s = stack.func_77946_l();
            s.field_77994_a = 1;
            this.setFilter(s, subFrameIndex);
            this.func_70296_d();
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void setFilter(ItemStack stack, int subFrameIndex) {
        this.filters[subFrameIndex] = stack;
    }

    public void clearFilter(int subFrameIndex) {
        this.setFilter(null, subFrameIndex);
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public ItemStack getFilter(int subFrameIndex) {
        return this.filters[subFrameIndex];
    }

    ItemStack[] getFilters() {
        return this.filters;
    }

    public void extractItem(int subFrameIndex) {
        if (this.filters[subFrameIndex] != null) {
            IItemHandler inventory = CommonUtils.getConnectedInventory(this.field_145850_b, this.field_174879_c);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack output;
                ItemStack stack = inventory.getStackInSlot(i);
                if (!this.isMatchingItem(this.filters[subFrameIndex], stack) || (output = inventory.extractItem(i, 1, false)) == null) continue;
                CommonUtils.ejectItem(this.field_145850_b, this.field_174879_c, subFrameIndex, output);
                return;
            }
        }
    }

    public void extractStack(int subFrameIndex) {
        if (this.filters[subFrameIndex] != null) {
            ItemStack output = this.filters[subFrameIndex].func_77946_l();
            output.field_77994_a = 0;
            IItemHandler inventory = CommonUtils.getConnectedInventory(this.field_145850_b, this.field_174879_c);
            int count = this.filters[subFrameIndex].func_77976_d();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (this.isMatchingItem(output, inventory.getStackInSlot(i))) {
                    ItemStack extractStack = inventory.extractItem(i, count, false);
                    count -= extractStack.field_77994_a;
                    output.field_77994_a += extractStack.field_77994_a;
                }
                if (count <= 0) break;
            }
            CommonUtils.ejectItem(this.field_145850_b, this.field_174879_c, subFrameIndex, output);
        }
    }

    public void insertStack(EntityPlayer player, int subFrameIndex) {
        IItemHandler inventory;
        ItemStack leftOvers;
        ItemStack heldStack = player.func_184614_ca();
        this.trySetFilter(heldStack, subFrameIndex);
        if (heldStack != null && this.isMatchingItem(this.filters[subFrameIndex], heldStack) && (leftOvers = ItemHandlerHelper.insertItemStacked((IItemHandler)(inventory = CommonUtils.getConnectedInventory(this.field_145850_b, this.field_174879_c)), (ItemStack)heldStack, (boolean)false)) != heldStack) {
            player.func_184201_a(EntityEquipmentSlot.MAINHAND, leftOvers);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.0625f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.55f);
    }

    public void insertAllStacks(EntityPlayer playerIn, int subFrameIndex) {
        ItemStack heldStack = playerIn.func_184614_ca();
        this.trySetFilter(heldStack, subFrameIndex);
        boolean didInsertItem = false;
        IItemHandler inventory = CommonUtils.getConnectedInventory(this.field_145850_b, this.field_174879_c);
        InventoryPlayer playerInventory = playerIn.field_71071_by;
        for (int i = 0; i < playerInventory.field_70462_a.length; ++i) {
            ItemStack stack = playerInventory.field_70462_a[i];
            if (stack == null || stack.field_77994_a <= 0 || !this.isMatchingItem(this.filters[subFrameIndex], stack)) continue;
            ItemStack returnStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
            if (stack != returnStack) {
                didInsertItem = true;
            }
            playerInventory.field_70462_a[i] = returnStack;
        }
        if (didInsertItem) {
            playerIn.field_71071_by.func_70296_d();
            playerIn.field_71069_bz.func_75142_b();
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.0625f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.55f);
    }

    private boolean isMatchingItem(ItemStack base, ItemStack comparison) {
        return ItemStack.func_179545_c((ItemStack)base, (ItemStack)comparison) && ItemStack.func_77970_a((ItemStack)base, (ItemStack)comparison);
    }

    public void performInstantBreak() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        if (!block.isAir(state, (IBlockAccess)this.field_145850_b, this.field_174879_c) && block instanceof BlockItemFrame) {
            block.func_176226_b(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), 0);
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    boolean areAnyFiltersSet() {
        boolean ret = false;
        for (ItemStack s : this.filters) {
            ret |= s != null;
        }
        return ret;
    }

    public static enum Action {
        NONE(0, "none"),
        EXTRACT_ITEM(1, "extract_item"),
        EXTRACT_STACK(2, "extract_stack"),
        INSERT_STACK(3, "insert_stack"),
        INSERT_ALL_STACKS(4, "insert_all_stacks"),
        INSTANT_BREAK(5, "instant_break");

        private final int index;
        private final String name;
        public static final Action[] VALUES;
        public static final String[] VALID_NAMES;
        private static final Map<String, Action> NAME_LOOKUP;

        private Action(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Action byName(String name) {
            return name == null ? null : NAME_LOOKUP.get(name.toLowerCase());
        }

        static {
            VALUES = new Action[6];
            VALID_NAMES = new String[6];
            NAME_LOOKUP = Maps.newHashMap();
            Action[] actionArray = Action.values();
            int n = actionArray.length;
            for (int i = 0; i < n; ++i) {
                Action a;
                Action.VALUES[a.index] = a = actionArray[i];
                NAME_LOOKUP.put(a.toString().toLowerCase(), a);
                Action.VALID_NAMES[a.index] = a.toString().toLowerCase();
            }
        }
    }
}

