/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.itemframe.nbt;

import edgarallen.mods.scf.blocks.itemframe.TileEntityItemFrame;
import edgarallen.mods.scf.util.EnumType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemFrameNBTReader {
    public static void readFromNBT(TileEntityItemFrame tile, NBTTagCompound compound) {
        NBTTagCompound rootCompound = ItemFrameNBTReader.readRootTagCompoundFromNBT(compound);
        int version = ItemFrameNBTReader.readVersionFromNBT(rootCompound);
        if (ItemFrameNBTReader.shouldUseLegacyReader(version)) {
            return;
        }
        ItemFrameNBTReader.readFrameTypeFromNBT(tile, rootCompound);
        ItemFrameNBTReader.readFiltersFromNBT(tile, rootCompound);
    }

    public static NBTTagCompound readRootTagCompoundFromNBT(NBTTagCompound compound) {
        NBTTagList itemFrameTagList = compound.func_150295_c("itemFrame", 10);
        return itemFrameTagList.func_150305_b(0);
    }

    private static int readVersionFromNBT(NBTTagCompound compound) {
        return compound.func_74764_b("version") ? (int)compound.func_74771_c("version") : -1;
    }

    private static void readFrameTypeFromNBT(TileEntityItemFrame tile, NBTTagCompound compound) {
        tile.initFrame(EnumType.getType(compound.func_74771_c("type")));
    }

    private static void readFiltersFromNBT(TileEntityItemFrame tile, NBTTagCompound rootCompound) {
        NBTTagList filtersTagList = rootCompound.func_150295_c("filters", 10);
        for (int i = 0; i < filtersTagList.func_74745_c(); ++i) {
            NBTTagCompound compound = filtersTagList.func_150305_b(i);
            byte filterIndex = compound.func_74771_c("index");
            ItemStack stack = ItemFrameNBTReader.readFilterFromNBT(compound);
            tile.setFilter(stack, filterIndex);
        }
    }

    private static ItemStack readFilterFromNBT(NBTTagCompound compound) {
        NBTTagList itemRoot = compound.func_150295_c("item", 10);
        NBTTagCompound itemCompound = itemRoot.func_150305_b(0);
        return ItemStack.func_77949_a((NBTTagCompound)itemCompound);
    }

    private static boolean shouldUseLegacyReader(int version) {
        return version < 1;
    }

    public static EnumType readFrameTypeFromNBT(NBTTagCompound rootCompound) {
        return EnumType.getType(rootCompound.func_74771_c("type"));
    }

    public static ItemStack[] readFiltersFromNBT(int size, NBTTagCompound rootCompound) {
        ItemStack[] filters = new ItemStack[size];
        NBTTagList filtersTagList = rootCompound.func_150295_c("filters", 10);
        for (int i = 0; i < filtersTagList.func_74745_c(); ++i) {
            ItemStack stack;
            NBTTagCompound compound = filtersTagList.func_150305_b(i);
            byte filterIndex = compound.func_74771_c("index");
            filters[filterIndex] = stack = ItemFrameNBTReader.readFilterFromNBT(compound);
        }
        return filters;
    }
}

