/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.teleportationframe;

import edgarallen.mods.scf.blocks.common.TileEntityBaseFrame;
import edgarallen.mods.scf.blocks.teleportationframe.nbt.DestinationMarkerNBTReader;
import edgarallen.mods.scf.blocks.teleportationframe.nbt.TeleportationFrameNBTReader;
import edgarallen.mods.scf.blocks.teleportationframe.nbt.TeleportationFrameNBTWriter;
import edgarallen.mods.scf.config.Config;
import edgarallen.mods.scf.items.ModItems;
import edgarallen.mods.scf.util.CommonUtils;
import edgarallen.mods.scf.util.EnumType;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TileEntityTeleportationFrame
extends TileEntityBaseFrame {
    private ItemStack[] destinations = new ItemStack[1];

    @Override
    public void initFrame(EnumType type) {
        super.initFrame(type);
        this.destinations = new ItemStack[type.getIndex() + 1];
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        TeleportationFrameNBTReader.readFromNBT(this, data);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        TeleportationFrameNBTWriter.writeToNBT(this.type, this.destinations, data);
        return data;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        TeleportationFrameNBTWriter.writeToNBT(this.type, this.destinations, compound);
        return compound;
    }

    public ItemStack[] getDestinations() {
        return this.destinations;
    }

    public ItemStack getDestination(int subframeIndex) {
        return this.destinations[subframeIndex];
    }

    public boolean setDestinationAndUpdate(ItemStack stack, int subFrameIndex) {
        if (stack == null || stack.func_77973_b() != ModItems.destinationMarkerItem || this.destinations[subFrameIndex] != null) {
            return false;
        }
        this.destinations[subFrameIndex] = stack.func_77979_a(1);
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        return true;
    }

    public void setDestination(ItemStack stack, int subFrameIndex) {
        this.destinations[subFrameIndex] = stack;
    }

    public void removeDestination(int subFrameIndex) {
        CommonUtils.ejectItem(this.field_145850_b, this.field_174879_c, subFrameIndex, this.destinations[subFrameIndex]);
        this.destinations[subFrameIndex] = null;
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void teleportPlayer(World world, EntityPlayer player, int subFrameIndex) {
        player.func_184210_p();
        ItemStack destination = this.destinations[subFrameIndex];
        if (destination != null && DestinationMarkerNBTReader.hasDestinationSet(destination)) {
            Vec3d destPos = DestinationMarkerNBTReader.getDestinationPosition(destination);
            float destYaw = DestinationMarkerNBTReader.getDestinationYaw(destination);
            if (!TileEntityTeleportationFrame.isDestinationWithinRange(new Vec3d((Vec3i)this.field_174879_c), destPos)) {
                this.teleportPlayerRandomly(world, player);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.super_teleportation_frame.error.out_of_range", new Object[0]));
                return;
            }
            double soundX = player.field_70165_t;
            double soundY = player.field_70163_u;
            double soundZ = player.field_70161_v;
            player.field_70177_z = destYaw;
            player.func_70634_a(destPos.field_72450_a, destPos.field_72448_b, destPos.field_72449_c);
            world.func_184148_a(null, soundX, soundY, soundZ, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
            world.func_184148_a(null, destPos.field_72450_a, destPos.field_72448_b, destPos.field_72449_c, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
        } else {
            this.teleportPlayerRandomly(world, player);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.super_teleportation_frame.error.destination_not_set", new Object[0]));
        }
    }

    private void teleportPlayerRandomly(World world, EntityPlayer player) {
        double startX = player.field_70165_t;
        double startY = player.field_70163_u;
        double startZ = player.field_70161_v;
        for (int i = 0; i < 16; ++i) {
            double destZ;
            double destY;
            double destX = player.field_70165_t + (player.func_70681_au().nextDouble() - 0.5) * 16.0;
            if (!player.func_184595_k(destX, destY = MathHelper.func_151237_a((double)(player.field_70163_u + (double)(player.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)(world.func_72940_L() - 1)), destZ = player.field_70161_v + (player.func_70681_au().nextDouble() - 0.5) * 16.0)) continue;
            world.func_184148_a(null, startX, startY, startZ, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
            player.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
            break;
        }
    }

    private static boolean isDestinationWithinRange(Vec3d source, Vec3d dest) {
        boolean isOutOfRange = false;
        if (Config.teleportationFrameMaxDistance > 0) {
            isOutOfRange = MathHelper.func_76135_e((float)((float)(source.field_72450_a - dest.field_72450_a))) > (float)Config.teleportationFrameMaxDistance;
            isOutOfRange |= !Config.teleportationFrameIgnoreYAxis && MathHelper.func_76135_e((float)((float)(source.field_72448_b - dest.field_72448_b))) > (float)Config.teleportationFrameMaxDistance;
            isOutOfRange |= MathHelper.func_76135_e((float)((float)(source.field_72449_c - dest.field_72449_c))) > (float)Config.teleportationFrameMaxDistance;
        }
        return !isOutOfRange;
    }

    boolean areAnyDestinationsSet() {
        boolean ret = false;
        for (ItemStack s : this.destinations) {
            ret |= s != null;
        }
        return ret;
    }
}

