/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.teleportationframe.compat;

import edgarallen.mods.scf.blocks.ModBlocks;
import edgarallen.mods.scf.blocks.teleportationframe.BlockTeleportationFrame;
import edgarallen.mods.scf.blocks.teleportationframe.TileEntityTeleportationFrame;
import edgarallen.mods.scf.blocks.teleportationframe.nbt.DestinationMarkerNBTReader;
import edgarallen.mods.scf.util.CommonUtils;
import edgarallen.mods.scf.util.EnumPlacement;
import edgarallen.mods.scf.util.EnumType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class TeleportationFrameWailaDataProvider
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntityTeleportationFrame tile = (TileEntityTeleportationFrame)accessor.getTileEntity();
        if (tile != null) {
            switch (tile.getType()) {
                case SINGLE: {
                    return null;
                }
                case DOUBLE: {
                    return new ItemStack((Block)ModBlocks.teleportationFrame, 1, 1);
                }
                case TRIPLE: {
                    return new ItemStack((Block)ModBlocks.teleportationFrame, 1, 2);
                }
                case QUAD: {
                    return new ItemStack((Block)ModBlocks.teleportationFrame, 1, 3);
                }
            }
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntityTeleportationFrame tile = (TileEntityTeleportationFrame)accessor.getTileEntity();
        EnumType type = tile.getType();
        switch (tile.getType()) {
            case SINGLE: {
                tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.single.tooltip.subheader"));
                break;
            }
            case DOUBLE: {
                tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.double.tooltip.subheader"));
                break;
            }
            case TRIPLE: {
                tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.triple.tooltip.subheader"));
                break;
            }
            case QUAD: {
                tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.quad.tooltip.subheader"));
            }
        }
        RayTraceResult ray = Minecraft.func_71410_x().field_71476_x;
        BlockPos hitPos = ray.func_178782_a();
        float hitX = (float)(ray.field_72307_f.field_72450_a - (double)hitPos.func_177958_n());
        float hitY = (float)(ray.field_72307_f.field_72448_b - (double)hitPos.func_177956_o());
        float hitZ = (float)(ray.field_72307_f.field_72449_c - (double)hitPos.func_177952_p());
        IBlockState state = accessor.getBlockState();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockTeleportationFrame.FACING);
        EnumPlacement placement = (EnumPlacement)((Object)state.func_177229_b((IProperty)BlockTeleportationFrame.PLACEMENT));
        int subFrameIndex = CommonUtils.getSubFrameIndex(type, facing, placement, hitX, hitY, hitZ);
        ItemStack stack = tile.getDestination(subFrameIndex);
        if (stack != null && DestinationMarkerNBTReader.hasDestinationSet(stack)) {
            String languageKey = "item.destination_marker.tooltip.destination.coords";
            boolean showCoords = true;
            if (stack.func_82837_s()) {
                tooltip.add(I18n.func_74837_a((String)"item.super_teleportation_frame.tooltip.destination.name", (Object[])new Object[]{stack.func_82833_r()}));
                languageKey = "item.super_teleportation_frame.tooltip.destination.coords";
                showCoords = GuiScreen.func_146272_n();
            }
            if (showCoords) {
                Vec3d dest = DestinationMarkerNBTReader.getDestinationPosition(stack);
                tooltip.add(I18n.func_74837_a((String)languageKey, (Object[])new Object[]{new BigDecimal(dest.field_72450_a).setScale(4, RoundingMode.HALF_UP).doubleValue(), new BigDecimal(dest.field_72448_b).setScale(4, RoundingMode.HALF_UP).doubleValue(), new BigDecimal(dest.field_72449_c).setScale(4, RoundingMode.HALF_UP).doubleValue()}));
            }
        } else {
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
        }
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)new TeleportationFrameWailaDataProvider(), TileEntityTeleportationFrame.class);
        registrar.registerStackProvider((IWailaDataProvider)new TeleportationFrameWailaDataProvider(), TileEntityTeleportationFrame.class);
    }
}

