/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.teleportationframe.nbt;

import edgarallen.mods.scf.blocks.teleportationframe.TileEntityTeleportationFrame;
import edgarallen.mods.scf.util.EnumType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TeleportationFrameNBTReader {
    public static void readFromNBT(TileEntityTeleportationFrame tile, NBTTagCompound compound) {
        NBTTagCompound rootCompound = TeleportationFrameNBTReader.readRootTagCompoundFromNBT(compound);
        int version = TeleportationFrameNBTReader.readVersionFromNBT(rootCompound);
        if (TeleportationFrameNBTReader.shouldUseLegacyReader(version)) {
            return;
        }
        TeleportationFrameNBTReader.readFrameTypeFromNBT(tile, rootCompound);
        TeleportationFrameNBTReader.readDestinationsFromNBT(tile, rootCompound);
    }

    public static NBTTagCompound readRootTagCompoundFromNBT(NBTTagCompound compound) {
        NBTTagList itemFrameTagList = compound.func_150295_c("tpFrame", 10);
        return itemFrameTagList.func_150305_b(0);
    }

    public static ItemStack[] readDestinationsFromNBT(int size, NBTTagCompound rootCompound) {
        ItemStack[] destinations = new ItemStack[size];
        NBTTagList destinationsTagList = rootCompound.func_150295_c("destinations", 10);
        for (int i = 0; i < destinationsTagList.func_74745_c(); ++i) {
            NBTTagCompound compound = destinationsTagList.func_150305_b(i);
            byte index = compound.func_74771_c("index");
            destinations[index] = TeleportationFrameNBTReader.readDestinationFromNBT(compound);
        }
        return destinations;
    }

    public static EnumType readFrameTypeFromNBT(NBTTagCompound compound) {
        return EnumType.getType(compound.func_74771_c("type"));
    }

    private static int readVersionFromNBT(NBTTagCompound compound) {
        return compound.func_74764_b("version") ? (int)compound.func_74771_c("version") : -1;
    }

    private static void readFrameTypeFromNBT(TileEntityTeleportationFrame tile, NBTTagCompound compound) {
        tile.initFrame(EnumType.getType(compound.func_74771_c("type")));
    }

    private static void readDestinationsFromNBT(TileEntityTeleportationFrame tile, NBTTagCompound rootCompound) {
        NBTTagList destinationsTagList = rootCompound.func_150295_c("destinations", 10);
        for (int i = 0; i < destinationsTagList.func_74745_c(); ++i) {
            NBTTagCompound compound = destinationsTagList.func_150305_b(i);
            byte index = compound.func_74771_c("index");
            ItemStack stack = TeleportationFrameNBTReader.readDestinationFromNBT(compound);
            tile.setDestination(stack, index);
        }
    }

    private static ItemStack readDestinationFromNBT(NBTTagCompound compound) {
        NBTTagList itemRoot = compound.func_150295_c("destination", 10);
        NBTTagCompound itemCompound = itemRoot.func_150305_b(0);
        return ItemStack.func_77949_a((NBTTagCompound)itemCompound);
    }

    private static boolean shouldUseLegacyReader(int version) {
        return version < 1;
    }
}

