/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.config;

import edgarallen.mods.scf.SuperCraftingFrame;
import edgarallen.mods.scf.blocks.craftingframe.core.PlayerInteractAction;
import edgarallen.mods.scf.blocks.itemframe.TileEntityItemFrame;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    public static Configuration config;
    public static PlayerInteractAction craftingFrameRightClickAction;
    public static PlayerInteractAction craftingFrameSneakRightClickAction;
    public static PlayerInteractAction craftingFrameLeftClickAction;
    public static PlayerInteractAction craftingFrameSneakLeftClickAction;
    public static TileEntityItemFrame.Action itemFrameRightClick;
    public static TileEntityItemFrame.Action itemFrameSneakRightClick;
    public static TileEntityItemFrame.Action itemFrameLeftClick;
    public static TileEntityItemFrame.Action itemFrameSneakLeftClick;
    public static int teleportationFrameMaxDistance;
    public static boolean teleportationFrameIgnoreYAxis;
    public static int xpBottleCapacity;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        Config.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConfig() {
        try {
            config.load();
            config.addCustomCategoryComment("crafting_frame_actions", "Set actions to perform when interacting with the crafting frame. ['craft_item', 'craft_stack', 'open_gui', 'instant_break', 'none']");
            String[] validCraftingFrameActionNames = PlayerInteractAction.VALID_NAMES;
            Property craftingFrameRightClickProp = config.get("crafting_frame_actions", "right_click.action", PlayerInteractAction.CRAFT_ITEM.toString());
            craftingFrameRightClickProp.setValidValues(validCraftingFrameActionNames);
            craftingFrameRightClickProp.setLanguageKey("config.super_crafting_frame.actions.right_click");
            craftingFrameRightClickAction = PlayerInteractAction.byName(craftingFrameRightClickProp.getString());
            Property craftingFrameSneakRightClickProp = config.get("crafting_frame_actions", "sneak_right_click.action", PlayerInteractAction.CRAFT_STACK.toString());
            craftingFrameSneakRightClickProp.setValidValues(validCraftingFrameActionNames);
            craftingFrameSneakRightClickProp.setLanguageKey("config.super_crafting_frame.actions.sneak_right_click");
            craftingFrameSneakRightClickAction = PlayerInteractAction.byName(craftingFrameSneakRightClickProp.getString());
            Property craftingFrameLeftClickProp = config.get("crafting_frame_actions", "left_click.action", PlayerInteractAction.NONE.toString());
            craftingFrameLeftClickProp.setValidValues(validCraftingFrameActionNames);
            craftingFrameLeftClickProp.setLanguageKey("config.super_crafting_frame.actions.left_click");
            craftingFrameLeftClickAction = PlayerInteractAction.byName(craftingFrameLeftClickProp.getString());
            Property craftingFrameSneakLeftClickProp = config.get("crafting_frame_actions", "sneak_left_click.action", PlayerInteractAction.OPEN_GUI.toString());
            craftingFrameSneakLeftClickProp.setValidValues(validCraftingFrameActionNames);
            craftingFrameSneakLeftClickProp.setLanguageKey("config.super_crafting_frame.actions.sneak_left_click");
            craftingFrameSneakLeftClickAction = PlayerInteractAction.byName(craftingFrameSneakLeftClickProp.getString());
            config.addCustomCategoryComment("item_frame_actions", "Set actions to perform when interacting with the item frame. ['extract_item', 'extract_stack', 'insert_stack', 'insert_all_stacks', 'none']");
            String[] validItemFrameActionNames = TileEntityItemFrame.Action.VALID_NAMES;
            Property itemFrameRightClickProp = config.get("item_frame_actions", "right_click.action", TileEntityItemFrame.Action.INSERT_STACK.toString());
            itemFrameRightClickProp.setValidValues(validItemFrameActionNames);
            itemFrameRightClickProp.setLanguageKey("config.super_item_frame.actions.right_click");
            itemFrameRightClick = TileEntityItemFrame.Action.byName(itemFrameRightClickProp.getString());
            Property itemFrameSneakRightClickProp = config.get("item_frame_actions", "sneak_right_click.action", TileEntityItemFrame.Action.INSERT_ALL_STACKS.toString());
            itemFrameSneakRightClickProp.setValidValues(validItemFrameActionNames);
            itemFrameSneakRightClickProp.setLanguageKey("config.super_item_frame.actions.sneak_right_click");
            itemFrameSneakRightClick = TileEntityItemFrame.Action.byName(itemFrameSneakRightClickProp.getString());
            Property itemFrameLeftClickProp = config.get("item_frame_actions", "left_click.action", TileEntityItemFrame.Action.EXTRACT_STACK.toString());
            itemFrameLeftClickProp.setValidValues(validItemFrameActionNames);
            itemFrameLeftClickProp.setLanguageKey("config.super_item_frame.actions.left_click");
            itemFrameLeftClick = TileEntityItemFrame.Action.byName(itemFrameLeftClickProp.getString());
            Property itemFrameSneakLeftClickProp = config.get("item_frame_actions", "sneak_left_click.action", TileEntityItemFrame.Action.EXTRACT_ITEM.toString());
            itemFrameSneakLeftClickProp.setValidValues(validItemFrameActionNames);
            itemFrameSneakLeftClickProp.setLanguageKey("config.super_item_frame.actions.sneak_left_click");
            itemFrameSneakLeftClick = TileEntityItemFrame.Action.byName(itemFrameSneakLeftClickProp.getString());
            config.addCustomCategoryComment("server_settings", "Server side settings. Setting these on the client do nothing.");
            Property teleportationFrameMaxDistanceProp = config.get("server_settings", "teleportation_frame_max_distance", 0);
            teleportationFrameMaxDistanceProp.setLanguageKey("config.super_teleportation_frame.server.max_distance");
            teleportationFrameMaxDistanceProp.setComment(I18n.func_74838_a((String)"config.super_teleportation_frame.server.max_distance.tooltip"));
            teleportationFrameMaxDistance = teleportationFrameMaxDistanceProp.getInt();
            Property teleportationFrameIgnoreYAxisProp = config.get("server_settings", "teleportation_frame_ignore_y_axis", true);
            teleportationFrameIgnoreYAxisProp.setLanguageKey("config.super_teleportation_frame.server.ignore_y_axis");
            teleportationFrameIgnoreYAxisProp.setComment(I18n.func_74838_a((String)"config.super_teleportation_frame.server.ignore_y_axis.tooltip"));
            teleportationFrameIgnoreYAxis = teleportationFrameIgnoreYAxisProp.getBoolean();
            Property xpBottleCapacityProp = config.get("server_settings", "xp_frame_bottle_capacity", 16);
            xpBottleCapacityProp.setLanguageKey("config.super_xp_frame.server.xp_bottle_capacity");
            xpBottleCapacityProp.setComment(I18n.func_74838_a((String)"config.super_xp_frame.server.xp_bottle_capacity.tooltip"));
            xpBottleCapacity = xpBottleCapacityProp.getInt();
        }
        catch (Exception e) {
            SuperCraftingFrame.log.error("failed to load config file", (Throwable)e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("supercraftingframe")) {
            if (config.hasChanged()) {
                config.save();
            }
            Config.loadConfig();
        }
    }

    public static List<IConfigElement> getCraftingFrameConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("crafting_frame_actions")).getChildElements());
        return list;
    }

    public static List<IConfigElement> getItemFrameConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("item_frame_actions")).getChildElements());
        return list;
    }

    public static List<IConfigElement> getServerConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("server_settings")).getChildElements());
        return list;
    }
}

