/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.geometry.Area2D;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.render.ChamRenderManager;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.render.IRenderLabel;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerSealedModel;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStatus;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityDrawersRenderer
extends TileEntitySpecialRenderer<TileEntityDrawers> {
    private boolean[] renderAsBlock = new boolean[4];
    private ItemStack[] renderStacks = new ItemStack[4];
    private RenderItem renderItem;
    private float[] itemOffset1X = new float[]{0.5f};
    private float[] itemOffset1Y = new float[]{8.25f};
    private float[] itemOffset2X = new float[]{0.5f, 0.5f};
    private float[] itemOffset2Y = new float[]{10.25f, 2.25f};
    private float[] itemOffset4X = new float[]{0.25f, 0.25f, 0.75f, 0.75f};
    private float[] itemOffset4Y = new float[]{10.25f, 2.25f, 10.25f, 2.25f};
    private float[] itemOffset3X = new float[]{0.5f, 0.25f, 0.75f};
    private float[] itemOffset3Y = new float[]{9.75f, 2.25f, 2.25f};
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f};
    private static final float[] offsetX = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};

    public void renderTileEntityAt(TileEntityDrawers tile, double x, double y, double z, float partialTickTime, int destroyStage) {
        if (tile == null) {
            return;
        }
        float depth = 1.0f;
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state == null) {
            return;
        }
        Block block = state.func_177230_c();
        if (block instanceof BlockDrawers) {
            if (state.func_177228_b().containsKey((Object)BlockDrawers.BLOCK)) {
                EnumBasicDrawer info = (EnumBasicDrawer)((Object)state.func_177229_b((IProperty)BlockDrawers.BLOCK));
                depth = info.isHalfDepth() ? 0.5f : 1.0f;
            }
        } else {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        this.renderItem = Minecraft.func_71410_x().func_175599_af();
        EnumFacing side = EnumFacing.func_82600_a((int)tile.getDirection());
        int ambLight = this.func_178459_a().func_175626_b(tile.func_174877_v().func_177972_a(side), 0);
        int lu = ambLight % 65536;
        int lv = ambLight / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lu / 1.0f), (float)((float)lv / 1.0f));
        ChamRender renderer = ChamRenderManager.instance.getRenderer(Tessellator.func_178181_a().func_178180_c());
        Minecraft mc = Minecraft.func_71410_x();
        boolean cache = mc.field_71474_y.field_74347_j;
        mc.field_71474_y.field_74347_j = true;
        if (!tile.isShrouded() && !tile.isSealed()) {
            this.renderFastItemSet(renderer, tile, state, side, depth, partialTickTime);
        }
        mc.field_71474_y.field_74347_j = cache;
        this.renderUpgrades(renderer, tile, state);
        GlStateManager.func_179145_e();
        GlStateManager.func_179085_a((int)0);
        GlStateManager.func_179085_a((int)1);
        GlStateManager.func_179142_g();
        GlStateManager.func_179104_a((int)1032, (int)5634);
        GlStateManager.func_179101_C();
        GlStateManager.func_179133_A();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        ChamRenderManager.instance.releaseRenderer(renderer);
    }

    private void renderFastItemSet(ChamRender renderer, TileEntityDrawers tile, IBlockState state, EnumFacing side, float depth, float partialTickTime) {
        int i;
        int drawerCount = tile.getDrawerCount();
        boolean restoreItemState = false;
        boolean restoreBlockState = false;
        for (i = 0; i < drawerCount; ++i) {
            IDrawer drawer;
            ItemStack itemStack;
            this.renderStacks[i] = null;
            if (!tile.isDrawerEnabled(i) || (itemStack = (drawer = tile.getDrawer(i)).getStoredItemPrototype()) == null) continue;
            this.renderStacks[i] = itemStack;
            this.renderAsBlock[i] = this.isItemBlockType(itemStack);
            if (this.renderAsBlock[i]) {
                restoreBlockState = true;
                continue;
            }
            restoreItemState = true;
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i] == null || this.renderAsBlock[i]) continue;
            this.renderFastItem(renderer, this.renderStacks[i], tile, state, i, side, depth, partialTickTime);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i] == null || !this.renderAsBlock[i]) continue;
            this.renderFastItem(renderer, this.renderStacks[i], tile, state, i, side, depth, partialTickTime);
        }
    }

    private void renderFastItem(ChamRender renderer, ItemStack itemStack, TileEntityDrawers tile, IBlockState state, int slot, EnumFacing side, float depth, float partialTickTime) {
        int drawerCount = tile.getDrawerCount();
        float xunit = this.getXOffset(drawerCount, slot);
        float yunit = this.getYOffset(drawerCount, slot);
        float size = drawerCount == 1 ? 0.5f : 0.25f;
        BlockDrawers block = (BlockDrawers)state.func_177230_c();
        StatusModelData statusInfo = block.getStatusInfo(state);
        float frontDepth = (float)statusInfo.getFrontDepth() * 0.0625f;
        GlStateManager.func_179094_E();
        this.alignRendering(side);
        this.moveRendering(size, this.getOffsetXForSide(side, xunit) * 16.0f - 8.0f * size, 12.25f - yunit, 1.0f - depth + frontDepth - 0.005f);
        List<IRenderLabel> renderHandlers = StorageDrawers.renderRegistry.getRenderHandlers();
        int n = renderHandlers.size();
        for (int i = 0; i < n; ++i) {
            renderHandlers.get(i).render((TileEntity)tile, tile, slot, 0.0f, partialTickTime);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179088_q();
        GlStateManager.func_179136_a((float)-1.0f, (float)-1.0f);
        this.renderItem.func_175042_a(itemStack, 0, 0);
        GlStateManager.func_179113_r();
        GlStateManager.func_179121_F();
    }

    private boolean isItemBlockType(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ItemBlock && this.renderItem.func_175050_a(itemStack);
    }

    private float getXOffset(int drawerCount, int slot) {
        switch (drawerCount) {
            case 1: {
                return this.itemOffset1X[slot];
            }
            case 2: {
                return this.itemOffset2X[slot];
            }
            case 3: {
                return this.itemOffset3X[slot];
            }
            case 4: {
                return this.itemOffset4X[slot];
            }
        }
        return 0.0f;
    }

    private float getYOffset(int drawerCount, int slot) {
        switch (drawerCount) {
            case 1: {
                return this.itemOffset1Y[slot];
            }
            case 2: {
                return this.itemOffset2Y[slot];
            }
            case 3: {
                return this.itemOffset3Y[slot];
            }
            case 4: {
                return this.itemOffset4Y[slot];
            }
        }
        return 0.0f;
    }

    private void alignRendering(EnumFacing side) {
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)this.getRotationYForSide2D(side), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
    }

    private void moveRendering(float size, float offsetX, float offsetY, float offsetZ) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)offsetZ);
        GlStateManager.func_179152_a((float)0.0625f, (float)0.0625f, (float)-1.0E-5f);
        GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)0.0f);
        GlStateManager.func_179152_a((float)size, (float)size, (float)1.0f);
    }

    private float getRotationYForSide2D(EnumFacing side) {
        return sideRotationY2D[side.ordinal()] * 90.0f;
    }

    private float getOffsetXForSide(EnumFacing side, float x) {
        return Math.abs(offsetX[side.ordinal()] - x);
    }

    private void renderUpgrades(ChamRender renderer, TileEntityDrawers tile, IBlockState state) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179141_d();
        this.renderIndicator(renderer, tile, state, tile.getDirection(), tile.getEffectiveStatusLevel());
        this.renderTape(renderer, tile, state, tile.getDirection(), tile.isSealed());
    }

    private void renderIndicator(ChamRender renderer, TileEntityDrawers tile, IBlockState blockState, int side, int level) {
        if (level <= 0 || side < 2 || side > 5) {
            return;
        }
        BlockDrawers block = (BlockDrawers)blockState.func_177230_c();
        StatusModelData statusInfo = block.getStatusInfo(blockState);
        if (statusInfo == null) {
            return;
        }
        double depth = block.isHalfDepth(blockState) ? 0.5 : 1.0;
        int count = tile instanceof TileEntityDrawersComp ? 1 : block.getDrawerCount(blockState);
        double unit = 0.0625;
        double frontDepth = statusInfo.getFrontDepth() * unit;
        for (int i = 0; i < count; ++i) {
            IDrawer drawer = tile.getDrawer(i);
            if (drawer == null) continue;
            TextureAtlasSprite iconOff = Chameleon.instance.iconRegistry.getIcon(statusInfo.getSlot(i).getOffResource(EnumUpgradeStatus.byLevel(level)));
            TextureAtlasSprite iconOn = Chameleon.instance.iconRegistry.getIcon(statusInfo.getSlot(i).getOnResource(EnumUpgradeStatus.byLevel(level)));
            Area2D statusArea = statusInfo.getSlot(i).getStatusArea();
            Area2D activeArea = statusInfo.getSlot(i).getStatusActiveArea();
            GlStateManager.func_179088_q();
            GlStateManager.func_179136_a((float)-1.0f, (float)-1.0f);
            renderer.setRenderBounds(statusArea.getX() * unit, statusArea.getY() * unit, 0.0, (statusArea.getX() + statusArea.getWidth()) * unit, (statusArea.getY() + statusArea.getHeight()) * unit, depth - frontDepth);
            renderer.state.setRotateTransform(3, side);
            renderer.renderFace(ChamRender.FACE_ZPOS, null, blockState, BlockPos.field_177992_a, iconOff, 1.0f, 1.0f, 1.0f);
            renderer.state.clearRotateTransform();
            GlStateManager.func_179136_a((float)-1.0f, (float)-10.0f);
            if (level == 1 && drawer.getMaxCapacity() > 0 && drawer.getRemainingCapacity() == 0) {
                renderer.setRenderBounds(statusArea.getX() * unit, statusArea.getY() * unit, 0.0, (statusArea.getX() + statusArea.getWidth()) * unit, (statusArea.getY() + statusArea.getHeight()) * unit, depth - frontDepth);
                renderer.state.setRotateTransform(3, side);
                renderer.renderFace(ChamRender.FACE_ZPOS, null, blockState, BlockPos.field_177992_a, iconOn, 1.0f, 1.0f, 1.0f);
                renderer.state.clearRotateTransform();
            } else if (level >= 2) {
                double indYCur;
                int stepX = statusInfo.getSlot(i).getActiveStepsX();
                int stepY = statusInfo.getSlot(i).getActiveStepsY();
                double indXStart = activeArea.getX();
                double indXEnd = activeArea.getX() + activeArea.getWidth();
                double indXCur = stepX == 0 ? indXEnd : this.getIndEnd(block, tile, i, indXStart, activeArea.getWidth(), stepX);
                double indYStart = activeArea.getY();
                double indYEnd = activeArea.getY() + activeArea.getHeight();
                double d = indYCur = stepY == 0 ? indYEnd : this.getIndEnd(block, tile, i, indYStart, activeArea.getHeight(), stepY);
                if (indXCur > indXStart && indYCur > indYStart) {
                    indXCur = Math.min(indXCur, indXEnd);
                    indYCur = Math.min(indYCur, indYEnd);
                    renderer.setRenderBounds(indXStart * unit, indYStart * unit, 0.0, indXCur * unit, indYCur * unit, depth - frontDepth);
                    renderer.state.setRotateTransform(3, side);
                    renderer.renderFace(ChamRender.FACE_ZPOS, null, blockState, BlockPos.field_177992_a, iconOn, 1.0f, 1.0f, 1.0f);
                    renderer.state.clearRotateTransform();
                }
            }
            GlStateManager.func_179113_r();
        }
    }

    private void renderTape(ChamRender renderer, TileEntityDrawers tile, IBlockState blockState, int side, boolean taped) {
        if (!taped || side < 2 || side > 5) {
            return;
        }
        BlockDrawers block = (BlockDrawers)blockState.func_177230_c();
        double depth = block.isHalfDepth(blockState) ? 0.5 : 1.0;
        TextureAtlasSprite iconTape = Chameleon.instance.iconRegistry.getIcon(DrawerSealedModel.iconTapeCover);
        GlStateManager.func_179088_q();
        GlStateManager.func_179136_a((float)-1.0f, (float)-1.0f);
        renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, depth);
        renderer.state.setRotateTransform(3, side);
        renderer.renderPartialFace(ChamRender.FACE_ZPOS, null, blockState, BlockPos.field_177992_a, iconTape, 0.0, 0.0, 1.0, 1.0, 1.0f, 1.0f, 1.0f);
        renderer.state.clearRotateTransform();
        GlStateManager.func_179113_r();
    }

    private double getIndEnd(BlockDrawers block, TileEntityDrawers tile, int slot, double x, double w, int step) {
        IDrawer drawer = tile.getDrawer(slot);
        if (drawer == null) {
            return x;
        }
        int cap = drawer.getMaxCapacity();
        int count = drawer.getStoredItemCount();
        if (cap == 0 || count == 0) {
            return x;
        }
        float fillAmt = (float)(step * count / cap) / (float)step;
        return x + w * (double)fillAmt;
    }

    private class LocalRenderItem
    extends RenderItem {
        public LocalRenderItem(TextureManager textureManager, ModelManager modelManager, ItemColors colors) {
            super(textureManager, modelManager, colors);
        }
    }
}

