/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.jaquadro.minecraft.storagedrawers.block.IExtendedBlockClickHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class BlockClickMessage
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int side;
    private float hitX;
    private float hitY;
    private float hitZ;
    private boolean invertShift;
    private boolean failed;

    public BlockClickMessage() {
    }

    public BlockClickMessage(int x, int y, int z, int side, float hitX, float hitY, float hitZ, boolean invertShift) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.side = side;
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
        this.invertShift = invertShift;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.x = buf.readInt();
            this.y = buf.readShort();
            this.z = buf.readInt();
            this.side = buf.readByte();
            this.hitX = buf.readFloat();
            this.hitY = buf.readFloat();
            this.hitZ = buf.readFloat();
            this.invertShift = buf.readBoolean();
        }
        catch (IndexOutOfBoundsException e) {
            this.failed = true;
            FMLLog.log((String)"StorageDrawers", (Level)Level.ERROR, (Throwable)e, (String)"BlockClickMessage: Unexpected end of packet.\nMessage: %s", (Object[])new Object[]{ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex())});
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeShort(this.y);
        buf.writeInt(this.z);
        buf.writeByte(this.side);
        buf.writeFloat(this.hitX);
        buf.writeFloat(this.hitY);
        buf.writeFloat(this.hitZ);
        buf.writeBoolean(this.invertShift);
    }

    public static class Handler
    implements IMessageHandler<BlockClickMessage, IMessage> {
        public IMessage onMessage(BlockClickMessage message, MessageContext ctx) {
            BlockPos pos;
            Block block;
            World world;
            if (!message.failed && ctx.side == Side.SERVER && (world = ctx.getServerHandler().field_147369_b.func_130014_f_()) != null && (block = world.func_180495_p(pos = new BlockPos(message.x, message.y, message.z)).func_177230_c()) instanceof IExtendedBlockClickHandler) {
                ((IExtendedBlockClickHandler)block).onBlockClicked(world, pos, (EntityPlayer)ctx.getServerHandler().field_147369_b, EnumFacing.func_82600_a((int)message.side), message.hitX, message.hitY, message.hitZ, message.invertShift);
            }
            return null;
        }
    }
}

