/*
 * Decompiled with CFR 0.152.
 */
package mcjty.combathelp.network;

import io.netty.buffer.ByteBuf;
import mcjty.combathelp.properties.PlayerHotbarStore;
import mcjty.combathelp.properties.PlayerInventoryStore;
import mcjty.combathelp.properties.PlayerProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketHotbarHandler
implements IMessage {
    private int slot;
    private boolean remember;

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readByte();
        this.remember = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.slot);
        buf.writeBoolean(this.remember);
    }

    public PacketHotbarHandler() {
    }

    public PacketHotbarHandler(int slot, boolean remember) {
        this.slot = slot;
        this.remember = remember;
    }

    public static class Handler
    implements IMessageHandler<PacketHotbarHandler, IMessage> {
        public IMessage onMessage(PacketHotbarHandler message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketHotbarHandler message, MessageContext ctx) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            PlayerInventoryStore inventoryStore = PlayerProperties.getPlayerInventoryStore((EntityPlayer)playerEntity);
            PlayerHotbarStore store = inventoryStore.getStore(message.slot);
            if (message.remember) {
                store.remember(playerEntity);
            } else {
                store.restore(playerEntity);
            }
        }
    }
}

