/*
 * Decompiled with CFR 0.152.
 */
package mcjty.combathelp.properties;

import mcjty.combathelp.varia.Tools;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class PlayerHotbarStore {
    private ItemStack[] hotbar = new ItemStack[9];
    private ItemStack offhand;

    public void saveNBTData(NBTTagCompound compound) {
        if (this.offhand != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.offhand.func_77955_b(tagCompound);
            compound.func_74782_a("off", (NBTBase)tagCompound);
        }
        for (int i = 0; i < this.hotbar.length; ++i) {
            if (this.hotbar[i] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.hotbar[i].func_77955_b(tagCompound);
            compound.func_74782_a("hot" + i, (NBTBase)tagCompound);
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.offhand = compound.func_74764_b("off") ? ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("off")) : null;
        for (int i = 0; i < this.hotbar.length; ++i) {
            this.hotbar[i] = compound.func_74764_b("hot" + i) ? ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("hot" + i)) : null;
        }
    }

    public void remember(EntityPlayerMP player) {
        this.offhand = player.field_71071_by.field_184439_c[0];
        System.arraycopy(player.field_71071_by.field_70462_a, 0, this.hotbar, 0, this.hotbar.length);
        player.func_146105_b((ITextComponent)new TextComponentString("Saved hotbar and offhand configuration"));
    }

    public void restore(EntityPlayerMP player) {
        int slotFor;
        if (this.offhand != null && (slotFor = Tools.getSlotFor(this.offhand, player, 0)) != -1) {
            ItemStack oldstack = player.field_71071_by.field_184439_c[0];
            player.field_71071_by.field_184439_c[0] = player.field_71071_by.func_70301_a(slotFor);
            player.field_71071_by.func_70299_a(slotFor, oldstack);
        }
        for (int i = 0; i < this.hotbar.length; ++i) {
            int slotFor2;
            if (this.hotbar[i] == null || (slotFor2 = Tools.getSlotFor(this.hotbar[i], player, i)) == -1 || slotFor2 == i) continue;
            ItemStack oldstack = player.field_71071_by.field_70462_a[i];
            player.field_71071_by.field_70462_a[i] = player.field_71071_by.func_70301_a(slotFor2);
            player.field_71071_by.func_70299_a(slotFor2, oldstack);
        }
        player.field_71070_bA.func_75142_b();
    }
}

