/*
 * Decompiled with CFR 0.152.
 */
package mcjty.combathelp.proxy;

import mcjty.combathelp.CombatHelp;
import mcjty.combathelp.Config;
import mcjty.combathelp.ForgeEventHandlers;
import mcjty.combathelp.network.PacketHandler;
import mcjty.combathelp.properties.PlayerInventoryStore;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy {
    private Configuration mainConfig;

    public void preInit(FMLPreInitializationEvent e) {
        CommonProxy.registerCapabilities();
        this.mainConfig = CombatHelp.config;
        this.readMainConfig();
        PacketHandler.registerMessages("combathelp");
    }

    private static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(PlayerInventoryStore.class, (Capability.IStorage)new Capability.IStorage<PlayerInventoryStore>(){

            public NBTBase writeNBT(Capability<PlayerInventoryStore> capability, PlayerInventoryStore instance, EnumFacing side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<PlayerInventoryStore> capability, PlayerInventoryStore instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment(Config.CATEGORY_COMBATHELP, "Combat Help configuration");
            Config.init(cfg);
        }
        catch (Exception e1) {
            CombatHelp.logger.log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
    }

    public void postInit(FMLPostInitializationEvent e) {
        if (this.mainConfig.hasChanged()) {
            this.mainConfig.save();
        }
        this.mainConfig = null;
    }
}

