/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import java.io.File;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.api.util.PluginHelper;
import journeymap.client.cartography.ChunkRenderController;
import journeymap.client.cartography.ColorManager;
import journeymap.client.data.DataCache;
import journeymap.client.data.WaypointsData;
import journeymap.client.feature.FeatureManager;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.FileHandler;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.io.ThemeFileHandler;
import journeymap.client.log.ChatLog;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.RegionImageCache;
import journeymap.client.network.WorldInfoHandler;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.properties.TopoProperties;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.properties.WebMapProperties;
import journeymap.client.render.map.TileDrawStepCache;
import journeymap.client.service.WebServer;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.main.MainTaskController;
import journeymap.client.task.main.MappingMonitorTask;
import journeymap.client.task.multi.ITaskManager;
import journeymap.client.task.multi.TaskController;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.CommonProxy;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.migrate.Migration;
import journeymap.common.version.VersionCheck;
import modinfo.ModInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class JourneymapClient
implements CommonProxy {
    public static final String EDITION = JourneymapClient.getEdition();
    public static final String MOD_NAME = "JourneyMap " + EDITION;
    private static JourneymapClient instance;
    private volatile CoreProperties coreProperties;
    private volatile FullMapProperties fullMapProperties;
    private volatile MiniMapProperties miniMapProperties1;
    private volatile MiniMapProperties miniMapProperties2;
    private volatile TopoProperties topoProperties;
    private volatile WebMapProperties webMapProperties;
    private volatile WaypointProperties waypointProperties;
    private volatile Boolean initialized = false;
    private volatile String currentWorldId = null;
    private volatile Minecraft mc;
    private Logger logger;
    private boolean threadLogging = false;
    private TaskController multithreadTaskController;
    private ChunkRenderController chunkRenderController;
    private volatile MainTaskController mainThreadTaskController;

    public JourneymapClient() {
        if (instance != null) {
            throw new IllegalArgumentException("Use instance() after initialization is complete");
        }
        instance = this;
    }

    public static JourneymapClient getInstance() {
        return instance;
    }

    private static String getEdition() {
        String ed = null;
        try {
            ed = Journeymap.JM_VERSION + " " + FeatureManager.getPolicySetName();
        }
        catch (Throwable t) {
            ed = Journeymap.JM_VERSION + " ?";
            t.printStackTrace(System.err);
        }
        return ed;
    }

    public static CoreProperties getCoreProperties() {
        return JourneymapClient.instance.coreProperties;
    }

    public static FullMapProperties getFullMapProperties() {
        return JourneymapClient.instance.fullMapProperties;
    }

    public static TopoProperties getTopoProperties() {
        return JourneymapClient.instance.topoProperties;
    }

    public static void disable() {
        JourneymapClient.instance.initialized = false;
        EventHandlerManager.unregisterAll();
        instance.stopMapping();
        ClientAPI.INSTANCE.purge();
        DataCache.instance().purge();
    }

    public static MiniMapProperties getMiniMapProperties(int which) {
        switch (which) {
            case 2: {
                JourneymapClient.instance.miniMapProperties2.setActive(true);
                JourneymapClient.instance.miniMapProperties1.setActive(false);
                return JourneymapClient.getMiniMapProperties2();
            }
        }
        JourneymapClient.instance.miniMapProperties1.setActive(true);
        JourneymapClient.instance.miniMapProperties2.setActive(false);
        return JourneymapClient.getMiniMapProperties1();
    }

    public static int getActiveMinimapId() {
        if (JourneymapClient.instance.miniMapProperties1.isActive()) {
            return 1;
        }
        return 2;
    }

    public static MiniMapProperties getMiniMapProperties1() {
        return JourneymapClient.instance.miniMapProperties1;
    }

    public static MiniMapProperties getMiniMapProperties2() {
        return JourneymapClient.instance.miniMapProperties2;
    }

    public static WebMapProperties getWebMapProperties() {
        return JourneymapClient.instance.webMapProperties;
    }

    public static WaypointProperties getWaypointProperties() {
        return JourneymapClient.instance.waypointProperties;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitialize(FMLPreInitializationEvent event) throws Throwable {
        try {
            PluginHelper.INSTANCE.preInitPlugins(event);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialize(FMLInitializationEvent event) throws Throwable {
        StatTimer timer = null;
        try {
            timer = StatTimer.getDisposable("elapsed").start();
            boolean migrationOk = new Migration("journeymap.client.task.migrate").performTasks();
            this.logger = JMLogger.init();
            this.logger.info("initialize ENTER");
            if (this.initialized.booleanValue()) {
                this.logger.warn("Already initialized, aborting");
                return;
            }
            EntityRegistry.instance();
            this.loadConfigProperties();
            JMLogger.logProperties();
            this.threadLogging = false;
            PluginHelper.INSTANCE.initPlugins(event, ClientAPI.INSTANCE);
            this.logger.info("initialize EXIT, " + (timer == null ? "" : timer.getLogReportString()));
        }
        catch (Throwable t) {
            if (this.logger == null) {
                this.logger = LogManager.getLogger((String)"journeymap");
            }
            this.logger.error(LogFormatter.toString(t));
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    public void postInitialize(FMLPostInitializationEvent event) {
        StatTimer timer = null;
        try {
            this.logger.info("postInitialize ENTER");
            timer = StatTimer.getDisposable("elapsed").start();
            this.mc = FMLClientHandler.instance().getClient();
            this.mainThreadTaskController = new MainTaskController(this.mc, this);
            this.mainThreadTaskController.addTask(new MappingMonitorTask());
            EventHandlerManager.registerGeneralHandlers();
            EventHandlerManager.registerGuiHandlers();
            WaypointsData.enableRecheck();
            IconSetFileHandler.initialize();
            ThemeFileHandler.initialize();
            WebServer.setEnabled(this.webMapProperties.enabled.get(), false);
            this.initialized = true;
            VersionCheck.getVersionAvailable();
            ModInfo modInfo = new ModInfo("UA-28839029-5", "en_US", "journeymap", MOD_NAME, JourneymapClient.getEdition(), false);
            modInfo.reportAppView();
            this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
        }
        catch (Throwable t) {
            try {
                if (this.logger == null) {
                    this.logger = LogManager.getLogger((String)"journeymap");
                }
                this.logger.error(LogFormatter.toString(t));
                this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
            }
            catch (Throwable throwable) {
                this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
                throw throwable;
            }
        }
        JMLogger.setLevelFromProperties();
    }

    @Override
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }

    @Override
    public boolean isUpdateCheckEnabled() {
        return JourneymapClient.getCoreProperties().checkUpdates.get();
    }

    public Boolean isInitialized() {
        return this.initialized;
    }

    public Boolean isMapping() {
        return this.initialized != false && this.multithreadTaskController != null && this.multithreadTaskController.isMapping() != false;
    }

    public Boolean isThreadLogging() {
        return this.threadLogging;
    }

    public WebServer getJmServer() {
        return WebServer.getInstance();
    }

    public void toggleTask(Class<? extends ITaskManager> managerClass, boolean enable, Object params) {
        if (this.multithreadTaskController != null) {
            this.multithreadTaskController.toggleTask(managerClass, enable, params);
        }
    }

    public boolean isTaskManagerEnabled(Class<? extends ITaskManager> managerClass) {
        if (this.multithreadTaskController != null) {
            return this.multithreadTaskController.isTaskManagerEnabled(managerClass);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMapping() {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            boolean created;
            if (this.mc == null || this.mc.field_71441_e == null || !this.initialized.booleanValue() || !this.coreProperties.mappingEnabled.get().booleanValue()) {
                return;
            }
            File worldDir = FileHandler.getJMWorldDir(this.mc, this.currentWorldId);
            if (!worldDir.exists() && !(created = worldDir.mkdirs())) {
                JMLogger.logOnce("CANNOT CREATE DATA DIRECTORY FOR WORLD: " + worldDir.getPath(), null);
                return;
            }
            this.reset();
            ColorManager.instance().ensureCurrent();
            this.multithreadTaskController = new TaskController();
            this.multithreadTaskController.enableTasks();
            long totalMB = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
            long freeMB = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
            String memory = String.format("Memory: %sMB total, %sMB free", totalMB, freeMB);
            int dimension = ForgeHelper.INSTANCE.getDimension();
            this.logger.info(String.format("Mapping started in %s%sDIM%s. %s ", FileHandler.getJMWorldDir(this.mc, this.currentWorldId), File.separator, dimension, memory));
            ClientAPI.INSTANCE.getClientEventManager().fireMappingEvent(true, dimension);
            UIManager.INSTANCE.getMiniMap().reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMapping() {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            if (this.isMapping().booleanValue() && this.mc != null) {
                this.logger.info(String.format("Mapping halted in %s%sDIM%s", FileHandler.getJMWorldDir(this.mc, this.currentWorldId), File.separator, ForgeHelper.INSTANCE.getDimension()));
                RegionImageCache.instance().flushToDiskAsync(true);
            }
            if (this.multithreadTaskController != null) {
                this.multithreadTaskController.disableTasks();
                this.multithreadTaskController.clear();
                this.multithreadTaskController = null;
            }
            int dimension = this.mc.field_71441_e != null ? ForgeHelper.INSTANCE.getDimension() : 0;
            ClientAPI.INSTANCE.getClientEventManager().fireMappingEvent(false, dimension);
        }
    }

    private void reset() {
        if (!this.mc.func_71356_B() && this.currentWorldId == null) {
            WorldInfoHandler.requestWorldID();
        }
        this.loadConfigProperties();
        DataCache.instance().purge();
        this.chunkRenderController = new ChunkRenderController();
        Fullscreen.state().requireRefresh();
        Fullscreen.state().follow.set(true);
        StatTimer.resetAll();
        TileDrawStepCache.clear();
        UIManager.INSTANCE.getMiniMap().reset();
        UIManager.INSTANCE.reset();
        WaypointStore.INSTANCE.reset();
    }

    public void queueMainThreadTask(IMainThreadTask task) {
        this.mainThreadTaskController.addTask(task);
    }

    public void performMainThreadTasks() {
        try {
            this.mainThreadTaskController.performTasks();
        }
        catch (Throwable t) {
            String error = "Error in JourneyMap.performMainThreadTasks(): " + t.getMessage();
            ChatLog.announceError(error);
            this.logger.error(LogFormatter.toString(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMultithreadTasks() {
        try {
            JourneymapClient journeymapClient = this;
            synchronized (journeymapClient) {
                if (this.isMapping().booleanValue()) {
                    this.multithreadTaskController.performTasks();
                }
            }
        }
        catch (Throwable t) {
            String error = "Error in JourneyMap.performMultithreadTasks(): " + t.getMessage();
            ChatLog.announceError(error);
            this.logger.error(LogFormatter.toString(t));
        }
    }

    public ChunkRenderController getChunkRenderController() {
        return this.chunkRenderController;
    }

    public void saveConfigProperties() {
        if (this.coreProperties != null) {
            this.coreProperties.save();
        }
        if (this.fullMapProperties != null) {
            this.fullMapProperties.save();
        }
        if (this.miniMapProperties1 != null) {
            this.miniMapProperties1.save();
        }
        if (this.miniMapProperties2 != null) {
            this.miniMapProperties2.save();
        }
        if (this.miniMapProperties2 != null) {
            this.miniMapProperties2.save();
        }
        if (this.topoProperties != null) {
            this.topoProperties.save();
        }
        if (this.webMapProperties != null) {
            this.webMapProperties.save();
        }
        if (this.waypointProperties != null) {
            this.waypointProperties.save();
        }
    }

    public void loadConfigProperties() {
        this.saveConfigProperties();
        this.coreProperties = (CoreProperties)new CoreProperties().load();
        this.fullMapProperties = (FullMapProperties)new FullMapProperties().load();
        this.miniMapProperties1 = (MiniMapProperties)new MiniMapProperties(1).load();
        this.miniMapProperties2 = (MiniMapProperties)new MiniMapProperties(2).load();
        this.topoProperties = (TopoProperties)new TopoProperties().load();
        this.webMapProperties = (WebMapProperties)new WebMapProperties().load();
        this.waypointProperties = (WaypointProperties)new WaypointProperties().load();
    }

    @Override
    public void handleWorldIdMessage(String worldId, EntityPlayerMP playerEntity) {
        this.setCurrentWorldId(worldId);
    }

    public String getCurrentWorldId() {
        return this.currentWorldId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentWorldId(String worldId) {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            boolean directoryUnchanged;
            File currentWorldDirectory = FileHandler.getJMWorldDirForWorldId(this.mc, this.currentWorldId);
            File newWorldDirectory = FileHandler.getJMWorldDir(this.mc, worldId);
            boolean worldIdUnchanged = Constants.safeEqual(worldId, this.currentWorldId);
            boolean bl = directoryUnchanged = currentWorldDirectory != null && newWorldDirectory != null && currentWorldDirectory.getPath().equals(newWorldDirectory.getPath());
            if (worldIdUnchanged && directoryUnchanged && worldId != null) {
                Journeymap.getLogger().info("World UID hasn't changed: " + worldId);
                return;
            }
            boolean wasMapping = this.isMapping();
            if (wasMapping) {
                this.stopMapping();
            }
            this.currentWorldId = worldId;
            Journeymap.getLogger().info("World UID is set to: " + worldId);
        }
    }
}

