/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.display;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.display.DisplayType;

@ParametersAreNonnullByDefault
public abstract class Displayable
implements Comparable<Displayable> {
    protected final String modId;
    protected final String displayId;
    protected final DisplayType displayType;

    Displayable(String modId) {
        this(modId, UUID.randomUUID().toString());
    }

    Displayable(String modId, String displayId) {
        this.modId = modId;
        this.displayId = displayId;
        this.displayType = DisplayType.of(this.getClass());
    }

    public static int clampRGB(int rgb) {
        return Math.max(0, Math.min(rgb, 0xFFFFFF));
    }

    public static float clampOpacity(float opacity) {
        return Math.max(0.0f, Math.min(opacity, 1.0f));
    }

    public abstract int getDisplayOrder();

    public final String getModId() {
        return this.modId;
    }

    public final String getDisplayId() {
        return this.displayId;
    }

    public final DisplayType getDisplayType() {
        return this.displayType;
    }

    public final String getGuid() {
        return Joiner.on((String)":").join((Object)this.modId, (Object)this.displayType, new Object[]{this.displayId});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Displayable)) {
            return false;
        }
        Displayable that = (Displayable)o;
        return Objects.equal((Object)this.modId, (Object)that.modId) && Objects.equal((Object)((Object)this.displayType), (Object)((Object)that.displayType)) && Objects.equal((Object)this.displayId, (Object)that.displayId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.modId, this.displayType, this.displayId});
    }

    @Override
    public int compareTo(Displayable o) {
        return Integer.compare(this.getDisplayOrder(), o.getDisplayOrder());
    }
}

