/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import com.google.common.cache.RemovalNotification;
import java.awt.image.BufferedImage;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.RGB;
import journeymap.client.cartography.Strata;
import journeymap.client.cartography.Stratum;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.data.DataCache;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import org.apache.logging.log4j.Level;

public class SurfaceRenderer
extends BaseRenderer
implements IChunkRenderer {
    protected final Object chunkLock = new Object();
    protected final BaseRenderer.HeightsCache chunkSurfaceHeights;
    protected final BaseRenderer.SlopesCache chunkSurfaceSlopes;
    protected StatTimer renderSurfaceTimer = StatTimer.get("SurfaceRenderer.renderSurface");
    protected StatTimer renderSurfacePrepassTimer = StatTimer.get("SurfaceRenderer.renderSurface.CavePrepass");
    protected Strata strata = new Strata("Surface", 40, 8, false);
    protected float maxDepth = 8.0f;

    public SurfaceRenderer() {
        this("Surface");
    }

    protected SurfaceRenderer(String cachePrefix) {
        this.cachePrefix = cachePrefix;
        this.columnPropertiesCache = new BaseRenderer.BlockColumnPropertiesCache(cachePrefix + "ColumnProps");
        this.chunkSurfaceHeights = new BaseRenderer.HeightsCache(cachePrefix + "Heights");
        this.chunkSurfaceSlopes = new BaseRenderer.SlopesCache(cachePrefix + "Slopes");
        DataCache.instance().addChunkMDListener(this);
    }

    @Override
    protected void updateOptions() {
        super.updateOptions();
        this.ambientColor = RGB.floats(this.tweakSurfaceAmbientColor);
    }

    @Override
    public int getBlockHeight(ChunkMD chunkMd, BlockPos blockPos) {
        Integer y = this.getSurfaceBlockHeight(chunkMd, blockPos.func_177958_n() & 0xF, blockPos.func_177952_p() & 0xF, this.chunkSurfaceHeights);
        return y == null ? blockPos.func_177956_o() : y.intValue();
    }

    @Override
    public boolean render(BufferedImage dayChunkImage, ChunkMD chunkMd, Integer ignored) {
        return this.render(dayChunkImage, null, chunkMd, null, false);
    }

    public boolean render(BufferedImage dayChunkImage, BufferedImage nightChunkImage, ChunkMD chunkMd) {
        return this.render(dayChunkImage, nightChunkImage, chunkMd, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean render(BufferedImage dayChunkImage, BufferedImage nightChunkImage, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        StatTimer timer = cavePrePass ? this.renderSurfacePrepassTimer : this.renderSurfaceTimer;
        try {
            timer.start();
            this.updateOptions();
            if (this.chunkSurfaceSlopes.getIfPresent(chunkMd.getCoord()) == null) {
                this.populateSlopes(chunkMd, null, this.chunkSurfaceHeights, this.chunkSurfaceSlopes);
            }
            boolean bl = this.renderSurface(dayChunkImage, nightChunkImage, chunkMd, vSlice, cavePrePass);
            return bl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.strata.reset();
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean renderSurface(BufferedImage dayChunkImage, BufferedImage nightChunkImage, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        boolean chunkOk = false;
        try {
            int sliceMaxY = 0;
            if (cavePrePass) {
                int[] sliceBounds = this.getVSliceBounds(chunkMd, vSlice);
                sliceMaxY = sliceBounds[1];
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.strata.reset();
                    BlockMD topBlockMd = null;
                    int standardY = Math.max(0, this.getSurfaceBlockHeight(chunkMd, x, z, this.chunkSurfaceHeights));
                    if (standardY == 0) {
                        this.paintVoidBlock(dayChunkImage, x, z);
                        if (cavePrePass || nightChunkImage == null) continue;
                        this.paintVoidBlock(nightChunkImage, x, z);
                        continue;
                    }
                    if (cavePrePass && standardY > sliceMaxY && (float)(standardY - sliceMaxY) > this.maxDepth) {
                        chunkOk = true;
                        this.paintBlackBlock(dayChunkImage, x, z);
                        continue;
                    }
                    int roofY = 0;
                    int y = standardY;
                    roofY = Math.max(0, chunkMd.getPrecipitationHeight(x, z));
                    if (standardY < roofY) {
                        for (int checkY = roofY; checkY > standardY; --checkY) {
                            topBlockMd = BlockMD.getBlockMD(chunkMd, x, checkY, z);
                            if (!topBlockMd.isTransparentRoof()) continue;
                            y = Math.max(standardY, checkY);
                            break;
                        }
                    }
                    if (roofY == 0 || standardY == 0) {
                        this.paintVoidBlock(dayChunkImage, x, z);
                        if (!cavePrePass && nightChunkImage != null) {
                            this.paintVoidBlock(nightChunkImage, x, z);
                        }
                        chunkOk = true;
                        continue;
                    }
                    if (this.mapBathymetry) {
                        standardY = this.getColumnProperty("waterHeight", standardY, chunkMd, x, z);
                    }
                    if ((topBlockMd = chunkMd.getTopBlockMD(x, standardY, z)) == null) {
                        this.paintBadBlock(dayChunkImage, x, standardY, z);
                        this.paintBadBlock(nightChunkImage, x, standardY, z);
                        continue;
                    }
                    if (this.mapPlants || this.mapCrops) {
                        BlockMD temp = chunkMd.getTopBlockMD(x, standardY + 1, z);
                        if (this.mapPlants && temp.hasFlag(BlockMD.Flag.Plant) || this.mapCrops && temp.hasFlag(BlockMD.Flag.Crop)) {
                            ++standardY;
                        }
                    }
                    this.buildStrata(this.strata, roofY, chunkMd, x, standardY, z);
                    chunkOk = this.paintStrata(this.strata, dayChunkImage, nightChunkImage, chunkMd, topBlockMd, vSlice, x, y, z, cavePrePass) || chunkOk;
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().log(Level.WARN, LogFormatter.toString(t));
        }
        finally {
            this.strata.reset();
        }
        return chunkOk;
    }

    protected void buildStrata(Strata strata, int roofY, ChunkMD chunkMd, int x, int y, int z) {
        BlockMD blockMD;
        if (roofY > y) {
            while (roofY > y) {
                blockMD = BlockMD.getBlockMD(chunkMd, x, roofY, z);
                if (!blockMD.isAir() && blockMD.isTransparentRoof()) {
                    strata.push(chunkMd, blockMD, x, roofY, z);
                    if (!this.mapTransparency) break;
                }
                --roofY;
            }
        }
        if (this.mapTransparency || strata.isEmpty()) {
            while (y >= 0) {
                blockMD = BlockMD.getBlockMD(chunkMd, x, y, z);
                if (!blockMD.isAir()) {
                    strata.push(chunkMd, blockMD, x, y, z);
                    if (blockMD.getAlpha() == 1.0f || !this.mapTransparency) break;
                }
                --y;
            }
        }
    }

    protected boolean paintStrata(Strata strata, BufferedImage dayChunkImage, BufferedImage nightChunkImage, ChunkMD chunkMd, BlockMD topBlockMd, Integer vSlice, int x, int y, int z, boolean cavePrePass) {
        float slope;
        if (strata.isEmpty()) {
            if (dayChunkImage != null) {
                this.paintBadBlock(dayChunkImage, x, y, z);
            }
            if (nightChunkImage != null) {
                this.paintBadBlock(nightChunkImage, x, y, z);
            }
            return false;
        }
        while (!strata.isEmpty()) {
            Stratum stratum = strata.nextUp(this, true);
            if (strata.getRenderDayColor() == null || strata.getRenderNightColor() == null) {
                strata.setRenderDayColor(stratum.getDayColor());
                if (!cavePrePass) {
                    strata.setRenderNightColor(stratum.getNightColor());
                }
            } else {
                strata.setRenderDayColor(RGB.blendWith(strata.getRenderDayColor(), stratum.getDayColor(), stratum.getBlockMD().getAlpha()));
                if (!cavePrePass) {
                    strata.setRenderNightColor(RGB.blendWith(strata.getRenderNightColor(), stratum.getNightColor(), stratum.getBlockMD().getAlpha()));
                }
            }
            strata.release(stratum);
        }
        if (strata.getRenderDayColor() == null) {
            this.paintBadBlock(dayChunkImage, x, y, z);
            this.paintBadBlock(nightChunkImage, x, y, z);
            return false;
        }
        if (nightChunkImage != null && strata.getRenderNightColor() == null) {
            this.paintBadBlock(nightChunkImage, x, y, z);
            return false;
        }
        if ((topBlockMd.isWater() && this.mapBathymetry || !topBlockMd.hasNoShadow()) && (slope = this.getSlope(chunkMd, topBlockMd, x, null, z, this.chunkSurfaceHeights, this.chunkSurfaceSlopes)) != 1.0f) {
            strata.setRenderDayColor(RGB.bevelSlope(strata.getRenderDayColor(), slope));
            if (!cavePrePass) {
                strata.setRenderNightColor(RGB.bevelSlope(strata.getRenderNightColor(), slope));
            }
        }
        if (chunkMd.getHasNoSky().booleanValue()) {
            this.paintBlock(dayChunkImage, x, z, strata.getRenderNightColor());
        } else {
            this.paintBlock(dayChunkImage, x, z, strata.getRenderDayColor());
            if (nightChunkImage != null) {
                this.paintBlock(nightChunkImage, x, z, strata.getRenderNightColor());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoval(RemovalNotification<ChunkPos, ChunkMD> notification) {
        Object object = this.chunkLock;
        synchronized (object) {
            ChunkPos coord = (ChunkPos)notification.getKey();
            this.chunkSurfaceHeights.invalidate(coord);
            this.chunkSurfaceSlopes.invalidate(coord);
        }
    }
}

