/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.helper.impl;

import com.google.common.base.Strings;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.RealmsServer;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.forge.helper.IColorHelper;
import journeymap.client.forge.helper.IForgeHelper;
import journeymap.client.forge.helper.impl.ColorHelper_1_8;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.network.NetworkManager;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ForgeHelper_1_9
implements IForgeHelper {
    private IBlockAccess blockAccess = new JmBlockAccess();
    private IColorHelper colorHelper = new ColorHelper_1_8();

    @Override
    public IColorHelper getColorHelper() {
        return this.colorHelper;
    }

    @Override
    public IBlockAccess getIBlockAccess() {
        return this.blockAccess;
    }

    @Override
    public ScaledResolution getScaledResolution() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        return new ScaledResolution(mc);
    }

    @Override
    public EnumSkyBlock getSkyBlock() {
        return EnumSkyBlock.BLOCK;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return FMLClientHandler.instance().getClient().field_71466_p;
    }

    @Override
    public int getPlayerDimension() {
        return FMLClientHandler.instance().getClient().field_71439_g.field_70170_p.field_73011_w.getDimension();
    }

    @Override
    public boolean hasNoSky(World world) {
        return world.field_73011_w.func_177495_o();
    }

    @Override
    public World getWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public int getLightOpacity(BlockMD blockMD, BlockPos blockPos) {
        return blockMD.getBlockState().func_177230_c().getLightOpacity(blockMD.getBlockState(), this.blockAccess, blockPos);
    }

    @Override
    public int getDimension() {
        return this.getWorld().field_73011_w.getDimension();
    }

    @Override
    public int getSavedLightValue(Chunk chunk, BlockPos blockPos) {
        try {
            return chunk.func_177413_a(this.getSkyBlock(), blockPos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1;
        }
    }

    @Override
    public RenderManager getRenderManager() {
        return FMLClientHandler.instance().getClient().func_175598_ae();
    }

    @Override
    public String getEntityName(Entity entity) {
        return entity.func_70005_c_();
    }

    @Override
    public boolean hasCustomName(Entity entity) {
        return entity.func_145818_k_();
    }

    @Override
    public AxisAlignedBB getBoundingBox(int x1, int y1, int z1, int x2, int y2, int z2) {
        return new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    @Override
    public AxisAlignedBB getBoundingBox(EntityPlayer player, double lateralDistance, double verticalDistance) {
        return new AxisAlignedBB(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t, player.field_70163_u, player.field_70161_v).func_72314_b(lateralDistance, verticalDistance, lateralDistance);
    }

    @Override
    public Vec3d newVec3(double x, double y, double z) {
        return new Vec3d(x, y, z);
    }

    @Override
    public AxisAlignedBB getEntityBoundingBox(EntityLivingBase entity) {
        return entity.func_174813_aQ();
    }

    @Override
    public String getRealmsServerName() {
        Minecraft mc;
        String serverName;
        block7: {
            serverName = null;
            mc = FMLClientHandler.instance().getClient();
            if (!mc.func_71356_B()) {
                try {
                    RealmsScreen realmsScreen;
                    NetHandlerPlayClient netHandler = mc.func_147114_u();
                    GuiScreen netHandlerGui = (GuiScreen)ReflectionHelper.getPrivateValue(NetHandlerPlayClient.class, (Object)netHandler, (String[])new String[]{"field_147307_j", "guiScreenServer"});
                    if (!(netHandlerGui instanceof GuiScreenRealmsProxy) || !((realmsScreen = ((GuiScreenRealmsProxy)netHandlerGui).func_154321_a()) instanceof RealmsMainScreen)) break block7;
                    RealmsMainScreen mainScreen = (RealmsMainScreen)realmsScreen;
                    long selectedServerId = (Long)ReflectionHelper.getPrivateValue(RealmsMainScreen.class, (Object)mainScreen, (String[])new String[]{"selectedServerId"});
                    List mcoServers = (List)ReflectionHelper.getPrivateValue(RealmsMainScreen.class, (Object)mainScreen, (String[])new String[]{"mcoServers"});
                    for (RealmsServer mcoServer : mcoServers) {
                        if (mcoServer.id != selectedServerId) continue;
                        serverName = mcoServer.name;
                        break;
                    }
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Unable to get Realms server name: " + LogFormatter.toString(t));
                }
            }
        }
        if (serverName != null) {
            return serverName;
        }
        mc = FMLClientHandler.instance().getClient();
        ServerData serverData = mc.func_147104_D();
        if (serverData != null && (serverName = serverData.field_78847_a) != null) {
            if (Strings.isNullOrEmpty((String)(serverName = serverName.replaceAll("\\W+", "~").trim()).replaceAll("~", ""))) {
                serverName = serverData.field_78845_b;
            }
            return serverName;
        }
        return null;
    }

    @Override
    public Vec3d getEntityPositionVector(Entity entity) {
        return entity.func_174791_d();
    }

    @Override
    public Tessellator getTessellator() {
        return Tessellator.func_178181_a();
    }

    @Override
    public boolean canBlockSeeTheSky(Chunk chunk, BlockPos blockPos) {
        return chunk.func_177444_d(blockPos);
    }

    public int toWorldX(Chunk chunk, int localX) {
        return (chunk.field_76635_g << 4) + localX;
    }

    public int toWorldZ(Chunk chunk, int localZ) {
        return (chunk.field_76647_h << 4) + localZ;
    }

    @Override
    public int getHeight(Chunk chunk, BlockPos blockPos) {
        return chunk.func_177433_f(blockPos);
    }

    @Override
    public int getPrecipitationHeight(BlockPos blockPos) {
        return this.getWorld().func_175725_q(blockPos).func_177956_o();
    }

    @Override
    public TileEntity getTileEntity(BlockPos blockPos) {
        return this.blockAccess.func_175625_s(blockPos);
    }

    @Override
    public Biome getBiome(BlockPos blockPos) {
        return this.getWorld().getBiomeForCoordsBody(blockPos);
    }

    @Override
    public boolean hasNoSky(Entity entity) {
        return this.hasNoSky(entity.func_130014_f_());
    }

    @Override
    public boolean hasChunkData(Chunk chunk) {
        return chunk != null && chunk.func_177410_o() && !(chunk instanceof EmptyChunk);
    }

    @Override
    public Iterator<Block> getRegisteredBlocks() {
        return GameData.getBlockRegistry().iterator();
    }

    @Override
    public SocketAddress getSocketAddress(NetworkManager netManager) {
        return netManager.func_74430_c();
    }

    @Override
    public String getFPS() {
        return String.format("%s fps", Minecraft.func_175610_ah());
    }

    private ChunkMD getChunkMDFromBlockCoords(BlockPos pos) {
        return DataCache.instance().getChunkMD(new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4));
    }

    class JmBlockAccess
    implements IBlockAccess {
        JmBlockAccess() {
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return ForgeHelper.INSTANCE.getWorld().func_175625_s(pos);
        }

        public int func_175626_b(BlockPos pos, int min) {
            return ForgeHelper.INSTANCE.getWorld().func_175626_b(pos, min);
        }

        public IBlockState func_180495_p(BlockPos pos) {
            if (!this.isValid(pos)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            ChunkMD chunkMD = ForgeHelper_1_9.this.getChunkMDFromBlockCoords(pos);
            if (chunkMD != null && chunkMD.hasChunk()) {
                return chunkMD.getChunk().func_177435_g(new BlockPos(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF));
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return ForgeHelper.INSTANCE.getWorld().func_175623_d(pos);
        }

        public Biome func_180494_b(BlockPos pos) {
            ChunkMD chunkMD = ForgeHelper_1_9.this.getChunkMDFromBlockCoords(pos);
            if (chunkMD != null && chunkMD.hasChunk()) {
                try {
                    Chunk chunk = chunkMD.getChunk();
                    Biome biome = chunk.func_177411_a(pos, ForgeHelper.INSTANCE.getWorld().func_72959_q());
                    if (biome == null) {
                        return null;
                    }
                    return biome;
                }
                catch (Throwable throwable) {
                    Journeymap.getLogger().error("Error in getBiome(): " + throwable);
                    return ForgeHelper.INSTANCE.getWorld().func_180494_b(pos);
                }
            }
            return ForgeHelper.INSTANCE.getWorld().func_72959_q().func_180300_a(pos, Biomes.field_76772_c);
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return ForgeHelper.INSTANCE.getWorld().func_175627_a(pos, direction);
        }

        public WorldType func_175624_G() {
            return ForgeHelper.INSTANCE.getWorld().func_175624_G();
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return ForgeHelper.INSTANCE.getWorld().isSideSolid(pos, side, _default);
        }

        private boolean isValid(BlockPos pos) {
            return pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000 && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256;
        }
    }
}

