/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.Objects;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.model.MapType;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.task.main.ExpireTextureTask;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.world.storage.IThreadedFileIO;
import net.minecraft.world.storage.ThreadedFileIOBase;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ImageHolder
implements IThreadedFileIO {
    public static final AlphaComposite ALPHA_OPAQUE = AlphaComposite.getInstance(3, 1.0f);
    static final Logger logger = Journeymap.getLogger();
    final MapType mapType;
    final Path imagePath;
    final int imageSize;
    boolean blank = true;
    boolean dirty = true;
    boolean partialUpdate;
    private volatile ReentrantLock writeLock = new ReentrantLock();
    private volatile TextureImpl texture;
    private boolean debug;

    ImageHolder(MapType mapType, File imageFile, int imageSize) {
        this.mapType = mapType;
        this.imagePath = imageFile.toPath();
        this.imageSize = imageSize;
        this.debug = logger.isEnabled(Level.DEBUG);
        this.getTexture();
    }

    public static Graphics2D initRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return g;
    }

    File getFile() {
        return this.imagePath.toFile();
    }

    MapType getMapType() {
        return this.mapType;
    }

    BufferedImage getImage() {
        return this.texture.getImage();
    }

    void setImage(BufferedImage image) {
        this.texture.setImage(image, true);
        this.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void partialImageUpdate(BufferedImage imagePart, int x, int y) {
        this.writeLock.lock();
        try {
            if (this.texture != null) {
                BufferedImage textureImage = this.texture.getImage();
                Graphics2D g2D = ImageHolder.initRenderingHints(textureImage.createGraphics());
                g2D.setComposite(ALPHA_OPAQUE);
                g2D.drawImage((Image)imagePart, x, y, null);
                g2D.dispose();
                this.partialUpdate = true;
                this.blank = false;
            } else {
                logger.warn(this + " can't partialImageUpdate without a texture.");
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishPartialImageUpdates() {
        this.writeLock.lock();
        try {
            if (this.partialUpdate) {
                BufferedImage textureImage = this.texture.getImage();
                this.texture.setImage(textureImage, true);
                this.setDirty();
                this.partialUpdate = false;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasTexture() {
        return this.texture != null && !this.texture.isDefunct();
    }

    public TextureImpl getTexture() {
        if (!this.hasTexture()) {
            BufferedImage image;
            File temp;
            if (!this.imagePath.toFile().exists() && (temp = new File(this.imagePath.toString() + ".new")).exists()) {
                Journeymap.getLogger().warn("Recovered image file: " + temp);
                temp.renameTo(this.imagePath.toFile());
            }
            if ((image = RegionImageHandler.readRegionImage(this.imagePath.toFile(), false)) == null || image.getWidth() != this.imageSize || image.getHeight() != this.imageSize) {
                image = new BufferedImage(this.imageSize, this.imageSize, 2);
                this.blank = true;
                this.dirty = false;
            } else {
                this.blank = false;
            }
            this.texture = new TextureImpl(null, image, true, false);
            this.texture.setDescription(this.imagePath.toString());
        }
        return this.texture;
    }

    private void setDirty() {
        this.dirty = true;
    }

    boolean isDirty() {
        return this.dirty;
    }

    protected boolean writeToDisk(boolean async) {
        if (this.blank || this.texture == null || !this.texture.hasImage()) {
            return false;
        }
        if (async) {
            ThreadedFileIOBase.func_178779_a().func_75735_a((IThreadedFileIO)this);
            return true;
        }
        boolean success = false;
        for (int tries = 0; tries < 5; ++tries) {
            if (this.func_75814_c()) {
                continue;
            }
            success = true;
            break;
        }
        if (!success) {
            Journeymap.getLogger().warn("Couldn't write file after 5 tries: " + this);
        }
        return success;
    }

    public boolean func_75814_c() {
        if (this.texture == null || !this.texture.hasImage()) {
            return false;
        }
        try {
            if (this.writeLock.tryLock(250L, TimeUnit.MILLISECONDS)) {
                this.writeImageToFile();
                this.writeLock.unlock();
                return false;
            }
            logger.warn("Couldn't get write lock for file: " + this.writeLock + " for " + this);
            return false;
        }
        catch (InterruptedException e) {
            logger.warn("Timeout waiting for write lock  " + this.writeLock + " for " + this);
            return false;
        }
    }

    private void writeImageToFile() {
        File imageFile = this.imagePath.toFile();
        try {
            BufferedImage image = this.texture.getImage();
            if (image != null) {
                if (!imageFile.exists()) {
                    imageFile.getParentFile().mkdirs();
                }
                File temp = new File(imageFile.getParentFile(), imageFile.getName() + ".new");
                ImageIO.write((RenderedImage)image, "PNG", temp);
                if (imageFile.exists() && !imageFile.delete()) {
                    logger.warn("Couldn't delete old file " + imageFile.getName());
                }
                if (temp.renameTo(imageFile)) {
                    this.dirty = false;
                } else {
                    logger.warn("Couldn't rename temp file to " + imageFile.getName());
                }
                if (this.debug) {
                    logger.debug("Wrote to disk: " + imageFile);
                }
            }
        }
        catch (IOException e) {
            if (imageFile.exists()) {
                try {
                    logger.error("IOException updating file, will delete and retry: " + this + ": " + LogFormatter.toPartialString(e));
                    imageFile.delete();
                    this.writeImageToFile();
                }
                catch (Throwable e2) {
                    logger.error("Exception after delete/retry: " + this + ": " + LogFormatter.toPartialString(e));
                }
            } else {
                logger.error("IOException creating file: " + this + ": " + LogFormatter.toPartialString(e));
            }
        }
        catch (Throwable e) {
            logger.error("Exception writing to disk: " + this + ": " + LogFormatter.toPartialString(e));
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("mapType", (Object)this.mapType).add("textureId", this.texture == null ? null : Integer.valueOf(this.texture.isBound() ? this.texture.getGlTextureId(false) : -1)).add("dirty", this.dirty).add("imagePath", (Object)this.imagePath).toString();
    }

    public void clear() {
        this.writeLock.lock();
        ExpireTextureTask.queue(this.texture);
        this.texture = null;
        this.writeLock.unlock();
    }

    public void finalize() {
        if (this.texture != null) {
            this.clear();
        }
    }

    public long getImageTimestamp() {
        if (this.texture != null) {
            return this.texture.getLastImageUpdate();
        }
        return 0L;
    }
}

