/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Random;
import journeymap.client.Constants;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.component.Button;
import net.minecraft.client.gui.FontRenderer;

public class SplashPerson {
    public final String name;
    public final String ign;
    public final String title;
    public Button button;
    public int width;
    public int moveX;
    public int moveY;
    private int moveDistance = 1;

    public SplashPerson(String ign, String name, String titleKey) {
        this.ign = ign;
        this.name = name;
        this.title = titleKey != null ? Constants.getString(titleKey) : "";
    }

    public Button getButton() {
        return this.button;
    }

    public void setButton(Button button) {
        this.button = button;
        this.randomizeVector();
    }

    public TextureImpl getSkin() {
        return TextureCache.instance().getPlayerSkin(this.ign);
    }

    public int getWidth(FontRenderer fr) {
        String[] nameParts;
        this.width = fr.func_78256_a(this.title);
        for (String part : nameParts = this.name.trim().split(" ")) {
            this.width = Math.max(this.width, fr.func_78256_a(part));
        }
        return this.width;
    }

    public void setWidth(int minWidth) {
        this.width = minWidth;
    }

    public void randomizeVector() {
        this.moveDistance = new Random().nextInt(2) + 1;
        this.moveX = new Random().nextBoolean() ? this.moveDistance : -this.moveDistance;
        this.moveY = new Random().nextBoolean() ? this.moveDistance : -this.moveDistance;
    }

    private void reverseX() {
        this.moveDistance = new Random().nextInt(2) + 1;
        this.moveX = this.moveX < 0 ? this.moveDistance : -this.moveDistance;
    }

    private void reverseY() {
        this.moveDistance = new Random().nextInt(2) + 1;
        this.moveY = this.moveY < 0 ? this.moveDistance : -this.moveDistance;
    }

    public void adjustVector(int screenWidth, int screenHeight) {
        if (this.button.field_146128_h <= this.moveDistance || this.button.field_146128_h + this.button.getWidth() >= screenWidth - this.moveDistance) {
            this.reverseX();
        }
        if (this.button.field_146129_i <= this.moveDistance || this.button.field_146129_i + this.button.getHeight() >= screenHeight - this.moveDistance) {
            this.reverseY();
        }
        this.button.field_146128_h += this.moveX;
        this.button.field_146129_i += this.moveY;
    }

    public void avoid(List<SplashPerson> devs) {
        for (SplashPerson dev : devs) {
            Rectangle2D.Double thatBounds;
            Rectangle2D.Double thisBounds;
            if (this == dev || !(thisBounds = new Rectangle2D.Double(this.button.getX(), this.button.getY(), this.button.field_146120_f, this.button.field_146121_g)).intersects(thatBounds = new Rectangle2D.Double(dev.button.getX(), dev.button.getY(), dev.button.field_146120_f, dev.button.field_146121_g))) continue;
            this.moveDistance *= 2;
            if (new Random().nextBoolean()) {
                this.reverseX();
                break;
            }
            this.reverseY();
            break;
        }
    }

    public static class Fake
    extends SplashPerson {
        private TextureImpl texture;

        public Fake(String name, String title, TextureImpl texture) {
            super(name, title, null);
            this.texture = texture;
        }

        @Override
        public TextureImpl getSkin() {
            return this.texture;
        }
    }
}

