/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.service;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.ColorManager;
import journeymap.client.cartography.ColorPalette;
import journeymap.client.io.FileHandler;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.io.ThemeFileHandler;
import journeymap.client.log.JMLogger;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.service.BaseService;
import journeymap.client.ui.theme.ThemePresets;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import se.rupy.http.Event;

public class FileService
extends BaseService {
    private static final long serialVersionUID = 2L;
    protected final String resourcePath;
    final String COLOR_PALETTE_JSON = "/colorpalette.json";
    final String COLOR_PALETTE_HTML = "/colorpalette.html";
    final String ICON_ENTITY_PATH_PREFIX = "/icon/entity/";
    final String ICON_THEME_PATH_PREFIX = "/theme/";
    final String SKIN_PREFIX = "/skin/";
    private boolean useZipEntry;
    private File zipFile;

    public FileService() {
        URL resourceDir = JourneymapClient.class.getResource("/assets/journeymap/web");
        String testPath = null;
        if (resourceDir == null) {
            Journeymap.getLogger().error("Can't determine path to webroot!");
        } else {
            testPath = resourceDir.getPath();
            if (testPath.endsWith("/")) {
                testPath = testPath.substring(0, testPath.length() - 1);
            }
            boolean bl = this.useZipEntry = (resourceDir.getProtocol().equals("file") || resourceDir.getProtocol().equals("jar")) && testPath.contains("!/");
        }
        if (!this.useZipEntry && "12.18.0.2002".contains("@")) {
            try {
                testPath = new File("../src/main/resources/assets/journeymap/web").getCanonicalPath();
                Journeymap.getLogger().info("Dev environment detected, serving source files from " + testPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.resourcePath = testPath;
    }

    @Override
    public String path() {
        return null;
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        String path = null;
        Object in = null;
        try {
            path = event.query().path();
            if (path.startsWith("/skin/")) {
                this.serveSkin(path.split("/skin/")[1], event);
                return;
            }
            InputStream fileStream = null;
            if (path.startsWith("/colorpalette.json")) {
                File jsonFile;
                ColorPalette colorPalette = ColorManager.instance().getCurrentPalette();
                if (colorPalette != null && (jsonFile = colorPalette.getOrigin()).canRead()) {
                    BaseService.ResponseHeader.on(event).contentType(BaseService.ContentType.js);
                    fileStream = new FileInputStream(jsonFile);
                }
            } else if (path.startsWith("/colorpalette.html")) {
                File htmlFile;
                ColorPalette colorPalette = ColorManager.instance().getCurrentPalette();
                if (colorPalette != null && (htmlFile = colorPalette.getOriginHtml(true, false)).canRead()) {
                    BaseService.ResponseHeader.on(event).contentType(BaseService.ContentType.html);
                    fileStream = new FileInputStream(htmlFile);
                }
            } else if (path.startsWith("/icon/entity/")) {
                String entityIconPath = path.split("/icon/entity/")[1].replace('/', File.separatorChar);
                File iconFile = new File(IconSetFileHandler.getEntityIconDir(), entityIconPath);
                if (!iconFile.exists()) {
                    String setName = entityIconPath.split(File.separator)[0];
                    String iconPath = entityIconPath.substring(entityIconPath.indexOf(File.separatorChar) + 1);
                    if (event != null) {
                        BaseService.ResponseHeader.on(event).contentType(BaseService.ContentType.png);
                    }
                    fileStream = FileHandler.getIconStream("/assets/journeymap/icon/entity", setName, iconPath);
                    JMLogger.logOnce("Couldn't get file for " + path, null);
                } else {
                    if (event != null) {
                        BaseService.ResponseHeader.on(event).content(iconFile);
                    }
                    fileStream = new FileInputStream(iconFile);
                }
            } else if (path.startsWith("/theme/")) {
                String themeIconPath = path.split("/theme/")[1].replace('/', File.separatorChar);
                File themeDir = new File(ThemeFileHandler.getThemeIconDir(), ThemePresets.THEME_VICTORIAN.directory);
                File iconFile = new File(themeDir, themeIconPath);
                if (!iconFile.exists()) {
                    String setName = themeIconPath.split(File.separator)[0];
                    String iconPath = themeIconPath.substring(themeIconPath.indexOf(File.separatorChar) + 1);
                    if (event != null) {
                        BaseService.ResponseHeader.on(event).contentType(BaseService.ContentType.png);
                    }
                    fileStream = FileHandler.getIconStream("/assets/journeymap/icon/theme", setName, iconPath);
                    Journeymap.getLogger().warn("Couldn't get theme file for " + path);
                } else {
                    if (event != null) {
                        BaseService.ResponseHeader.on(event).content(iconFile);
                    }
                    fileStream = new FileInputStream(iconFile);
                }
            } else {
                fileStream = this.getStream(path, event);
            }
            if (fileStream == null) {
                JMLogger.logOnce("Path not found: " + path, null);
                this.throwEventException(404, "Unknown: " + path, event, true);
            } else {
                this.serveStream(fileStream, event);
            }
        }
        catch (Event eventEx) {
            throw eventEx;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            this.throwEventException(500, "Error: " + path, event, true);
        }
    }

    protected InputStream getStream(String path, Event event) {
        InputStream in = null;
        try {
            String requestPath = null;
            requestPath = "/".equals(path) ? this.resourcePath + "/index.html" : this.resourcePath + path;
            if (this.useZipEntry) {
                ZipEntry zipEntry;
                String[] tokens = requestPath.split("file:")[1].split("!/");
                if (this.zipFile == null) {
                    this.zipFile = new File(URI.create(tokens[0]).getPath());
                    if (!this.zipFile.canRead()) {
                        throw new RuntimeException("Can't read Zip file: " + this.zipFile + " (originally: " + tokens[0] + ")");
                    }
                }
                String innerName = tokens[1];
                FileInputStream fis = new FileInputStream(this.zipFile);
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
                boolean found = false;
                while ((zipEntry = zis.getNextEntry()) != null) {
                    if (!innerName.equals(zipEntry.getName())) continue;
                    in = new ZipFile(this.zipFile).getInputStream(zipEntry);
                    if (event != null) {
                        BaseService.ResponseHeader.on(event).content(zipEntry);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    zis.close();
                    fis.close();
                    in = null;
                }
            } else {
                File file = new File(requestPath);
                if (file.exists()) {
                    if (event != null) {
                        BaseService.ResponseHeader.on(event).content(file);
                    }
                    in = new FileInputStream(file);
                } else {
                    in = null;
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
        }
        return in;
    }

    public void serveSkin(String username, Event event) throws Exception {
        BaseService.ResponseHeader.on(event).contentType(BaseService.ContentType.png);
        TextureImpl tex = TextureCache.instance().getPlayerSkin(username);
        BufferedImage img = tex.getImage();
        if (img != null) {
            this.serveImage(event, img);
        } else {
            event.reply().code("404 Not Found");
        }
    }

    public void serveFile(File sourceFile, Event event) throws Event, IOException {
        BaseService.ResponseHeader.on(event).content(sourceFile);
        this.serveStream(new FileInputStream(sourceFile), event);
    }

    public void serveStream(InputStream input, Event event) throws Event, IOException {
        ReadableByteChannel inputChannel = null;
        WritableByteChannel outputChannel = null;
        try {
            inputChannel = Channels.newChannel(input);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            GZIPOutputStream output = new GZIPOutputStream(bout);
            outputChannel = Channels.newChannel(output);
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            while (inputChannel.read(buffer) != -1) {
                buffer.flip();
                outputChannel.write(buffer);
                buffer.clear();
            }
            output.flush();
            output.close();
            bout.close();
            byte[] gzbytes = bout.toByteArray();
            BaseService.ResponseHeader.on(event).contentLength(gzbytes.length).setHeader("Content-encoding", "gzip");
            event.output().write(gzbytes);
        }
        catch (IOException e) {
            Journeymap.getLogger().error(LogFormatter.toString(e));
            throw event;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    @Override
    protected byte[] gzip(String data) {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            GZIPOutputStream output = new GZIPOutputStream(bout);
            output.write(data.getBytes());
            output.flush();
            output.close();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception ex) {
            Journeymap.getLogger().warn("Failed to gzip encode: " + data);
            return null;
        }
    }
}

