/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.oldservercode.mapcontrol;

import journeymap.server.oldservercode.config.ConfigHandler;
import journeymap.server.oldservercode.config.Configuration;
import journeymap.server.oldservercode.util.PlayerUtil;

public class MappingOptionsHandler {
    private Configuration config;

    public MappingOptionsHandler(String worldName) {
        this.config = ConfigHandler.getConfigByWorldName(worldName);
    }

    public boolean disableRadar(String player) {
        if (this.config.getRadar().isPlayerRadar()) {
            return false;
        }
        if (PlayerUtil.isOp(player) && this.config.getRadar().isOpRadar()) {
            return false;
        }
        return this.config.getRadar().getWhiteListRadar() == null || !this.isUserInWhiteList(this.config.getRadar().getWhiteListRadar(), player);
    }

    public boolean disableCaveMapping(String player) {
        if (this.config.getCaveMapping().isPlayerCaveMapping()) {
            return false;
        }
        if (PlayerUtil.isOp(player) && this.config.getCaveMapping().isOpCaveMapping()) {
            return false;
        }
        return this.config.getCaveMapping().getWhiteListCaveMapping() == null || !this.isUserInWhiteList(this.config.getCaveMapping().getWhiteListCaveMapping(), player);
    }

    private boolean isUserInWhiteList(String userList, String player) {
        if ((userList = userList.replace(" ", "")).contains(",")) {
            String[] whiteListedUsers = userList.split(",");
            for (int i = 0; i < whiteListedUsers.length; ++i) {
                if (!whiteListedUsers[i].equalsIgnoreCase(player)) continue;
                return true;
            }
        } else if (userList.equalsIgnoreCase(player)) {
            return true;
        }
        return false;
    }
}

