/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.github.elytra.copo.CoPoWorldData;
import io.github.elytra.copo.block.BlockController;
import io.github.elytra.copo.block.BlockDriveBay;
import io.github.elytra.copo.block.BlockImporterChest;
import io.github.elytra.copo.block.BlockInterface;
import io.github.elytra.copo.block.BlockMemoryBay;
import io.github.elytra.copo.block.BlockTerminal;
import io.github.elytra.copo.block.BlockWirelessEndpoint;
import io.github.elytra.copo.block.item.ItemBlockController;
import io.github.elytra.copo.block.item.ItemBlockDriveBay;
import io.github.elytra.copo.block.item.ItemBlockInterface;
import io.github.elytra.copo.block.item.ItemBlockMemoryBay;
import io.github.elytra.copo.block.item.ItemBlockTerminal;
import io.github.elytra.copo.block.item.ItemBlockWirelessEndpoint;
import io.github.elytra.copo.compat.WailaCompatibility;
import io.github.elytra.copo.crafting.CRecipes;
import io.github.elytra.copo.crafting.DriveRecipe;
import io.github.elytra.copo.entity.EntityAutomaton;
import io.github.elytra.copo.entity.EntityThrownItem;
import io.github.elytra.copo.entity.automaton.Opcode;
import io.github.elytra.copo.item.ItemCoPoRecord;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.item.ItemFloppy;
import io.github.elytra.copo.item.ItemKeycard;
import io.github.elytra.copo.item.ItemMemory;
import io.github.elytra.copo.item.ItemMisc;
import io.github.elytra.copo.item.ItemModule;
import io.github.elytra.copo.item.ItemWeldthrower;
import io.github.elytra.copo.item.ItemWirelessTerminal;
import io.github.elytra.copo.network.AddStatusLineMessage;
import io.github.elytra.copo.network.AutomatonSpeakMessage;
import io.github.elytra.copo.network.CoPoGuiHandler;
import io.github.elytra.copo.network.EnterDungeonMessage;
import io.github.elytra.copo.network.LeaveDungeonMessage;
import io.github.elytra.copo.network.RecipeTransferMessage;
import io.github.elytra.copo.network.SaveProgramMessage;
import io.github.elytra.copo.network.SetAutomatonNameMessage;
import io.github.elytra.copo.network.SetEditorStatusMessage;
import io.github.elytra.copo.network.SetGlitchingStateMessage;
import io.github.elytra.copo.network.SetSearchQueryClientMessage;
import io.github.elytra.copo.network.SetSearchQueryServerMessage;
import io.github.elytra.copo.network.SetSlotSizeMessage;
import io.github.elytra.copo.network.StartWeldthrowingMessage;
import io.github.elytra.copo.proxy.Proxy;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.NetworkContext;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityDriveBay;
import io.github.elytra.copo.tile.TileEntityImporterChest;
import io.github.elytra.copo.tile.TileEntityInterface;
import io.github.elytra.copo.tile.TileEntityMemoryBay;
import io.github.elytra.copo.tile.TileEntityNetworkImporter;
import io.github.elytra.copo.tile.TileEntityTerminal;
import io.github.elytra.copo.tile.TileEntityVTImporter;
import io.github.elytra.copo.tile.TileEntityWirelessReceiver;
import io.github.elytra.copo.tile.TileEntityWirelessTransmitter;
import io.github.elytra.copo.world.LimboProvider;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="correlatedpotentialistics", name="Correlated Potentialistics", version="2.0.0-alpha1", updateJSON="http://unascribed.com/update-check/correlated-potentialistics.json")
public class CoPo {
    public static Logger log;
    @Mod.Instance
    public static CoPo inst;
    @SidedProxy(clientSide="io.github.elytra.copo.proxy.ClientProxy", serverSide="io.github.elytra.copo.proxy.Proxy")
    public static Proxy proxy;
    @CapabilityInject(value=ITeslaConsumer.class)
    public static Capability<?> TESLA_CONSUMER;
    public static BlockController controller;
    public static BlockDriveBay drive_bay;
    public static BlockMemoryBay memory_bay;
    public static BlockTerminal terminal;
    public static BlockInterface iface;
    public static BlockWirelessEndpoint wireless_endpoint;
    public static BlockImporterChest importer_chest;
    public static ItemMisc misc;
    public static ItemDrive drive;
    public static ItemMemory memory;
    public static ItemModule module;
    public static ItemFloppy floppy;
    public static ItemWirelessTerminal wireless_terminal;
    public static ItemWeldthrower weldthrower;
    public static ItemKeycard keycard;
    public static SoundEvent weldthrow;
    public static SoundEvent glitchbgm;
    public static SoundEvent glitchfloppy;
    public static SoundEvent glitchboot;
    public static SoundEvent convert;
    public static SoundEvent glitchtravel;
    public static SoundEvent automaton_idle;
    public static SoundEvent automaton_hurt;
    public static SoundEvent drive_disassemble;
    public static SoundEvent data_core_shatter;
    public static List<ItemCoPoRecord> recordItems;
    public static List<String> records;
    public static CreativeTabs creativeTab;
    public static int limboDimId;
    public static DimensionType limbo;
    public NetworkContext network;
    public boolean easyProcessors;
    public double defaultWirelessRange;
    public int controllerRfUsage;
    public int driveBayRfUsage;
    public int memoryBayRfUsage;
    public int terminalRfUsage;
    public int interfaceRfUsage;
    public int transmitterRfUsage;
    public int receiverRfUsage;
    public int driveRfUsagePow;
    public int driveRfUsageDiv;
    public int voidDriveUsage;
    public boolean weldthrowerHurts;
    public boolean refundContent;
    public boolean refundBlocks;
    public boolean refundDriveComponents;
    public boolean importNetworks;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        log = LogManager.getLogger((String)"CoPo");
        Configuration config = new Configuration(e.getSuggestedConfigurationFile());
        this.easyProcessors = config.getBoolean("easyProcessors", "Crafting", false, "If true, processors can be crafted without going to the limbo dungeon. Not recommended.");
        this.defaultWirelessRange = config.getFloat("defaultWirelessRange", "Balance", 64.0f, 1.0f, 65536.0f, "The default radius of wireless transmitters, in blocks.");
        this.weldthrowerHurts = config.getBoolean("weldthrowerHurts", "Balance", true, "If enabled, the Weldthrower will damage mobs and set them on fire.");
        this.controllerRfUsage = config.getInt("controller", "PowerUsage", 32, 0, 640, "The RF/t used by the Controller.");
        this.driveBayRfUsage = config.getInt("driveBay", "PowerUsage", 8, 0, 640, "The RF/t used by the Drive Bay.");
        this.memoryBayRfUsage = config.getInt("memoryBay", "PowerUsage", 4, 0, 640, "The RF/t used by the Memory Bay.");
        this.terminalRfUsage = config.getInt("terminal", "PowerUsage", 4, 0, 640, "The RF/t used by the Terminal.");
        this.interfaceRfUsage = config.getInt("interface", "PowerUsage", 8, 0, 640, "The RF/t used by the Interface.");
        this.transmitterRfUsage = config.getInt("transmitter", "PowerUsage", 16, 0, 640, "The RF/t used by the Wireless Transmitter.");
        this.receiverRfUsage = config.getInt("receiver", "PowerUsage", 16, 0, 640, "The RF/t used by the Wireless Receiver.");
        this.driveRfUsagePow = config.getInt("drivePow", "PowerUsage", 2, 0, 8, "Drive power usage is (pow**tier)/div");
        this.driveRfUsageDiv = config.getInt("driveDiv", "PowerUsage", 2, 0, 8, "Drive power usage is (pow**tier)/div");
        this.voidDriveUsage = config.getInt("voidDrive", "PowerUsage", 4, 0, 640, "The RF/t used by the Void Drive.");
        limboDimId = config.getInt("limboDimId", "IDs", -31, -256, 256, "The dimension ID for the glitch dungeon.");
        String importModeStr = config.getString("mode", "Import", "refund_all", "The mode for the old network importer, which will run on any 1.x networks loaded with CoPo 2.x. Possible values are:\nrefund_all: Refund components, convert drives into Data Cores, and refund Interface contents. [default]\nrefund_some: Convert drives into Data Cores and refund Interface contents, but do not refund drive crafting ingredients. Useful if you used MineTweaker to change the recipes. Blocks will still be refunded.\nrefund_content: Convert drives into Data Cores and refund Interface contents, but do not refund anything else.\ndestroy: Outright delete the network, and all items that were contained in it. If you use this option, PLEASE state it prominently on your modpack page, and warn people.\nleave: Leave the network alone. May result in glitchy drives holding more data than they should be able to, crashes, and general strangeness. Not recommended.");
        String string = importModeStr.toLowerCase(Locale.ROOT).trim();
        int n = -1;
        switch (string.hashCode()) {
            case -1710748582: {
                if (!string.equals("refund_all")) break;
                n = 1;
                break;
            }
            case -1493059237: {
                if (!string.equals("refund_some")) break;
                n = 2;
                break;
            }
            case 1934869170: {
                if (!string.equals("refund_content")) break;
                n = 3;
                break;
            }
            case 1557372922: {
                if (!string.equals("destroy")) break;
                n = 4;
                break;
            }
            case 102846135: {
                if (!string.equals("leave")) break;
                n = 5;
            }
        }
        switch (n) {
            default: {
                log.warn("Import mode set to unknown value {}, assuming refund_all", new Object[]{importModeStr});
            }
            case 1: {
                this.refundContent = true;
                this.refundBlocks = true;
                this.refundDriveComponents = true;
                this.importNetworks = true;
                break;
            }
            case 2: {
                this.refundContent = true;
                this.refundBlocks = true;
                this.refundDriveComponents = false;
                this.importNetworks = true;
                break;
            }
            case 3: {
                this.refundContent = true;
                this.refundBlocks = false;
                this.refundDriveComponents = false;
                this.importNetworks = true;
                break;
            }
            case 4: {
                log.warn("Network importer mode is set to DESTROY. Old CoPo 1.x networks WILL BE LOST FOREVER.");
                this.refundContent = false;
                this.refundBlocks = false;
                this.refundDriveComponents = false;
                this.importNetworks = true;
                break;
            }
            case 5: {
                this.importNetworks = false;
            }
        }
        config.save();
        this.network = NetworkContext.forChannel("Correlated");
        this.network.register(SetSearchQueryClientMessage.class);
        this.network.register(SetSearchQueryServerMessage.class);
        this.network.register(SetSlotSizeMessage.class);
        this.network.register(StartWeldthrowingMessage.class);
        this.network.register(SetGlitchingStateMessage.class);
        this.network.register(EnterDungeonMessage.class);
        this.network.register(SetAutomatonNameMessage.class);
        this.network.register(LeaveDungeonMessage.class);
        this.network.register(AddStatusLineMessage.class);
        this.network.register(AutomatonSpeakMessage.class);
        this.network.register(SetEditorStatusMessage.class);
        this.network.register(SaveProgramMessage.class);
        this.network.register(RecipeTransferMessage.class);
        EntityRegistry.registerModEntity(EntityThrownItem.class, (String)"thrown_item", (int)0, (Object)this, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EntityAutomaton.class, (String)"automaton", (int)1, (Object)this, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerEgg(EntityAutomaton.class, (int)3622735, (int)63681);
        limbo = DimensionType.register((String)"Limbo", (String)"_copodungeon", (int)limboDimId, LimboProvider.class, (boolean)false);
        DimensionManager.registerDimension((int)limboDimId, (DimensionType)limbo);
        this.registerSound("weldthrow");
        this.registerSound("glitchbgm");
        this.registerSound("glitchfloppy");
        this.registerSound("glitchboot");
        this.registerSound("convert");
        this.registerSound("glitchtravel");
        this.registerSound("automaton_hurt");
        this.registerSound("automaton_idle");
        this.registerSound("drive_disassemble");
        this.registerSound("data_core_shatter");
        this.registerRecord("danslarue.xm");
        this.registerRecord("jesuisbaguette.xm");
        this.registerRecord("papillons.xm");
        this.registerRecord("dreidl.mod");
        this.registerRecord("oak.mod");
        this.registerRecord("king.mod");
        this.registerRecord("comrades.mod");
        this.registerRecord("devenirmondefi.mod");
        this.registerRecord("ngenracer.mod");
        this.registerRecord("sevensixteen.mod");
        this.registerRecord("ombres.mod");
        this.registerRecord("sacrecharlemagne.mod");
        this.registerRecord("danone.mod");
        this.registerRecord("spark.mod");
        this.registerRecord("genesis.mod");
        this.registerRecord("greyatari.mod");
        this.registerRecord("ella.mod");
        this.registerRecord("framboise.mod");
        this.registerRecord("grecque.mod");
        this.registerRecord("que.mod");
        this.registerRecord("suddenlyisee.mod");
        this.registerRecord("sixsixtythreefoureightytwo.mod");
        this.registerRecord("pinkssideoftown.mod");
        this.registerRecord("thirteen.mod");
        this.registerRecord("irokos.mod");
        this.register(new BlockController().func_149711_c(2.0f), ItemBlockController.class, "controller", 4);
        this.register(new BlockDriveBay().func_149711_c(2.0f), ItemBlockDriveBay.class, "drive_bay", 0);
        this.register(new BlockMemoryBay().func_149711_c(2.0f), ItemBlockMemoryBay.class, "memory_bay", 0);
        this.register(new BlockTerminal().func_149711_c(2.0f), ItemBlockTerminal.class, "terminal", 0);
        this.register(new BlockInterface().func_149711_c(2.0f), ItemBlockInterface.class, "iface", 0);
        this.register(new BlockWirelessEndpoint().func_149711_c(2.0f), ItemBlockWirelessEndpoint.class, "wireless_endpoint", -4);
        this.register(new BlockImporterChest().func_149711_c(2.0f), null, "importer_chest", 0);
        this.register(new ItemMisc(), "misc", -2);
        this.register(new ItemDrive(), "drive", -1);
        this.register(new ItemMemory(), "memory", -1);
        this.register(new ItemModule(), "module", ItemModule.types.length);
        this.register(new ItemFloppy(), "floppy", -2);
        this.register(new ItemWirelessTerminal(), "wireless_terminal", 0);
        this.register(new ItemWeldthrower(), "weldthrower", 0);
        this.register(new ItemKeycard(), "keycard", -2);
        RecipeSorter.register((String)"correlatedpotentialistics:drive", DriveRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        CRecipes.register();
        GameRegistry.registerTileEntity(TileEntityController.class, (String)"correlatedpotentialistics:controller_new");
        GameRegistry.registerTileEntity(TileEntityDriveBay.class, (String)"correlatedpotentialistics:drive_bay");
        GameRegistry.registerTileEntity(TileEntityMemoryBay.class, (String)"correlatedpotentialistics:memory_bay");
        GameRegistry.registerTileEntity(TileEntityTerminal.class, (String)"correlatedpotentialistics:terminal");
        GameRegistry.registerTileEntity(TileEntityInterface.class, (String)"correlatedpotentialistics:interface");
        GameRegistry.registerTileEntity(TileEntityWirelessReceiver.class, (String)"correlatedpotentialistics:wireless_receiver");
        GameRegistry.registerTileEntity(TileEntityWirelessTransmitter.class, (String)"correlatedpotentialistics:wireless_transmitter");
        GameRegistry.registerTileEntity(TileEntityImporterChest.class, (String)"correlatedpotentialistics:importer_chest");
        GameRegistry.registerTileEntity(TileEntityNetworkImporter.class, (String)"correlatedpotentialistics:controller");
        GameRegistry.registerTileEntity(TileEntityVTImporter.class, (String)"correlatedpotentialistics:vt");
        Opcode.init();
        if (Loader.isModLoaded((String)"Waila")) {
            WailaCompatibility.init();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new CoPoGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void onMissingMappings(FMLMissingMappingsEvent e) {
        for (FMLMissingMappingsEvent.MissingMapping mm : e.get()) {
            if (!mm.resourceLocation.func_110623_a().equals("vt")) continue;
            if (mm.type == GameRegistry.Type.BLOCK) {
                mm.remap((Block)terminal);
                continue;
            }
            mm.remap(Item.func_150898_a((Block)terminal));
        }
    }

    @SubscribeEvent
    public void onLootAdd(LootTableLoadEvent e) {
        if (e.getName().toString().startsWith("minecraft:chests/")) {
            e.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)misc, 45, 0, new LootFunction[0], new LootCondition[0], "correlatedpotentialistics:processor"));
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        CoPoWorldData d = CoPo.getDataFor(e.player.field_70170_p);
        UUID id = e.player.func_146103_bH().getId();
        if (d.getPlayerRespawnData().containsKey(id)) {
            e.player.func_70020_e(d.getPlayerRespawnData().remove(id));
        }
    }

    public static CoPoWorldData getDataFor(World w) {
        CoPoWorldData data = (CoPoWorldData)w.getPerWorldStorage().func_75742_a(CoPoWorldData.class, "correlatedpotentialistics");
        if (data == null) {
            data = new CoPoWorldData("correlatedpotentialistics");
            w.getPerWorldStorage().func_75745_a("correlatedpotentialistics", (WorldSavedData)data);
        }
        return data;
    }

    private void registerRecord(String str) {
        try {
            records.add(str);
            String basename = str.substring(0, str.indexOf(46));
            ResourceLocation loc = new ResourceLocation("correlatedpotentialistics", basename);
            SoundEvent snd = new SoundEvent(loc);
            GameRegistry.register((IForgeRegistryEntry)snd, (ResourceLocation)loc);
            ItemCoPoRecord item = new ItemCoPoRecord(basename, snd);
            item.setRegistryName("record_" + basename);
            item.func_77655_b("record");
            item.func_77637_a(creativeTab);
            GameRegistry.register((IForgeRegistryEntry)item);
            proxy.registerItemModel((Item)item, 0);
            recordItems.add(item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registerSound(String str) {
        ResourceLocation loc = new ResourceLocation("correlatedpotentialistics", str);
        SoundEvent snd = new SoundEvent(loc);
        GameRegistry.register((IForgeRegistryEntry)snd, (ResourceLocation)loc);
        try {
            Field f = this.getClass().getField(str);
            f.set(null, snd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void register(Block block, Class<? extends ItemBlock> item, String name, int itemVariants) {
        block.func_149663_c("correlatedpotentialistics." + name);
        block.func_149647_a(creativeTab);
        block.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)block);
        if (item != null) {
            try {
                ItemBlock ib = item.getConstructor(Block.class).newInstance(block);
                ib.setRegistryName(name);
                GameRegistry.register((IForgeRegistryEntry)ib);
            }
            catch (Exception e1) {
                Throwables.propagate((Throwable)e1);
            }
            proxy.registerItemModel(Item.func_150898_a((Block)block), itemVariants);
        }
        try {
            this.getClass().getField(name).set(this, block);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void register(Item item, String name, int variants) {
        item.func_77655_b("correlatedpotentialistics." + name);
        item.func_77637_a(creativeTab);
        item.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)item);
        proxy.registerItemModel(item, variants);
        try {
            this.getClass().getField(name).set(this, item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        recordItems = Lists.newArrayList();
        records = Lists.newArrayList();
        creativeTab = new CreativeTabs("correlatedPotentialistics"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)controller);
            }
        };
    }
}

