/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.block;

import io.github.elytra.copo.helper.Blocks;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.tile.TileEntityDriveBay;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDriveBay
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockDriveBay() {
        super(Material.field_151573_f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityDriveBay();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() & 3 | ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 4 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facingIn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityNetworkMember) {
            ((TileEntityNetworkMember)te).handleNeighborChange(world, pos, neighbor);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityDriveBay) {
            TileEntityDriveBay tedb = (TileEntityDriveBay)te;
            for (ItemStack drive : tedb) {
                BlockDriveBay.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drive);
            }
            tedb.clear();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (Blocks.tryWrench(world, pos, player, hand, side, hitZ, hitZ, hitZ)) {
            return true;
        }
        ItemStack inHand = player.func_184586_b(hand);
        int slot = this.getLookedAtSlot(state, side, hitX, hitY, hitZ);
        if (slot != -1 && (te = world.func_175625_s(pos)) instanceof TileEntityDriveBay) {
            TileEntityDriveBay tedb = (TileEntityDriveBay)te;
            if (tedb.hasDriveInSlot(slot)) {
                if (!world.field_72995_K) {
                    EntityItem ent = new EntityItem(world, (double)((float)pos.func_177958_n() + hitX) + (double)side.func_82601_c() * 0.2, (double)((float)pos.func_177956_o() + hitY) + (double)side.func_96559_d() * 0.2, (double)((float)pos.func_177952_p() + hitZ) + (double)side.func_82599_e() * 0.2);
                    ent.func_92058_a(tedb.getDriveInSlot(slot));
                    ent.func_174868_q();
                    world.func_72838_d((Entity)ent);
                    tedb.setDriveInSlot(slot, null);
                }
                return true;
            }
            if (inHand != null && inHand.func_77973_b() instanceof ItemDrive) {
                if (!world.field_72995_K) {
                    tedb.setDriveInSlot(slot, inHand.func_77946_l());
                    inHand.field_77994_a = 0;
                }
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public int getLookedAtSlot(IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        float x;
        if (side != state.func_177229_b((IProperty)FACING)) {
            return -1;
        }
        float y = 1.0f - hitY;
        switch (side) {
            case NORTH: {
                x = 1.0f - hitX;
                break;
            }
            case EAST: {
                x = 1.0f - hitZ;
                break;
            }
            case SOUTH: {
                x = hitX;
                break;
            }
            case WEST: {
                x = hitZ;
                break;
            }
            default: {
                x = 0.0f;
            }
        }
        int slot = -1;
        if (this.withinRegion(x, y, 3, 3)) {
            slot = 0;
        } else if (this.withinRegion(x, y, 9, 3)) {
            slot = 1;
        } else if (this.withinRegion(x, y, 3, 6)) {
            slot = 2;
        } else if (this.withinRegion(x, y, 9, 6)) {
            slot = 3;
        } else if (this.withinRegion(x, y, 3, 9)) {
            slot = 4;
        } else if (this.withinRegion(x, y, 9, 9)) {
            slot = 5;
        } else if (this.withinRegion(x, y, 3, 12)) {
            slot = 6;
        } else if (this.withinRegion(x, y, 9, 12)) {
            slot = 7;
        }
        return slot;
    }

    private boolean withinRegion(float x, float y, int regionX, int regionY) {
        return x >= (float)regionX / 16.0f && x <= (float)(regionX + 4) / 16.0f && y >= (float)regionY / 16.0f && y <= (float)(regionY + 2) / 16.0f;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

