/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.block;

import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.ITweakable;
import io.github.elytra.copo.helper.Blocks;
import io.github.elytra.copo.tile.TileEntityInterface;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInterface
extends Block
implements ITweakable {
    public static final IProperty<TileEntityInterface.FaceMode> TOP = PropertyEnum.func_177709_a((String)"top", TileEntityInterface.FaceMode.class);
    public static final IProperty<TileEntityInterface.FaceMode> BOTTOM = PropertyEnum.func_177709_a((String)"bottom", TileEntityInterface.FaceMode.class);
    public static final IProperty<TileEntityInterface.FaceMode> NORTH = PropertyEnum.func_177709_a((String)"north", TileEntityInterface.FaceMode.class);
    public static final IProperty<TileEntityInterface.FaceMode> EAST = PropertyEnum.func_177709_a((String)"east", TileEntityInterface.FaceMode.class);
    public static final IProperty<TileEntityInterface.FaceMode> SOUTH = PropertyEnum.func_177709_a((String)"south", TileEntityInterface.FaceMode.class);
    public static final IProperty<TileEntityInterface.FaceMode> WEST = PropertyEnum.func_177709_a((String)"west", TileEntityInterface.FaceMode.class);

    public BlockInterface() {
        super(Material.field_151573_f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TOP, BOTTOM, NORTH, EAST, SOUTH, WEST});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityInterface) {
            TileEntityInterface tei = (TileEntityInterface)te;
            state = state.func_177226_a(TOP, (Comparable)((Object)tei.getModeForFace(EnumFacing.UP)));
            state = state.func_177226_a(BOTTOM, (Comparable)((Object)tei.getModeForFace(EnumFacing.DOWN)));
            state = state.func_177226_a(NORTH, (Comparable)((Object)tei.getModeForFace(EnumFacing.NORTH)));
            state = state.func_177226_a(EAST, (Comparable)((Object)tei.getModeForFace(EnumFacing.EAST)));
            state = state.func_177226_a(SOUTH, (Comparable)((Object)tei.getModeForFace(EnumFacing.SOUTH)));
            state = state.func_177226_a(WEST, (Comparable)((Object)tei.getModeForFace(EnumFacing.WEST)));
        }
        return super.func_176221_a(state, world, pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityInterface();
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityNetworkMember) {
            ((TileEntityNetworkMember)te).handleNeighborChange(world, pos, neighbor);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityInterface) {
            TileEntityInterface tei = (TileEntityInterface)te;
            for (int i = 0; i < tei.func_70302_i_(); ++i) {
                ItemStack is = tei.func_70301_a(i);
                if (is == null) continue;
                BlockInterface.func_180635_a((World)world, (BlockPos)pos, (ItemStack)is);
                tei.func_70299_a(i, null);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (Blocks.tryWrench(world, pos, player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!player.func_70093_af()) {
            player.openGui((Object)CoPo.inst, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @Override
    public void onTweak(World world, BlockPos pos, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityInterface) {
            IBlockState oldstate = world.func_180495_p(pos);
            TileEntityInterface tei = (TileEntityInterface)te;
            TileEntityInterface.FaceMode[] values = TileEntityInterface.FaceMode.values();
            TileEntityInterface.FaceMode cur = tei.getModeForFace(side);
            TileEntityInterface.FaceMode nw = values[(cur.ordinal() + 1) % values.length];
            tei.setModeForFace(side, nw);
            IBlockState newstate = world.func_180495_p(pos);
            world.func_184138_a(pos, oldstate, newstate, 8);
        }
    }
}

