/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.block;

import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.block.BlockController;
import io.github.elytra.copo.helper.Blocks;
import io.github.elytra.copo.item.ItemFloppy;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import io.github.elytra.copo.tile.TileEntityTerminal;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTerminal
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final PropertyBool FLOPPY = PropertyBool.func_177716_a((String)"floppy");

    public BlockTerminal() {
        super(Material.field_151573_f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTerminal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT, FLOPPY});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() & 3 | ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 4 : 0) | ((Boolean)state.func_177229_b((IProperty)FLOPPY) != false ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)FLOPPY, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facingIn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityNetworkMember) {
            ((TileEntityNetworkMember)te).handleNeighborChange(world, pos, neighbor);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (Blocks.tryWrench(world, pos, player, hand, side, hitZ, hitZ, hitZ)) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityTerminal) {
                TileEntityTerminal tet = (TileEntityTerminal)te;
                if (side == state.func_177229_b((IProperty)FACING)) {
                    float x;
                    float y = 1.0f - hitY;
                    switch (side) {
                        case NORTH: {
                            x = 1.0f - hitX;
                            break;
                        }
                        case EAST: {
                            x = 1.0f - hitZ;
                            break;
                        }
                        case SOUTH: {
                            x = hitX;
                            break;
                        }
                        case WEST: {
                            x = hitZ;
                            break;
                        }
                        default: {
                            x = 0.0f;
                        }
                    }
                    if (this.withinRegion(x, y, 5, 13)) {
                        if (heldItem != null && heldItem.func_77973_b() instanceof ItemFloppy) {
                            tet.func_70299_a(1, heldItem.func_77946_l());
                            heldItem.field_77994_a = 0;
                            return true;
                        }
                        if (tet.func_70301_a(1) != null) {
                            if (!world.field_72995_K) {
                                EntityItem ent = new EntityItem(world, (double)((float)pos.func_177958_n() + hitX) + (double)side.func_82601_c() * 0.2, (double)((float)pos.func_177956_o() + hitY) + (double)side.func_96559_d() * 0.2, (double)((float)pos.func_177952_p() + hitZ) + (double)side.func_82599_e() * 0.2);
                                ent.func_92058_a(tet.func_70304_b(1));
                                ent.func_174868_q();
                                world.func_72838_d((Entity)ent);
                            }
                            return true;
                        }
                    }
                }
                if (tet.hasStorage()) {
                    if (!world.field_72995_K) {
                        switch ((BlockController.State)((Object)world.func_180495_p(tet.getStorage().func_174877_v()).func_177229_b(BlockController.state))) {
                            case BOOTING: {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.terminal_booting", new Object[0]));
                                break;
                            }
                            case ERROR: {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.terminal_error", new Object[0]));
                                break;
                            }
                            case OFF: {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.terminal_no_power", new Object[0]));
                                break;
                            }
                            case POWERED: {
                                player.openGui((Object)CoPo.inst, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                                break;
                            }
                        }
                    }
                    return true;
                }
            }
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.terminal_no_controller", new Object[0]));
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    private boolean withinRegion(float x, float y, int regionX, int regionY) {
        return x >= (float)regionX / 16.0f && x <= (float)(regionX + 6) / 16.0f && y >= (float)regionY / 16.0f && y <= (float)(regionY + 1) / 16.0f;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

