/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.block;

import com.google.common.base.Supplier;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.CoPoWorldData;
import io.github.elytra.copo.block.BlockWirelessEndpoint$Kind$$Lambda$1;
import io.github.elytra.copo.block.BlockWirelessEndpoint$Kind$$Lambda$2;
import io.github.elytra.copo.helper.Blocks;
import io.github.elytra.copo.tile.TileEntityWirelessReceiver;
import io.github.elytra.copo.tile.TileEntityWirelessTransmitter;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWirelessEndpoint
extends Block {
    public static final IProperty<Kind> kind = PropertyEnum.func_177709_a((String)"kind", Kind.class);
    public static final IProperty<State> state = PropertyEnum.func_177709_a((String)"state", State.class);
    private AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);

    public BlockWirelessEndpoint() {
        super(Material.field_151573_f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB base = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o() + 0.25, (double)(pos.func_177952_p() + 1));
        AxisAlignedBB pole = new AxisAlignedBB((double)pos.func_177958_n() + 0.4375, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.4375, (double)pos.func_177958_n() + 0.5625, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5625);
        if (mask.func_72326_a(base)) {
            list.add(base);
        }
        if (mask.func_72326_a(pole)) {
            list.add(pole);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.aabb;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return ((Kind)((Object)state.func_177229_b(kind))).createTileEntity();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(kind, (Comparable)((Object)(meta == 0 ? Kind.RECEIVER : Kind.TRANSMITTER)));
    }

    public int func_180651_a(IBlockState state) {
        return ((Kind)((Object)state.func_177229_b(kind))).ordinal();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityWirelessTransmitter && !world.field_72995_K) {
            TileEntityWirelessTransmitter tewt = (TileEntityWirelessTransmitter)te;
            CoPoWorldData data = CoPo.getDataFor(world);
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("TransmitterUUIDMost", 4)) {
                tewt.setId(new UUID(stack.func_77978_p().func_74763_f("TransmitterUUIDMost"), stack.func_77978_p().func_74763_f("TransmitterUUIDLeast")));
            }
            CoPoWorldData.Transmitter t = new CoPoWorldData.Transmitter(tewt.getId(), pos);
            data.addTransmitter(t);
        } else if (te instanceof TileEntityWirelessReceiver && !world.field_72995_K) {
            TileEntityWirelessReceiver tewr = (TileEntityWirelessReceiver)te;
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("TransmitterUUIDMost", 4)) {
                tewr.setTransmitter(new UUID(stack.func_77978_p().func_74763_f("TransmitterUUIDMost"), stack.func_77978_p().func_74763_f("TransmitterUUIDLeast")));
            }
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{state, kind});
    }

    public int func_176201_c(IBlockState state) {
        return ((State)((Object)state.func_177229_b(BlockWirelessEndpoint.state))).ordinal() & 7 | (state.func_177229_b(kind) == Kind.RECEIVER ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(state, (Comparable)((Object)State.VALUES[meta % State.VALUES.length])).func_177226_a(kind, (Comparable)((Object)((meta & 8) != 0 ? Kind.RECEIVER : Kind.TRANSMITTER)));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityWirelessTransmitter) {
            TileEntityWirelessTransmitter tewt = (TileEntityWirelessTransmitter)te;
            CoPoWorldData data = CoPo.getDataFor(world);
            data.removeTransmitterById(tewt.getId());
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, 0));
        list.add(new ItemStack(itemIn, 1, 1));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (Blocks.tryWrench(world, pos, player, hand, side, hitZ, hitZ, hitZ)) {
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public static enum State implements IStringSerializable
    {
        DEAD,
        ERROR,
        LINKED;

        public static final State[] VALUES;
        private final String lowerName = this.name().toLowerCase();

        public String func_176610_l() {
            return this.lowerName;
        }

        public String toString() {
            return this.lowerName;
        }

        static {
            VALUES = State.values();
        }
    }

    public static enum Kind implements IStringSerializable
    {
        RECEIVER((Supplier<TileEntity>)BlockWirelessEndpoint$Kind$$Lambda$1.lambdaFactory$()),
        TRANSMITTER((Supplier<TileEntity>)BlockWirelessEndpoint$Kind$$Lambda$2.lambdaFactory$());

        public static final Kind[] VALUES;
        private final Supplier<TileEntity> teConstructor;
        private final String lowerName = this.name().toLowerCase();

        private Kind(Supplier<TileEntity> teConstructor) {
            this.teConstructor = teConstructor;
        }

        public String func_176610_l() {
            return this.lowerName;
        }

        public String toString() {
            return this.lowerName;
        }

        public TileEntity createTileEntity() {
            return (TileEntity)this.teConstructor.get();
        }

        static {
            VALUES = Kind.values();
        }
    }
}

