/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.client.gui;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.github.elytra.copo.client.IBMFontRenderer;
import io.github.elytra.copo.client.gui.shell.GuiTerminalShell;
import io.github.elytra.copo.helper.Numbers;
import io.github.elytra.copo.inventory.ContainerTerminal;
import io.github.elytra.copo.network.SetSearchQueryServerMessage;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.lwjgl.input.Mouse;

public class GuiTerminal
extends GuiContainer {
    private static final ResourceLocation background = new ResourceLocation("correlatedpotentialistics", "textures/gui/container/terminal.png");
    private ContainerTerminal container;
    private GuiTextField searchField;
    private String lastSearchQuery;
    private GuiButtonExt sortDirection;
    private GuiButtonExt sortMode;
    private GuiButtonExt craftingTarget;
    private GuiButtonExt craftingAmount;
    private GuiButtonExt clearGrid;
    private boolean draggingScrollKnob;
    private int scrollKnobY;
    private int ticksSinceLastQueryChange;

    public GuiTerminal(ContainerTerminal container) {
        super((Container)container);
        this.searchField = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, 0, 0, 85, 8);
        this.lastSearchQuery = "";
        this.draggingScrollKnob = false;
        this.scrollKnobY = 6;
        this.ticksSinceLastQueryChange = 0;
        this.searchField.func_146185_a(false);
        this.searchField.func_146193_g(-1);
        this.container = container;
        this.field_146999_f = 256;
        this.field_147000_g = 222;
        if (container.status.isEmpty()) {
            if (Math.random() == 0.5) {
                container.status.add("Dis is one half.");
            } else {
                container.status.add("Ready.");
            }
        }
    }

    protected boolean hasStatusLine() {
        return true;
    }

    protected boolean hasSearchAndSort() {
        return true;
    }

    protected ResourceLocation getBackground() {
        return background;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((this.field_146294_l - this.field_146999_f) / 2), (float)((this.field_146295_m - this.field_147000_g) / 2), (float)0.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(0, 0, 0, 0, 256, 222);
        if (this.container.terminal.supportsDumpSlot()) {
            this.func_73729_b(17, 153, 200, 224, 32, 32);
        }
        GlStateManager.func_179121_F();
    }

    protected String getTitle() {
        return I18n.func_135052_a((String)"gui.correlatedpotentialistics.terminal", (Object[])new Object[0]);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getTitle(), 8, 6, 0x404040);
        if (this.hasStatusLine()) {
            Object lastLine = Strings.nullToEmpty((String)this.container.status.get(this.container.status.size() - 1));
            if (((String)lastLine).length() > 32) {
                lastLine = ((String)lastLine).substring(0, 32) + "...";
            }
            int left = 68 + this.container.playerInventoryOffsetX;
            int top = 90 + this.container.playerInventoryOffsetY;
            int right = 230 + this.container.playerInventoryOffsetX;
            int bottom = 100 + this.container.playerInventoryOffsetY;
            GuiTerminal.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-16749237);
            IBMFontRenderer.drawString(left + 2, top + 1, (String)lastLine, 56237);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        for (Slot slot : this.field_147002_h.field_75151_b) {
            ContainerTerminal.SlotVirtual sv;
            if (!(slot instanceof ContainerTerminal.SlotVirtual) || (sv = (ContainerTerminal.SlotVirtual)slot).getCount() <= 0) continue;
            String str = Numbers.humanReadableItemCount(sv.getCount());
            int x = sv.field_75223_e * 2;
            int y = sv.field_75221_f * 2;
            this.field_146297_k.field_71466_p.func_175063_a(str, (float)(x += 32 - this.field_146297_k.field_71466_p.func_78256_a(str)), (float)(y += 32 - this.field_146297_k.field_71466_p.field_78288_b), -1);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        int u = 232;
        if (this.container.rows <= this.container.slotsTall) {
            u += 12;
        }
        int y = 18;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(this.getScrollTrackX(), this.getScrollTrackY() + y + (this.scrollKnobY - 6), u, 241, 12, 15);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-(this.field_146294_l - this.field_146999_f) / 2), (float)(-(this.field_146295_m - this.field_147000_g) / 2), (float)0.0f);
        if (this.container.hasCraftingMatrix) {
            this.func_73729_b(this.clearGrid.field_146128_h + 2, this.clearGrid.field_146129_i + 2, 0, 222, 2, 10);
            this.func_73729_b(this.craftingTarget.field_146128_h + 2, this.craftingTarget.field_146129_i + 2, this.container.craftingTarget.ordinal() * 8, 232, 8, 8);
            this.func_73729_b(this.craftingAmount.field_146128_h + 2, this.craftingAmount.field_146129_i + 2, this.container.craftingAmount.ordinal() * 8, 240, 8, 8);
        }
        if (this.hasSearchAndSort()) {
            this.func_73729_b(this.sortDirection.field_146128_h + 2, this.sortDirection.field_146129_i + 2, this.container.sortAscending ? 0 : 8, 248, 8, 8);
            this.func_73729_b(this.sortMode.field_146128_h + 2, this.sortMode.field_146129_i + 2, 16 + this.container.sortMode.ordinal() * 8, 248, 8, 8);
            this.searchField.func_146194_f();
            if (this.sortMode.func_146115_a()) {
                this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.sortmode", (Object[])new Object[0]), "\u00a77" + I18n.func_135052_a((String)("tooltip.correlatedpotentialistics.sortmode." + this.container.sortMode.lowerName), (Object[])new Object[0])}), mouseX, mouseY);
            }
            if (this.sortDirection.func_146115_a()) {
                String str = this.container.sortAscending ? "ascending" : "descending";
                this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.sortdirection", (Object[])new Object[0]), "\u00a77" + I18n.func_135052_a((String)("tooltip.correlatedpotentialistics.sortdirection." + str), (Object[])new Object[0])}), mouseX, mouseY);
            }
            if (this.container.hasCraftingMatrix) {
                if (this.craftingAmount.func_146115_a()) {
                    this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.crafting_amount", (Object[])new Object[0]), "\u00a77" + I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.crafting.only_shift_click", (Object[])new Object[0]), "\u00a77" + I18n.func_135052_a((String)("tooltip.correlatedpotentialistics.crafting_amount." + this.container.craftingAmount.lowerName), (Object[])new Object[0])}), mouseX, mouseY);
                }
                if (this.craftingTarget.func_146115_a()) {
                    this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.crafting_target", (Object[])new Object[0]), "\u00a77" + I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.crafting.only_shift_click", (Object[])new Object[0]), "\u00a77" + I18n.func_135052_a((String)("tooltip.correlatedpotentialistics.crafting_target." + this.container.craftingTarget.lowerName), (Object[])new Object[0])}), mouseX, mouseY);
                }
                if (this.clearGrid.func_146115_a()) {
                    this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"tooltip.correlatedpotentialistics.clear_crafting_grid", (Object[])new Object[0])}), mouseX, mouseY);
                }
            }
        }
        GlStateManager.func_179121_F();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        x += this.getXOffset();
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        y += this.getYOffset();
        if (this.hasSearchAndSort()) {
            this.searchField.field_146209_f = x + 143;
            this.searchField.field_146210_g = y + 6;
            this.sortDirection = new GuiButtonExt(0, x + 236, y + 4, 12, 12, "");
            this.field_146292_n.add(this.sortDirection);
            this.sortMode = new GuiButtonExt(1, x + 128, y + 4, 12, 12, "");
            this.field_146292_n.add(this.sortMode);
        }
        if (this.container.hasCraftingMatrix) {
            this.craftingAmount = new GuiButtonExt(2, x + 51, y + 99, 12, 12, "");
            this.field_146292_n.add(this.craftingAmount);
            this.craftingTarget = new GuiButtonExt(3, x + 51, y + 113, 12, 12, "");
            this.field_146292_n.add(this.craftingTarget);
            this.clearGrid = new GuiButtonExt(4, x + 61, y + 37, 6, 14, "");
            this.field_146292_n.add(this.clearGrid);
        }
    }

    protected int getYOffset() {
        return 0;
    }

    protected int getXOffset() {
        return 0;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, this.container.sortAscending ? -2 : -1);
            this.container.sortAscending = !this.container.sortAscending;
        } else if (button.field_146127_k == 1) {
            switch (this.container.sortMode) {
                case QUANTITY: {
                    this.container.sortMode = ContainerTerminal.SortMode.MOD_MINECRAFT_FIRST;
                    this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, -4);
                    break;
                }
                case MOD_MINECRAFT_FIRST: {
                    this.container.sortMode = ContainerTerminal.SortMode.MOD;
                    this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, -5);
                    break;
                }
                case MOD: {
                    this.container.sortMode = ContainerTerminal.SortMode.NAME;
                    this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, -6);
                    break;
                }
                case NAME: {
                    this.container.sortMode = ContainerTerminal.SortMode.QUANTITY;
                    this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, -3);
                }
            }
        } else if (button.field_146127_k == 2) {
            switch (this.container.craftingAmount) {
                case ONE: {
                    this.container.craftingAmount = ContainerTerminal.CraftingAmount.STACK;
                    this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, -11);
                    break;
                }
                case STACK: {
                    this.container.craftingAmount = ContainerTerminal.CraftingAmount.MAX;
                    this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, -12);
                    break;
                }
                case MAX: {
                    this.container.craftingAmount = ContainerTerminal.CraftingAmount.ONE;
                    this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, -10);
                }
            }
        } else if (button.field_146127_k == 3) {
            switch (this.container.craftingTarget) {
                case INVENTORY: {
                    this.container.craftingTarget = ContainerTerminal.CraftingTarget.NETWORK;
                    this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, -21);
                    break;
                }
                case NETWORK: {
                    this.container.craftingTarget = ContainerTerminal.CraftingTarget.INVENTORY;
                    this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, -20);
                }
            }
        } else if (button.field_146127_k == 4) {
            this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, -128);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.container.rows > this.container.slotsTall) {
            int dWheel = Mouse.getDWheel() / this.container.rows;
            if (dWheel != 0) {
                this.scrollKnobY = Math.max(Math.min(this.getScrollTrackHeight() - 9, this.scrollKnobY - dWheel), 6);
                this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, Math.round((float)(this.scrollKnobY - 6) / (float)(this.getScrollTrackHeight() - 9) * (float)(this.container.rows - this.container.slotsTall)));
            }
        } else {
            this.scrollKnobY = 6;
        }
        if (this.hasSearchAndSort()) {
            this.searchField.func_146178_a();
            if (!Objects.equal((Object)this.searchField.func_146179_b(), (Object)this.lastSearchQuery)) {
                this.lastSearchQuery = this.searchField.func_146179_b();
                this.ticksSinceLastQueryChange = 0;
                if (this.scrollKnobY != 6) {
                    this.scrollKnobY = 6;
                    this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, 0);
                }
            }
            ++this.ticksSinceLastQueryChange;
            if (this.ticksSinceLastQueryChange == 4) {
                new SetSearchQueryServerMessage(this.container.field_75152_c, this.lastSearchQuery).sendToServer();
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchField.func_146206_l()) {
            if (keyCode == 1) {
                this.field_146297_k.field_71439_g.func_71053_j();
            } else {
                this.searchField.func_146201_a(typedChar, keyCode);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected int getScrollTrackX() {
        return 236;
    }

    protected int getScrollTrackY() {
        return 0;
    }

    protected int getScrollTrackHeight() {
        return 110;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        int left = 68 + this.container.playerInventoryOffsetX;
        int top = 90 + this.container.playerInventoryOffsetY;
        int right = 230 + this.container.playerInventoryOffsetX;
        int bottom = 100 + this.container.playerInventoryOffsetY;
        if (this.hasStatusLine() && mouseButton == 0 && mouseX >= x + left && mouseX <= x + right && mouseY >= y + top && mouseY <= y + bottom) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTerminalShell(this, this.container));
        }
        int width = 12;
        int height = this.getScrollTrackHeight();
        y += this.getScrollTrackY();
        if (mouseButton == 0 && mouseX >= (x += this.getScrollTrackX()) && mouseX <= x + width && mouseY >= (y += 18) && mouseY <= y + height) {
            this.draggingScrollKnob = true;
            this.func_146273_a(mouseX, mouseY, mouseButton, 0L);
            return;
        }
        if (this.hasSearchAndSort()) {
            if (mouseButton == 1 && mouseX >= this.searchField.field_146209_f && mouseX <= this.searchField.field_146209_f + this.searchField.field_146218_h && mouseY >= this.searchField.field_146210_g && mouseY <= this.searchField.field_146210_g + this.searchField.field_146219_i) {
                this.searchField.func_146180_a("");
            }
            this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        if (this.draggingScrollKnob && this.container.rows > this.container.slotsTall) {
            int y = (this.field_146295_m - this.field_147000_g) / 2;
            this.scrollKnobY = Math.max(Math.min(this.getScrollTrackHeight() - 9, mouseY - 24 - (y += this.getScrollTrackY())), 6);
            int s = Math.round((float)(this.scrollKnobY + 12) / (float)(this.getScrollTrackHeight() - 9) * (float)(this.container.rows - this.container.slotsTall));
            this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, s);
        }
        super.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.draggingScrollKnob = false;
        }
        super.func_146286_b(mouseX, mouseY, mouseButton);
    }

    public void updateSearchQuery(String query) {
        this.lastSearchQuery = query;
        if (this.hasSearchAndSort()) {
            this.searchField.func_146180_a(query);
        }
    }

    public void addLine(String line) {
        this.container.status.add(line);
    }
}

