/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.client.gui.shell;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.client.IBMFontRenderer;
import io.github.elytra.copo.client.gui.shell.CommandInterpreter;
import io.github.elytra.copo.client.gui.shell.GuiTerminalShell;
import io.github.elytra.copo.client.gui.shell.Program;
import io.github.elytra.copo.entity.automaton.Opcode;
import io.github.elytra.copo.item.ItemFloppy;
import io.github.elytra.copo.network.SaveProgramMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class AutomatonProgrammer
extends Program {
    private boolean dirty = false;
    private List<String> opcodes = Lists.newArrayList();
    private List<List<String>> arguments = Lists.newArrayList();
    private int cursorRow = 0;
    private int cursorCol = 0;
    private int cursorField = 0;
    private int totalCols;
    private int totalRows;
    private int scrollOffset;
    private String status;
    private int statusTicks;
    private String cutOpcode;
    private List<String> cutArguments;
    private int xOffset = 1;
    private boolean confirmExit;

    public AutomatonProgrammer(GuiTerminalShell parent) {
        super(parent);
        if (parent.container.floppySlot != null) {
            ItemStack floppy = parent.container.floppySlot.func_75211_c();
            if (floppy != null) {
                if (floppy.func_77942_o() && floppy.func_77978_p().func_150297_b("SourceCode", 9)) {
                    NBTTagList src = floppy.func_77978_p().func_150295_c("SourceCode", 10);
                    System.out.println(src);
                    for (int i = 0; i < src.func_74745_c(); ++i) {
                        NBTTagCompound tag = src.func_150305_b(i);
                        this.opcodes.add(tag.func_74779_i("Opcode"));
                        ArrayList argsList = Lists.newArrayList();
                        NBTTagList args = tag.func_150295_c("Arguments", 8);
                        for (int j = 0; j < args.func_74745_c(); ++j) {
                            argsList.add(((NBTTagString)args.func_179238_g(j)).func_150285_a_());
                        }
                        this.arguments.add(argsList);
                    }
                }
                if (floppy.func_77973_b() instanceof ItemFloppy && ((ItemFloppy)floppy.func_77973_b()).isWriteProtected(floppy)) {
                    this.status = "Warning: Floppy is write protected";
                    this.statusTicks = 0;
                }
            } else {
                this.status = "Warning: No floppy in drive";
                this.statusTicks = 0;
            }
        }
    }

    @Override
    public void render(int rows, int cols) {
        int i;
        int x;
        Opcode oc;
        if (this.status != null && (this.status.contains("Save OK") || this.status.contains("compile OK"))) {
            this.dirty = false;
        }
        if (this.confirmExit && !this.dirty) {
            this.parent.program = new CommandInterpreter(this.parent);
            return;
        }
        float div = (float)this.cursorRow / (float)this.opcodes.size();
        int scrollKnobY = (int)(div * (float)rows);
        scrollKnobY = Math.min(rows - 1, Math.max(0, scrollKnobY));
        this.drawStringInverseVideoAbsolute(cols - 1, scrollKnobY, this.dirty ? "\u25cb" : " ");
        if (this.confirmExit) {
            this.drawStringInverseVideoAbsolute(0, rows - 2, Strings.padEnd((String)"Save? (ANSWERING \"No\" WILL DESTROY CHANGES)", (int)cols, (char)' '));
            this.drawStringInverseVideoAbsolute(0, rows - 1, " Y");
            this.drawStringAbsolute(3, rows - 1, "Yes");
            this.drawStringInverseVideoAbsolute(7, rows - 1, " N");
            this.drawStringAbsolute(10, rows - 1, "No");
            this.drawStringInverseVideoAbsolute(13, rows - 1, "^C");
            this.drawStringAbsolute(16, rows - 1, "Cancel");
            rows -= 2;
        } else {
            this.drawStringInverseVideoAbsolute(0, rows - 1, "^O");
            this.drawStringAbsolute(3, rows - 1, "Save");
            this.drawStringInverseVideoAbsolute(8, rows - 1, "^X");
            this.drawStringAbsolute(11, rows - 1, "Exit");
            this.drawStringInverseVideoAbsolute(16, rows - 1, "^Y");
            this.drawStringAbsolute(19, rows - 1, "Prev");
            this.drawStringInverseVideoAbsolute(24, rows - 1, "^V");
            this.drawStringAbsolute(27, rows - 1, "Next");
            this.drawStringInverseVideoAbsolute(32, rows - 1, "^K");
            this.drawStringAbsolute(35, rows - 1, "Cut");
            this.drawStringInverseVideoAbsolute(39, rows - 1, "^U");
            this.drawStringAbsolute(42, rows - 1, "UnCut");
            --rows;
        }
        if (this.status != null) {
            this.drawStringInverseVideoAbsolute((cols - (this.status.length() + 4)) / 2, --rows, "[ " + this.status + " ]");
        }
        this.totalRows = rows;
        this.totalCols = cols -= 2;
        int cursorRowScrolled = this.cursorRow - this.scrollOffset;
        if (cursorRowScrolled >= rows) {
            ++this.scrollOffset;
        } else if (cursorRowScrolled < 0) {
            --this.scrollOffset;
        }
        if (this.scrollOffset > this.opcodes.size()) {
            this.scrollOffset = this.opcodes.size();
        } else if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        if (this.cursorRow > this.opcodes.size()) {
            this.cursorRow = this.opcodes.size();
        } else if (this.cursorRow < 0) {
            this.cursorRow = 0;
        }
        int oldXOffset = this.xOffset;
        this.xOffset = Integer.toString(this.opcodes.size()).length() + 1;
        if (oldXOffset != this.xOffset) {
            int change = this.xOffset - oldXOffset;
            this.cursorCol += change;
        }
        for (int i2 = 0; i2 < Math.min(this.opcodes.size() - this.scrollOffset, rows); ++i2) {
            String str = Integer.toString(this.scrollOffset + i2 + 1);
            this.drawStringAbsolute(this.xOffset - (str.length() + 1), i2, str);
        }
        if (this.cursorField == 0) {
            if (this.cursorCol <= this.xOffset) {
                this.cursorCol = this.xOffset + 1;
            }
            if (this.cursorCol >= this.xOffset + 4) {
                if (this.cursorRow < this.opcodes.size()) {
                    Opcode oc2 = Opcode.lookup(this.opcodes.get(this.cursorRow));
                    if (oc2 == null || !oc2.getArgumentSpec().isEmpty()) {
                        this.cursorField = 1;
                        this.cursorCol = this.xOffset + 6;
                    } else {
                        this.cursorCol = this.xOffset + 3;
                    }
                } else {
                    this.cursorCol = this.xOffset + 3;
                }
            }
        } else if (this.cursorCol == this.xOffset + 5 || this.cursorRow >= this.arguments.size()) {
            this.cursorField = 0;
            this.cursorCol = this.xOffset + 3;
        } else if (this.cursorRow < this.arguments.size()) {
            List<String> args = this.arguments.get(this.cursorRow);
            int x2 = this.xOffset + 5;
            int i3 = 0;
            for (String s : args) {
                ++x2;
                if (this.cursorCol <= (x2 += s.length())) break;
                ++x2;
                ++i3;
            }
            if (this.cursorField < i3 + 1) {
                ++this.cursorCol;
            }
            this.cursorField = i3 + 1;
            String arg = i3 >= args.size() ? " " : args.get(i3);
            int lim = x2 - arg.length();
            if (this.cursorCol < lim) {
                --this.cursorCol;
            } else if (this.cursorCol > x2 + 1) {
                this.cursorCol = x2 + 1;
            }
        }
        int y = 0;
        for (int idx = 0; idx <= this.opcodes.size(); ++idx) {
            String s = idx >= this.opcodes.size() ? "   " : this.opcodes.get(idx);
            oc = Opcode.lookup(s);
            if (this.cursorRow == y && this.cursorField == 0) {
                for (x = this.xOffset; x < this.xOffset + 5; ++x) {
                    i = x - 1 - this.xOffset;
                    String c = i < 0 ? (oc == null ? (s.startsWith("x") ? "?" : "\u203c") : " ") : (i >= s.length() ? " " : Character.toString(s.charAt(i)));
                    if (x == this.cursorCol) {
                        this.drawString(x, y, c);
                        continue;
                    }
                    this.drawStringInverseVideo(x, y, c);
                }
            } else {
                this.drawString(this.xOffset + 1, y, s);
                if (oc == null && idx < this.opcodes.size()) {
                    this.drawString(this.xOffset, y, s.startsWith("x") ? "?" : "\u203c");
                }
            }
            ++y;
        }
        y = 0;
        for (List<String> li : this.arguments) {
            oc = Opcode.lookup(this.opcodes.get(y));
            x = this.xOffset + 5;
            i = 0;
            for (int idx = 0; idx < (oc == null ? li.size() + 1 : oc.getArgumentSpec().size()); ++idx) {
                String s = idx >= li.size() ? " " : li.get(idx);
                boolean hint = false;
                if (oc != null && idx < oc.getArgumentSpec().size() && s.trim().isEmpty()) {
                    hint = true;
                    s = ((Opcode.ArgumentSpec)((Object)oc.getArgumentSpec().get((int)idx))).hint;
                }
                if (this.cursorRow == y && this.cursorField == i + 1) {
                    if (this.cursorCol == x) {
                        this.drawString(x, y, hint ? "(" : " ");
                    } else {
                        this.drawStringInverseVideo(x, y, hint ? "(" : " ");
                    }
                } else if (hint) {
                    this.drawString(x, y, "(");
                }
                ++x;
                for (int pos = 0; pos < s.length(); ++pos) {
                    if (this.cursorRow == y && this.cursorField == i + 1 && this.cursorCol != x) {
                        this.drawStringInverseVideo(x, y, Character.toString(s.charAt(pos)));
                    } else {
                        this.drawString(x, y, Character.toString(s.charAt(pos)));
                    }
                    ++x;
                }
                if (this.cursorRow == y && this.cursorField == i + 1) {
                    if (this.cursorCol == x) {
                        this.drawString(x, y, hint ? "(" : " ");
                    } else {
                        this.drawStringInverseVideo(x, y, hint ? ")" : " ");
                    }
                } else if (hint) {
                    this.drawString(x, y, ")");
                }
                ++x;
                ++i;
            }
            if (this.cursorRow != y || this.cursorField == li.size()) {
                // empty if block
            }
            ++y;
        }
    }

    private void drawStringInverseVideo(int x, int y, String str) {
        if (y < this.scrollOffset) {
            return;
        }
        if ((y -= this.scrollOffset) >= this.totalRows) {
            return;
        }
        this.drawStringInverseVideoAbsolute(x, y, str);
    }

    private void drawString(int x, int y, String str) {
        if (y < this.scrollOffset) {
            return;
        }
        if ((y -= this.scrollOffset) >= this.totalRows) {
            return;
        }
        this.drawStringAbsolute(x, y, str);
    }

    private void drawStringInverseVideoAbsolute(int x, int y, String str) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x * 4.5f), (float)((float)y * 8.0f), (float)0.0f);
        IBMFontRenderer.drawStringInverseVideo(0, 0, str, CoPo.proxy.getColor("other", 64));
        GlStateManager.func_179121_F();
    }

    private void drawStringAbsolute(int x, int y, String str) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x * 4.5f), (float)((float)y * 8.0f), (float)0.0f);
        IBMFontRenderer.drawString(0, 0, str, CoPo.proxy.getColor("other", 64));
        GlStateManager.func_179121_F();
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        if (this.confirmExit) {
            if (keyCode == 21) {
                this.status = "Saving...";
                this.statusTicks = -1;
                new SaveProgramMessage(this.opcodes, this.arguments).sendToServer();
            } else if (keyCode == 49) {
                this.parent.program = new CommandInterpreter(this.parent);
            } else if (GuiScreen.func_146271_m() && keyCode == 46) {
                this.confirmExit = false;
            }
            return;
        }
        if (keyCode == 200) {
            if (this.cursorRow > 0) {
                --this.cursorRow;
            }
        } else if (keyCode == 208) {
            if (this.cursorRow < this.opcodes.size()) {
                ++this.cursorRow;
                if (this.cursorRow == this.opcodes.size()) {
                    this.cursorCol = this.xOffset + 1;
                    this.cursorField = 0;
                }
            }
        } else if (keyCode == 203) {
            if (this.cursorCol > this.xOffset) {
                --this.cursorCol;
            }
        } else if (keyCode == 205) {
            if (this.cursorCol < this.totalCols) {
                ++this.cursorCol;
            }
        } else if (GuiScreen.func_146271_m()) {
            if (keyCode == 37) {
                if (this.cursorRow < this.opcodes.size()) {
                    this.cutOpcode = this.opcodes.remove(this.cursorRow);
                    this.cutArguments = this.arguments.remove(this.cursorRow);
                }
                this.dirty = true;
            } else if (keyCode == 22) {
                this.opcodes.add(this.cursorRow, this.cutOpcode);
                this.arguments.add(this.cursorRow, this.cutArguments);
                ++this.cursorRow;
                this.dirty = true;
            } else if (keyCode == 45) {
                if (this.dirty) {
                    this.confirmExit = true;
                } else {
                    this.parent.program = new CommandInterpreter(this.parent);
                }
            } else if (keyCode == 47) {
                this.scrollOffset += this.totalRows;
                this.cursorRow += this.totalRows;
            } else if (keyCode == 21) {
                this.scrollOffset -= this.totalRows;
                this.cursorRow -= this.totalRows;
            } else if (keyCode == 24) {
                this.status = "Saving...";
                this.statusTicks = -1;
                new SaveProgramMessage(this.opcodes, this.arguments).sendToServer();
            }
        } else if (this.cursorField == 0) {
            if (Character.isAlphabetic(typedChar) || Character.isDigit(typedChar) || keyCode == 14) {
                if (keyCode == 14) {
                    typedChar = (char)32;
                }
                if (this.cursorRow >= this.opcodes.size()) {
                    char c = this.cursorCol == this.xOffset + 1 && keyCode == 45 ? (char)'x' : Character.toUpperCase(typedChar);
                    this.opcodes.add(Strings.padEnd((String)Strings.padStart((String)Character.toString(c), (int)(this.cursorCol - 1 - this.xOffset), (char)' '), (int)3, (char)' '));
                    this.arguments.add(Lists.newArrayList());
                    ++this.cursorCol;
                    this.dirty = true;
                } else {
                    int pos = this.cursorCol - 1 - this.xOffset;
                    if (pos >= 0 && pos < 3) {
                        StringBuilder str = new StringBuilder(this.opcodes.get(this.cursorRow));
                        char c = pos == 0 && keyCode == 45 ? (char)'x' : Character.toUpperCase(typedChar);
                        str.setCharAt(pos, c);
                        this.opcodes.set(this.cursorRow, str.toString());
                        this.dirty = true;
                    }
                    ++this.cursorCol;
                }
                if (keyCode == 14) {
                    this.cursorCol -= 2;
                }
            }
        } else if ((Character.isAlphabetic(typedChar) || Character.isDigit(typedChar) || keyCode == 14) && this.cursorRow < this.arguments.size() && this.cursorRow < this.opcodes.size()) {
            StringBuilder str;
            List<String> args = this.arguments.get(this.cursorRow);
            Opcode oc = Opcode.lookup(this.opcodes.get(this.cursorRow));
            int x = this.xOffset + 5;
            int i = 0;
            for (String s : args) {
                ++x;
                if (this.cursorCol <= (x += s.length())) break;
                ++x;
                ++i;
            }
            if (i < args.size()) {
                x -= args.get(i).length();
            }
            if (i >= args.size() || args.get(i).isEmpty()) {
                str = new StringBuilder(" ");
                ++x;
            } else {
                str = new StringBuilder(args.get(i));
            }
            int pos = this.cursorCol - x;
            while (str.length() <= pos) {
                str.append(' ');
            }
            if (pos < 0) {
                return;
            }
            if (keyCode == 14) {
                --this.cursorCol;
                if (pos > 0) {
                    --pos;
                }
                str.deleteCharAt(pos);
            } else {
                str.setCharAt(pos, typedChar);
            }
            boolean valid = true;
            if (oc != null) {
                // empty if block
            }
            if (valid) {
                while (i >= args.size()) {
                    args.add("");
                }
                if (i == args.size() - 1 && str.toString().trim().isEmpty()) {
                    args.remove(i);
                } else {
                    args.set(i, str.toString());
                }
                this.dirty = true;
                if (keyCode != 14) {
                    ++this.cursorCol;
                }
            }
        }
    }

    @Override
    public String getName() {
        return "IDE.EXE";
    }

    @Override
    public void update() {
        if (this.statusTicks > -1) {
            ++this.statusTicks;
            if (this.statusTicks > 80) {
                this.status = null;
                this.statusTicks = -1;
            }
        }
    }

    public void setStatus(String line) {
        this.status = line;
        this.statusTicks = 0;
    }
}

