/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.client.gui.shell;

import com.google.common.base.Strings;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.client.IBMFontRenderer;
import io.github.elytra.copo.client.gui.shell.AutomatonProgrammer;
import io.github.elytra.copo.client.gui.shell.GuiTerminalShell;
import io.github.elytra.copo.client.gui.shell.Program;
import io.github.elytra.copo.proxy.ClientProxy;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class CommandInterpreter
extends Program {
    private StringBuilder command = new StringBuilder();
    private Random rand = new Random(System.nanoTime());

    public CommandInterpreter(GuiTerminalShell parent) {
        super(parent);
    }

    @Override
    public String getName() {
        return "COMMAND.COM";
    }

    @Override
    public void render(int rows, int cols) {
        int y = 0;
        for (int i = Math.max(0, this.parent.container.status.size() - (rows - 1)); i < this.parent.container.status.size(); ++i) {
            String line = Strings.nullToEmpty((String)this.parent.container.status.get(i));
            if (line.length() > cols) {
                line = line.substring(0, cols - 3) + "...";
            }
            IBMFontRenderer.drawString(0, y, line, CoPo.proxy.getColor("other", 64));
            y += 8;
        }
        if (this.command.length() > cols - 4) {
            this.command.setLength(cols - 4);
        }
        IBMFontRenderer.drawString(0, y, "J:\\>" + this.command + (ClientProxy.ticks % 20.0f < 10.0f ? "_" : ""), CoPo.proxy.getColor("other", 64));
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        if (keyCode == 1) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent.guiTerminal);
        } else if (keyCode == 28) {
            this.parent.container.status.add("J:\\>" + this.command);
            String cmd = this.command.toString();
            if (cmd.length() == 2 && cmd.endsWith(":")) {
                if (!cmd.equalsIgnoreCase("J:")) {
                    this.parent.container.status.add("Not ready reading drive " + cmd.toUpperCase(Locale.ROOT).charAt(0));
                }
            } else if (!cmd.isEmpty()) {
                String[] split = cmd.split("[ /]", 2);
                String string = split[0].toLowerCase(Locale.ROOT);
                int n = -1;
                switch (string.hashCode()) {
                    case 3198785: {
                        if (!string.equals("help")) break;
                        n = 0;
                        break;
                    }
                    case 3127582: {
                        if (!string.equals("exit")) break;
                        n = 1;
                        break;
                    }
                    case 3107365: {
                        if (!string.equals("echo")) break;
                        n = 2;
                        break;
                    }
                    case 3433459: {
                        if (!string.equals("part")) break;
                        n = 3;
                        break;
                    }
                    case 3151468: {
                        if (!string.equals("free")) break;
                        n = 4;
                        break;
                    }
                    case 1427818632: {
                        if (!string.equals("download")) break;
                        n = 5;
                        break;
                    }
                    case 104106: {
                        if (!string.equals("ide")) break;
                        n = 6;
                        break;
                    }
                    case 51608: {
                        if (!string.equals("437")) break;
                        n = 7;
                    }
                }
                block10 : switch (n) {
                    case 0: {
                        this.parent.container.status.add("help - print this help");
                        this.parent.container.status.add("part - report disk space usage");
                        this.parent.container.status.add("free - display memory usage statistics");
                        this.parent.container.status.add("echo - display a line of text");
                        this.parent.container.status.add("exit - exit the shell");
                        this.parent.container.status.add("ide - write programs for automatons");
                        break;
                    }
                    case 1: {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent.guiTerminal);
                        break;
                    }
                    case 2: {
                        this.parent.container.status.add(split.length >= 2 ? split[1] : "");
                        break;
                    }
                    case 3: {
                        Minecraft.func_71410_x().field_71442_b.func_78756_a(this.parent.container.field_75152_c, -22);
                        break;
                    }
                    case 4: {
                        Minecraft.func_71410_x().field_71442_b.func_78756_a(this.parent.container.field_75152_c, -23);
                        break;
                    }
                    case 5: {
                        if (split.length == 1 || Strings.isNullOrEmpty((String)split[1])) {
                            this.parent.container.status.add("Download what?");
                            break;
                        }
                        String string2 = split[1];
                        int n2 = -1;
                        switch (string2.hashCode()) {
                            case 112670: {
                                if (!string2.equals("ram")) break;
                                n2 = 0;
                                break;
                            }
                            case -220476205: {
                                if (!string2.equals("more ram")) break;
                                n2 = 1;
                            }
                        }
                        switch (n2) {
                            case 0: 
                            case 1: {
                                this.parent.container.status.add("fatal: cannot connect to downloadmoreram.com");
                                this.parent.container.status.add("do you have an internet card?");
                                break block10;
                            }
                        }
                        this.parent.container.status.add("fatal: don't know how to download '" + split[1] + "'");
                        break;
                    }
                    case 6: {
                        this.parent.program = new AutomatonProgrammer(this.parent);
                        break;
                    }
                    case 7: {
                        this.parent.container.status.add("\u0000\u263a\u263b\u2665\u2666\u2663\u2660\u2022\u25d8\u25cb\u25d9\u2642\u2640\u266a\u266b\u263c\u25ba\u25c4\u2195\u203c\u00b6\u00a7\u25ac\u21a8\u2191\u2193\u2192\u2190\u221f\u2194\u25b2\u25bc");
                        this.parent.container.status.add(" !\"#$%&'()*+,-./0123456789:;<=>?");
                        this.parent.container.status.add("@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_");
                        this.parent.container.status.add("`abcdefghijklmnopqrstuvwxyz{|}~\u2302");
                        this.parent.container.status.add("\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00a2\u00a3\u00a5\u20a7\u0192");
                        this.parent.container.status.add("\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u2310\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510");
                        this.parent.container.status.add("\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580");
                        this.parent.container.status.add("\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u03c6\u03b5\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u00a0");
                        break;
                    }
                    default: {
                        this.parent.container.status.add("Bad command or file name");
                    }
                }
            }
            this.command.setLength(0);
        } else if (keyCode == 14) {
            if (this.command.length() >= 1) {
                this.command.setLength(this.command.length() - 1);
            }
        } else if (GuiScreen.func_146271_m()) {
            switch (keyCode) {
                case 46: {
                    this.parent.container.status.add("J:\\>" + this.command + "^C");
                    this.command.setLength(0);
                    break;
                }
                case 32: {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent.guiTerminal);
                }
            }
        } else if (typedChar != '\u0000' && IBMFontRenderer.canRender(typedChar)) {
            this.command.append(typedChar);
        }
    }

    @Override
    public void update() {
        if (this.rand.nextInt() == 5) {
            this.parent.container.status.add("Your free upgrade to Windows 10 is available!");
        }
    }
}

