/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.entity;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.entity.EntityAutomaton$$Lambda$1;
import io.github.elytra.copo.entity.ai.EntityAIAutomatonAttackRangedBow;
import io.github.elytra.copo.entity.ai.EntityAIAutomatonFollowOwner;
import io.github.elytra.copo.entity.ai.EntityAIAutomatonOwnerHurtByTarget;
import io.github.elytra.copo.entity.ai.EntityAIAutomatonOwnerHurtTarget;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.item.ItemModule;
import io.github.elytra.copo.storage.IDigitalStorage;
import io.github.elytra.copo.storage.ITerminal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityAutomaton
extends EntityCreature
implements IEntityOwnable,
ITerminal,
IDigitalStorage {
    private static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(EntityAutomaton.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MUTED = EntityDataManager.func_187226_a(EntityAutomaton.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAutomaton.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(EntityAutomaton.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> FOLLOW_DISTANCE = EntityDataManager.func_187226_a(EntityAutomaton.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Optional<ItemStack>> MODULE1 = EntityDataManager.func_187226_a(EntityAutomaton.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Optional<ItemStack>> MODULE2 = EntityDataManager.func_187226_a(EntityAutomaton.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Optional<ItemStack>> MODULE3 = EntityDataManager.func_187226_a(EntityAutomaton.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Optional<ItemStack>> MODULE4 = EntityDataManager.func_187226_a(EntityAutomaton.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Optional<ItemStack>> MODULE5 = EntityDataManager.func_187226_a(EntityAutomaton.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Optional<ItemStack>> MODULE6 = EntityDataManager.func_187226_a(EntityAutomaton.class, (DataSerializer)DataSerializers.field_187196_f);
    private final TObjectIntMap<UUID> favor = new TObjectIntHashMap();
    private AutomatonStatus aiStatus;
    private EntityEquipmentSlot[] slots = new EntityEquipmentSlot[0];
    private int changeId = 0;

    public EntityAutomaton(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.field_184655_bs[1] = 1.0f;
        this.field_184655_bs[2] = 1.0f;
    }

    private void clearAI() {
        this.clearTaskList(this.field_70714_bg);
        this.clearTaskList(this.field_70715_bh);
    }

    private void clearTaskList(EntityAITasks tasks) {
        for (EntityAITasks.EntityAITaskEntry eate : tasks.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[tasks.field_75782_a.size()])) {
            tasks.func_85156_a(eate.field_75733_a);
        }
    }

    protected void func_184651_r() {
        if (this.func_110143_aJ() >= 1.0f) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            ItemStack mainhand = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
            if (mainhand != null && mainhand.func_77973_b() == Items.field_151031_f) {
                this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIAutomatonAttackRangedBow(this, 0.75, 20, 15.0f));
            } else {
                this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.75, false));
            }
            this.aiStatus = this.getStatus();
            switch (this.getStatus()) {
                case ATTACK: {
                    this.field_70715_bh.func_75776_a(14, (EntityAIBase)new EntityAIAutomatonOwnerHurtByTarget(this));
                    this.field_70715_bh.func_75776_a(12, (EntityAIBase)new EntityAIAutomatonOwnerHurtTarget(this));
                    this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIAutomatonFollowOwner(this, 0.75, (this.getFollowDistance() + 1) * 6, 128.0f));
                    this.field_70138_W = 1.0f;
                    break;
                }
                case EXEC: {
                    break;
                }
                case FOLLOW: {
                    this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAutomatonFollowOwner(this, 0.75, (this.getFollowDistance() + 1) * 4, 32.0f));
                    this.field_70138_W = 1.0f;
                    break;
                }
                case WANDER: {
                    this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
                }
                case STAY: {
                    this.field_70138_W = 0.6f;
                    this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
                    this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityAutomaton.class, 4.0f));
                    break;
                }
            }
        }
    }

    public void attackEntityWithRangedAttack(EntityLivingBase target, float p_82196_2_) {
        EntityTippedArrow entityarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)this.func_184582_a(EntityEquipmentSlot.MAINHAND)) <= 0) {
            ItemStack ammo = this.removeItemsFromNetwork(new ItemStack(Items.field_151032_g), 1, false);
            if (ammo == null) {
                return;
            }
            entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        } else {
            entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
        }
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
        entityarrow.func_70239_b((double)(p_82196_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entityarrow.func_70240_a(j);
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)this) > 0) {
            entityarrow.func_70015_d(100);
        }
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGRY, (Object)false);
        this.field_70180_af.func_187214_a(MUTED, (Object)false);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
        this.field_70180_af.func_187214_a(FOLLOW_DISTANCE, (Object)3);
        this.field_70180_af.func_187214_a(MODULE1, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(MODULE2, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(MODULE3, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(MODULE4, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(MODULE5, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(MODULE6, (Object)Optional.absent());
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.75f * difficulty.func_180170_c());
        this.func_70606_j(this.field_70146_Z.nextFloat() * (this.func_110138_aP() - 4.0f) + 2.0f);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack res = this.addItemToNetwork(itemEntity.func_92059_d());
        if (res == null) {
            itemEntity.func_70106_y();
        } else {
            itemEntity.func_92058_a(res);
        }
    }

    protected float func_70599_aP() {
        return 0.25f;
    }

    public int func_70627_aG() {
        return 160;
    }

    protected SoundEvent func_184639_G() {
        return this.func_110143_aJ() >= 1.0f && !this.isMuted() ? CoPo.automaton_idle : null;
    }

    protected SoundEvent func_184601_bQ() {
        return CoPo.automaton_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void func_70636_d() {
        boolean isAttacking;
        super.func_70636_d();
        CoPo.proxy.smokeTick(this);
        if (this.aiStatus != this.getStatus() && this.field_70714_bg != null) {
            this.clearAI();
            this.func_184651_r();
        }
        boolean bl = isAttacking = this.func_70638_az() != null;
        if (this.isAngry() != isAttacking) {
            this.setAngry(isAttacking);
        }
        if (this.isTamed() && this.func_110143_aJ() < this.func_110138_aP() / 2.0f && this.field_70173_aa % 160 == 0) {
            this.adjustFavor((Entity)this.getOwner(), -1);
        }
        if (this.func_70638_az() instanceof EntityAutomaton && this.func_70638_az().func_110143_aJ() < 1.0f) {
            this.func_70624_b(null);
        }
        if (this.isTamed() && this.func_70638_az() instanceof IEntityOwnable && this.func_184753_b().equals(((IEntityOwnable)this.func_70638_az()).func_184753_b())) {
            this.func_70624_b(null);
        }
        boolean bl2 = this.field_70729_aU = this.func_110143_aJ() < 1.0f;
        if (this.field_70163_u < -64.0) {
            this.func_70106_y();
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.field_70146_Z.nextFloat() < 0.35f * difficulty.func_180170_c()) {
            int tier = this.field_70146_Z.nextInt(2);
            for (int i = 0; i < 3; ++i) {
                if (!(this.field_70146_Z.nextFloat() < 0.095f)) continue;
                ++tier;
            }
            Item i = EntityAutomaton.func_184636_a((EntityEquipmentSlot)EntityEquipmentSlot.HEAD, (int)tier);
            if (i != null) {
                ItemStack stack = new ItemStack(i);
                if (i == Items.field_151024_Q) {
                    Items.field_151024_Q.func_82813_b(stack, this.field_70146_Z.nextInt());
                }
                this.func_184201_a(EntityEquipmentSlot.HEAD, stack);
            }
        }
        boolean has64k = false;
        ArrayList drives = Lists.newArrayList();
        if (this.field_70146_Z.nextInt(8) == 0) {
            ItemStack voidDrive = new ItemStack((Item)CoPo.drive, 1, 4);
            CoPo.drive.setPriority(voidDrive, ItemDrive.Priority.LOW);
            drives.add(voidDrive);
        }
        if (this.field_70146_Z.nextInt(16) == 0) {
            drives.add(new ItemStack((Item)CoPo.drive, 1, 3));
            has64k = true;
        }
        if (drives.size() < 2 && this.field_70146_Z.nextInt(4) == 0) {
            int tier = this.field_70146_Z.nextInt(2);
            if (this.field_70146_Z.nextFloat() < 0.15f) {
                ++tier;
            }
            drives.add(new ItemStack((Item)CoPo.drive, 1, tier));
        }
        if (drives.size() >= 1) {
            this.func_184201_a(EntityEquipmentSlot.LEGS, (ItemStack)drives.get(0));
        }
        if (drives.size() == 2) {
            this.func_184201_a(EntityEquipmentSlot.CHEST, (ItemStack)drives.get(1));
        }
        if (this.getKilobitsStorageFree() > 0 && this.field_70146_Z.nextFloat() < 0.8f * difficulty.func_180170_c()) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
            this.addItemToNetwork(new ItemStack(Items.field_151032_g, this.field_70146_Z.nextInt(192) + 1));
        } else if (this.field_70146_Z.nextFloat() < 0.25f * difficulty.func_180170_c()) {
            int weapon = this.field_70146_Z.nextInt(4);
            switch (weapon) {
                case 0: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
                    break;
                }
                case 1: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151035_b));
                    break;
                }
                case 2: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151018_J));
                    break;
                }
                case 3: {
                    int color = this.field_70146_Z.nextInt(16);
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_179564_cE, 1, color));
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_179564_cE, 1, color));
                }
            }
        }
        if (has64k) {
            this.addItemToNetwork(new ItemStack(Blocks.field_150347_e, this.field_70146_Z.nextInt(6400) + 256));
            this.addItemToNetwork(new ItemStack(Items.field_151044_h, this.field_70146_Z.nextInt(128)));
            this.addItemToNetwork(new ItemStack(Blocks.field_150366_p, this.field_70146_Z.nextInt(96)));
            this.addItemToNetwork(new ItemStack(Blocks.field_150352_o, this.field_70146_Z.nextInt(32)));
            if (this.field_70146_Z.nextInt(24) == 0) {
                this.addItemToNetwork(new ItemStack(Items.field_151045_i, this.field_70146_Z.nextInt(12) + 2));
            }
            if (this.field_70146_Z.nextInt(12) == 0) {
                this.addItemToNetwork(new ItemStack(Items.field_151100_aR, this.field_70146_Z.nextInt(48) + 24, EnumDyeColor.BLUE.func_176767_b()));
            }
        }
        if (this.getKilobitsStorageFree() > 0) {
            block12: for (int i = 0; i < this.field_70146_Z.nextInt(64); ++i) {
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        this.addItemToNetwork(new ItemStack((Item)CoPo.recordItems.get(this.field_70146_Z.nextInt(CoPo.recordItems.size()))));
                        continue block12;
                    }
                    case 1: {
                        this.addItemToNetwork(new ItemStack(Items.field_151106_aX, this.field_70146_Z.nextInt(24) + 1));
                        continue block12;
                    }
                    case 2: {
                        this.addItemToNetwork(new ItemStack((Item)CoPo.misc, this.field_70146_Z.nextInt(18) + 1, 3));
                    }
                }
            }
        }
    }

    public AutomatonStatus getStatus() {
        return AutomatonStatus.VALUES[(Byte)this.field_70180_af.func_187225_a(STATUS) % AutomatonStatus.VALUES.length];
    }

    public void setStatus(AutomatonStatus status) {
        this.field_70180_af.func_187227_b(STATUS, (Object)((byte)status.ordinal()));
        if (this.field_70714_bg != null) {
            this.clearAI();
            this.func_184651_r();
        }
    }

    public void setMuted(boolean muted) {
        this.field_70180_af.func_187227_b(MUTED, (Object)muted);
    }

    public boolean isMuted() {
        return this.hasModule("speech") || (Boolean)this.field_70180_af.func_187225_a(MUTED) != false;
    }

    public boolean hasModule(String module) {
        for (ItemStack is : this.getModules()) {
            if (is == null || !(is.func_77973_b() instanceof ItemModule) || !module.equals(((ItemModule)is.func_77973_b()).getType(is))) continue;
            return true;
        }
        return false;
    }

    public ItemStack getModule(int slot) {
        if (slot < 0 || slot >= 6) {
            throw new IndexOutOfBoundsException(slot + " not within 0-5");
        }
        switch (slot) {
            case 0: {
                return (ItemStack)((Optional)this.field_70180_af.func_187225_a(MODULE1)).orNull();
            }
            case 1: {
                return (ItemStack)((Optional)this.field_70180_af.func_187225_a(MODULE2)).orNull();
            }
            case 2: {
                return (ItemStack)((Optional)this.field_70180_af.func_187225_a(MODULE3)).orNull();
            }
            case 3: {
                return (ItemStack)((Optional)this.field_70180_af.func_187225_a(MODULE4)).orNull();
            }
            case 4: {
                return (ItemStack)((Optional)this.field_70180_af.func_187225_a(MODULE5)).orNull();
            }
            case 5: {
                return (ItemStack)((Optional)this.field_70180_af.func_187225_a(MODULE6)).orNull();
            }
        }
        return null;
    }

    public void setModule(int slot, ItemStack stack) {
        if (slot < 0 || slot >= 6) {
            throw new IndexOutOfBoundsException(slot + " not within 0-5");
        }
        switch (slot) {
            case 0: {
                this.field_70180_af.func_187227_b(MODULE1, (Object)Optional.fromNullable((Object)stack));
                break;
            }
            case 1: {
                this.field_70180_af.func_187227_b(MODULE2, (Object)Optional.fromNullable((Object)stack));
                break;
            }
            case 2: {
                this.field_70180_af.func_187227_b(MODULE3, (Object)Optional.fromNullable((Object)stack));
                break;
            }
            case 3: {
                this.field_70180_af.func_187227_b(MODULE4, (Object)Optional.fromNullable((Object)stack));
                break;
            }
            case 4: {
                this.field_70180_af.func_187227_b(MODULE5, (Object)Optional.fromNullable((Object)stack));
                break;
            }
            case 5: {
                this.field_70180_af.func_187227_b(MODULE6, (Object)Optional.fromNullable((Object)stack));
            }
        }
    }

    public Iterable<ItemStack> getModules() {
        return new AbstractList<ItemStack>(){

            @Override
            public ItemStack get(int index) {
                return EntityAutomaton.this.getModule(index);
            }

            @Override
            public int size() {
                return 6;
            }
        };
    }

    public void setFollowDistance(int distance) {
        this.field_70180_af.func_187227_b(FOLLOW_DISTANCE, (Object)((byte)distance));
        if (this.field_70714_bg != null) {
            this.clearAI();
            this.func_184651_r();
        }
    }

    public int getFollowDistance() {
        return ((Byte)this.field_70180_af.func_187225_a(FOLLOW_DISTANCE)).intValue();
    }

    public int func_82143_as() {
        return 512;
    }

    public void func_70604_c(EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (!this.isOwner(livingBase)) {
            this.func_70624_b(livingBase);
            for (EntityAutomaton friend : this.field_70170_p.func_72872_a(EntityAutomaton.class, this.func_174813_aQ().func_186662_g(12.0))) {
                if (friend == this) continue;
                friend.adjustFavor((Entity)livingBase, -1);
            }
        } else {
            this.adjustFavor((Entity)livingBase, -1);
        }
    }

    public int adjustFavor(Entity ent, int i) {
        if (ent instanceof EntityPlayer) {
            UUID id = ((EntityPlayer)ent).func_146103_bH().getId();
            if (i == 0) {
                return this.favor.get((Object)id);
            }
            int f = this.favor.adjustOrPutValue((Object)id, i, i);
            boolean tamed = false;
            if (f >= 16 && this.func_184753_b() == null) {
                this.setOwnerId(id);
                this.setStatus(AutomatonStatus.FOLLOW);
                tamed = true;
            }
            if (this.field_70170_p instanceof WorldServer) {
                EnumParticleTypes particle = tamed ? EnumParticleTypes.HEART : (i < 0 ? EnumParticleTypes.VILLAGER_ANGRY : EnumParticleTypes.VILLAGER_HAPPY);
                ((WorldServer)this.field_70170_p).func_175739_a(particle, this.field_70165_t, this.field_70163_u, this.field_70161_v, 4, 0.25, 0.25, 0.25, 0.0, new int[0]);
            }
            return f;
        }
        return 0;
    }

    public int getFavor(Entity ent) {
        return this.adjustFavor(ent, 0);
    }

    public void func_70606_j(float health) {
        super.func_70606_j(health);
        if (this.field_70714_bg != null && this.field_70714_bg.field_75782_a.isEmpty()) {
            this.clearAI();
            this.func_184651_r();
        }
    }

    public int func_70658_aO() {
        return super.func_70658_aO() + 6;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.func_70653_a(entityIn, strength * 2.0f, xRatio, zRatio);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.field_70128_L = false;
        this.func_70606_j(0.1f);
        if (this.field_70714_bg != null) {
            this.clearAI();
            this.func_184651_r();
        }
        if (cause instanceof EntityDamageSource) {
            for (EntityAutomaton friend : this.field_70170_p.func_72872_a(EntityAutomaton.class, this.func_174813_aQ().func_186662_g(12.0))) {
                friend.adjustFavor(cause.func_76346_g(), -4);
            }
        }
    }

    protected void func_70665_d(DamageSource cause, float damageAmount) {
        super.func_70665_d(cause, damageAmount);
        if (cause instanceof EntityDamageSource) {
            for (EntityAutomaton friend : this.field_70170_p.func_72872_a(EntityAutomaton.class, this.func_174813_aQ().func_186662_g(12.0))) {
                friend.adjustFavor(cause.func_76346_g(), (int)(-(damageAmount * 5.0f)));
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (stack != null && stack.func_77973_b() == CoPo.weldthrower) {
            return false;
        }
        if (stack != null && stack.func_77973_b() == CoPo.misc && stack.func_77960_j() == 5) {
            if (!this.field_70170_p.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                this.adjustFavor((Entity)player, 1);
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_110143_aJ() < 1.0f) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.automaton_dead", new Object[0]));
            } else if (!this.isOwner((EntityLivingBase)player)) {
                if (this.func_184753_b() == null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.automaton_untamed", new Object[0]));
                } else if (this.isAngry()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.automaton_angry", new Object[0]));
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.automaton_not_yours", new Object[0]));
                }
            } else if (player.func_70093_af()) {
                EntityEquipmentSlot slot;
                if (this.func_184582_a(EntityEquipmentSlot.CHEST) != null) {
                    slot = EntityEquipmentSlot.CHEST;
                } else if (this.func_184582_a(EntityEquipmentSlot.LEGS) != null) {
                    slot = EntityEquipmentSlot.LEGS;
                } else {
                    slot = null;
                    player.openGui((Object)CoPo.inst, 4, this.field_70170_p, this.func_145782_y(), 0, 0);
                }
                if (slot != null) {
                    this.func_70099_a(this.func_184582_a(slot), 0.2f);
                    this.func_184201_a(slot, null);
                }
            } else if (stack != null && stack.func_77973_b() instanceof ItemDrive) {
                EntityEquipmentSlot slot;
                if (this.func_184582_a(EntityEquipmentSlot.LEGS) == null) {
                    slot = EntityEquipmentSlot.LEGS;
                } else if (this.func_184582_a(EntityEquipmentSlot.CHEST) == null) {
                    slot = EntityEquipmentSlot.CHEST;
                } else {
                    slot = null;
                    player.openGui((Object)CoPo.inst, 4, this.field_70170_p, this.func_145782_y(), 0, 0);
                }
                if (slot != null) {
                    this.func_184201_a(slot, stack.func_77979_a(1));
                }
            } else {
                player.openGui((Object)CoPo.inst, 4, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
        }
        return true;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (slotIn == EntityEquipmentSlot.LEGS || slotIn == EntityEquipmentSlot.CHEST) {
            this.updateSlotOrder();
        } else {
            this.func_184606_a_(stack);
            if (slotIn == EntityEquipmentSlot.MAINHAND && this.field_70714_bg != null) {
                this.clearAI();
                this.func_184651_r();
            }
        }
    }

    private void updateSlotOrder() {
        boolean hasChest;
        ItemStack legs = this.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack chest = this.func_184582_a(EntityEquipmentSlot.CHEST);
        boolean hasLegs = legs != null;
        boolean bl = hasChest = chest != null;
        this.slots = !hasLegs && !hasChest ? new EntityEquipmentSlot[0] : (!hasLegs && hasChest ? new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST} : (hasLegs && !hasChest ? new EntityEquipmentSlot[]{EntityEquipmentSlot.LEGS} : (this.getPriority(chest) > this.getPriority(legs) ? new EntityEquipmentSlot[]{EntityEquipmentSlot.LEGS, EntityEquipmentSlot.CHEST} : new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS})));
    }

    private int getPriority(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemDrive) {
            return ((ItemDrive)stack.func_77973_b()).getPriority(stack).ordinal();
        }
        return ItemDrive.Priority.DEFAULT.ordinal();
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.func_76347_k()) {
            return true;
        }
        if (source == DamageSource.field_76379_h) {
            return true;
        }
        return this.func_110143_aJ() < 1.0f || super.func_180431_b(source);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    public boolean isAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.field_70180_af.func_187227_b(ANGRY, (Object)angry);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.func_184753_b() != null) {
            compound.func_186854_a("Owner", this.func_184753_b());
        }
        compound.func_74757_a("Angry", this.isAngry());
        compound.func_74774_a("Status", ((Byte)this.field_70180_af.func_187225_a(STATUS)).byteValue());
        compound.func_74757_a("Muted", this.isMuted());
        compound.func_74774_a("FollowDistance", ((Byte)this.field_70180_af.func_187225_a(FOLLOW_DISTANCE)).byteValue());
        NBTTagList li = new NBTTagList();
        this.favor.forEachEntry(EntityAutomaton$$Lambda$1.lambdaFactory$(li));
        compound.func_74782_a("Favor", (NBTBase)li);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("Owner")) {
            this.setOwnerId(compound.func_186857_a("Owner"));
        } else {
            this.setOwnerId(null);
        }
        this.setAngry(compound.func_74767_n("Angry"));
        this.field_70180_af.func_187227_b(STATUS, (Object)compound.func_74771_c("Status"));
        this.setMuted(compound.func_74767_n("Muted"));
        this.setFollowDistance(compound.func_74762_e("FollowDistance"));
        this.favor.clear();
        NBTTagList li = compound.func_150295_c("Favor", 10);
        for (int i = 0; i < li.func_74745_c(); ++i) {
            NBTTagCompound tag = li.func_150305_b(i);
            this.favor.put((Object)tag.func_186857_a("Key"), tag.func_74762_e("Value"));
        }
        this.updateSlotOrder();
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)uuid));
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.func_184753_b();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwner();
    }

    public boolean isTamed() {
        return this.func_184753_b() != null;
    }

    @Override
    public int getChangeId() {
        return this.changeId;
    }

    @Override
    public List<ItemStack> getTypes() {
        ArrayList li = Lists.newArrayList();
        for (EntityEquipmentSlot slot : this.slots) {
            ItemStack drive;
            if (this.func_184582_a(slot) == null || !((drive = this.func_184582_a(slot)).func_77973_b() instanceof ItemDrive)) continue;
            ItemDrive itemDrive = (ItemDrive)drive.func_77973_b();
            li.addAll(itemDrive.getTypes(drive));
        }
        return li;
    }

    @Override
    public int getKilobitsStorageFree() {
        int accum = 0;
        for (EntityEquipmentSlot slot : this.slots) {
            ItemStack drive;
            if (this.func_184582_a(slot) == null || !((drive = this.func_184582_a(slot)).func_77973_b() instanceof ItemDrive)) continue;
            accum += ((ItemDrive)drive.func_77973_b()).getKilobitsFree(drive);
        }
        return accum;
    }

    @Override
    public ItemStack addItemToNetwork(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (EntityEquipmentSlot slot : this.slots) {
            ItemStack drive;
            if (this.func_184582_a(slot) == null || !((drive = this.func_184582_a(slot)).func_77973_b() instanceof ItemDrive)) continue;
            ItemDrive itemDrive = (ItemDrive)drive.func_77973_b();
            itemDrive.addItem(drive, stack);
            if (stack.field_77994_a <= 0) break;
        }
        ++this.changeId;
        return stack.field_77994_a <= 0 ? null : stack;
    }

    @Override
    public ItemStack removeItemsFromNetwork(ItemStack prototype, int amount, boolean b) {
        if (prototype == null) {
            return null;
        }
        ItemStack stack = prototype.func_77946_l();
        stack.field_77994_a = 0;
        for (EntityEquipmentSlot slot : this.slots) {
            ItemStack drive;
            if (this.func_184582_a(slot) == null || !((drive = this.func_184582_a(slot)).func_77973_b() instanceof ItemDrive)) continue;
            ItemDrive itemDrive = (ItemDrive)drive.func_77973_b();
            int amountWanted = amount - stack.field_77994_a;
            itemDrive.removeItems(drive, stack, amountWanted);
            if (stack.field_77994_a >= amount) break;
        }
        ++this.changeId;
        return stack.field_77994_a <= 0 ? null : stack;
    }

    @Override
    public boolean isPowered() {
        return this.func_110143_aJ() >= 1.0f;
    }

    @Override
    public ITerminal.UserPreferences getPreferences(EntityPlayer player) {
        return new ITerminal.UserPreferences();
    }

    @Override
    public IDigitalStorage getStorage() {
        return this;
    }

    @Override
    public boolean hasStorage() {
        return true;
    }

    @Override
    public boolean supportsDumpSlot() {
        return false;
    }

    @Override
    public IInventory getDumpSlotInventory() {
        return null;
    }

    @Override
    public boolean canContinueInteracting(EntityPlayer player) {
        return player.func_70068_e((Entity)this) < 64.0;
    }

    @Override
    public void markUnderlyingStorageDirty() {
    }

    private static /* synthetic */ boolean lambda$writeEntityToNBT$0(NBTTagList li, UUID id, int f) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a("Key", id);
        tag.func_74768_a("Value", f);
        li.func_74742_a((NBTBase)tag);
        return true;
    }

    static /* synthetic */ boolean access$lambda$0(NBTTagList nBTTagList, UUID uUID, int n) {
        return EntityAutomaton.lambda$writeEntityToNBT$0(nBTTagList, uUID, n);
    }

    public static enum AutomatonStatus {
        WANDER,
        ATTACK,
        FOLLOW,
        STAY,
        EXEC;

        public static final AutomatonStatus[] VALUES;
        public final ResourceLocation texture = new ResourceLocation("correlatedpotentialistics", "textures/entity/automaton_status_" + this.name().toLowerCase(Locale.ROOT) + ".png");

        static {
            VALUES = AutomatonStatus.values();
        }
    }
}

