/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.entity.automaton;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.github.elytra.copo.entity.EntityAutomaton;
import io.github.elytra.copo.entity.automaton.Opcode$ArgumentSpec$$Lambda$1;
import io.github.elytra.copo.entity.automaton.Opcode$ArgumentSpec$$Lambda$2;
import io.github.elytra.copo.entity.automaton.Opcode$ArgumentSpec$$Lambda$3;
import io.github.elytra.copo.entity.automaton.Opcode$ArgumentSpec$$Lambda$4;
import io.github.elytra.copo.entity.automaton.Opcode$ArgumentSpec$$Lambda$5;
import io.github.elytra.copo.entity.automaton.OpcodeHLT;
import io.github.elytra.copo.entity.automaton.OpcodeNOP;
import io.github.elytra.copo.entity.automaton.OpcodeTST;
import io.github.elytra.copo.function.BiConsumer;
import io.github.elytra.copo.function.IntFunction;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.Map;

public abstract class Opcode {
    private static final Map<Integer, Opcode> byBytecode = Maps.newHashMap();
    private static final Map<String, Opcode> byMnemonic = Maps.newHashMap();
    protected final String mnemonic;
    protected final int bytecode;
    protected final ImmutableList<ArgumentSpec> args;
    protected final int techLevel;

    public static Opcode byBytecode(int bytecode) {
        if (bytecode < 0 || bytecode > 255) {
            return null;
        }
        return byBytecode.get(bytecode);
    }

    public static Opcode byMnemonic(String mnemonic) {
        return byMnemonic.get(mnemonic);
    }

    public static Opcode lookup(String str) {
        if (str.charAt(0) == 'x') {
            try {
                int i = Integer.parseInt(str.substring(1), 16);
                return Opcode.byBytecode(i);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return Opcode.byMnemonic(str.toUpperCase(Locale.ROOT));
    }

    protected static void register(Opcode oc) {
        byBytecode.put(oc.getBytecode(), oc);
        byMnemonic.put(oc.getMnemonic(), oc);
    }

    public Opcode(String mnemonic, int bytecode, int techLevel, ArgumentSpec ... args) {
        if (mnemonic == null || mnemonic.length() > 3) {
            throw new IllegalArgumentException("Mnemonics must be less than or equal to 3 chars long");
        }
        if (bytecode < 0 || bytecode > 255) {
            throw new IllegalArgumentException("Bytecodes must fit in an unsigned byte");
        }
        if (techLevel < -1) {
            throw new IllegalArgumentException("Tech level must be >= -1");
        }
        this.mnemonic = mnemonic;
        this.bytecode = bytecode;
        this.techLevel = techLevel;
        this.args = ImmutableList.copyOf((Object[])args);
    }

    public final String getMnemonic() {
        return this.mnemonic;
    }

    public final int getTechLevel() {
        return this.techLevel;
    }

    public final int getBytecode() {
        return this.bytecode;
    }

    public final ImmutableList<ArgumentSpec> getArgumentSpec() {
        return this.args;
    }

    public abstract void execute(EntityAutomaton var1, ByteBuf var2);

    public static void init() {
        Opcode.register(new OpcodeNOP());
        Opcode.register(new OpcodeTST());
        Opcode.register(new OpcodeHLT());
    }

    public static enum ArgumentSpec {
        INTEGER('I', Opcode$ArgumentSpec$$Lambda$2.lambdaFactory$(), Opcode$ArgumentSpec$$Lambda$3.lambdaFactory$(), 4),
        POINTER('\u2191', Opcode$ArgumentSpec$$Lambda$4.lambdaFactory$(), Opcode$ArgumentSpec$$Lambda$5.lambdaFactory$(), 4);

        public final String hint;
        public final Function<String, ?> parser;
        public final BiConsumer<ByteBuf, Object> writer;
        public final IntFunction<Object> sizer;

        private <T> ArgumentSpec(char hint, Function<String, T> parser, BiConsumer<ByteBuf, T> writer, int size) {
            this(hint, parser, writer, Opcode$ArgumentSpec$$Lambda$1.lambdaFactory$(size));
        }

        private <T> ArgumentSpec(char hint, Function<String, T> parser, BiConsumer<ByteBuf, T> writer, IntFunction<T> sizer) {
            this.hint = Character.toString(hint);
            this.parser = parser;
            this.writer = writer;
            this.sizer = sizer;
        }

        static /* synthetic */ int access$lambda$0(int n, Object object) {
            return n;
        }
    }
}

