/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.inventory;

import io.github.elytra.copo.entity.EntityAutomaton;
import io.github.elytra.copo.inventory.ContainerTerminal;
import io.github.elytra.copo.inventory.SlotAutomatonModule;
import io.github.elytra.copo.inventory.SlotEquipment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;

public class ContainerAutomaton
extends ContainerTerminal {
    public EntityAutomaton automaton;
    public EntityPlayer player;

    public ContainerAutomaton(IInventory playerInventory, EntityPlayer player, EntityAutomaton automaton) {
        super(playerInventory, player, automaton);
        this.automaton = automaton;
        this.player = player;
        this.func_75146_a(new SlotEquipment((EntityLivingBase)automaton, EntityEquipmentSlot.MAINHAND, 28, 25));
        this.func_75146_a(new SlotEquipment((EntityLivingBase)automaton, EntityEquipmentSlot.OFFHAND, 28, 43));
        this.func_75146_a(new SlotEquipment((EntityLivingBase)automaton, EntityEquipmentSlot.HEAD, 28, 7));
        for (int i = 0; i < 6; ++i) {
            this.func_75146_a(new SlotAutomatonModule(automaton, i, 6, 7 + i * 18));
        }
    }

    @Override
    protected void initializeTerminalSize() {
        this.startX = 28;
        this.startY = 44;
        this.slotsAcross = 8;
        this.slotsTall = 4;
        this.hasCraftingMatrix = false;
        this.playerInventoryOffsetX = 0;
        this.playerInventoryOffsetY = -7;
    }

    @Override
    public boolean func_75140_a(EntityPlayer playerIn, int id) {
        switch (id) {
            case -30: {
                this.automaton.setStatus(EntityAutomaton.AutomatonStatus.WANDER);
                break;
            }
            case -31: {
                this.automaton.setStatus(EntityAutomaton.AutomatonStatus.ATTACK);
                break;
            }
            case -32: {
                this.automaton.setStatus(EntityAutomaton.AutomatonStatus.FOLLOW);
                break;
            }
            case -33: {
                this.automaton.setStatus(EntityAutomaton.AutomatonStatus.STAY);
                break;
            }
            case -34: {
                this.automaton.setStatus(EntityAutomaton.AutomatonStatus.EXEC);
                break;
            }
            case -59: {
                this.automaton.setFollowDistance((this.automaton.getFollowDistance() + 1) % 4);
                break;
            }
            case -60: {
                this.automaton.setMuted(!this.automaton.isMuted());
                break;
            }
            default: {
                return super.func_75140_a(playerIn, id);
            }
        }
        return true;
    }
}

