/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.inventory;

import io.github.elytra.copo.inventory.SlotStatic;
import io.github.elytra.copo.item.ItemDrive;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerDrive
extends Container {
    private final int driveSlotId;
    public final Slot driveSlot;
    private final EntityPlayer player;
    private List<ItemStack> prototypes;

    public ContainerDrive(IInventory playerInventory, int driveSlotId, EntityPlayer player) {
        int i;
        this.driveSlotId = driveSlotId;
        ItemStack drive = playerInventory.func_70301_a(driveSlotId);
        this.player = player;
        this.driveSlot = new SlotStatic(0, -8000, -8000, drive);
        this.func_75146_a(this.driveSlot);
        for (int i2 = 0; i2 < 64; ++i2) {
            SlotFake slot = new SlotFake(i2, i2 % 11 * 18 + 8 + (i2 > 54 ? 18 : 0), i2 / 11 * 18 + 18);
            this.func_75146_a(slot);
        }
        this.updateSlots();
        int x = 26;
        int y = 37;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(playerInventory, j + i * 9 + 8, x + j * 18, 103 + i * 18 + y));
            }
        }
        for (i = 0; i < 9; ++i) {
            Slot slot = i == driveSlotId ? new Slot(playerInventory, i, x + i * 18, 161 + y){

                public boolean func_82869_a(EntityPlayer playerIn) {
                    return false;
                }
            } : new Slot(playerInventory, i, x + i * 18, 161 + y);
            this.func_75146_a(slot);
        }
    }

    public void updateSlots() {
        this.prototypes = this.getItemDrive().getPrototypes(this.getDrive());
        for (int i = 1; i < 65; ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof SlotFake)) continue;
            if (slot.getSlotIndex() < this.prototypes.size()) {
                ItemStack stack = this.prototypes.get(slot.getSlotIndex());
                stack.field_77994_a = 1;
                slot.func_75215_d(stack);
                continue;
            }
            slot.func_75215_d(null);
        }
    }

    public boolean func_75140_a(EntityPlayer playerIn, int id) {
        if (id == 0 || id == 1) {
            ItemDrive.Priority[] values = ItemDrive.Priority.values();
            ItemDrive.Priority cur = this.getItemDrive().getPriority(this.getDrive());
            int idx = (cur.ordinal() + (id == 0 ? -1 : 1)) % values.length;
            if (idx < 0) {
                idx = values.length + idx;
            }
            ItemDrive.Priority nxt = values[idx];
            this.getItemDrive().setPriority(this.getDrive(), nxt);
        } else if (id == 2) {
            ItemDrive.PartitioningMode[] values = ItemDrive.PartitioningMode.values();
            ItemDrive.PartitioningMode cur = this.getItemDrive().getPartitioningMode(this.getDrive());
            int idx = (cur.ordinal() + 1) % values.length;
            ItemDrive.PartitioningMode nxt = values[idx];
            this.getItemDrive().setPartitioningMode(this.getDrive(), nxt);
        }
        this.player.field_71071_by.func_70299_a(this.driveSlotId, this.getDrive());
        return true;
    }

    public void func_75137_b(int id, int data) {
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 1) {
            Slot slot = this.func_75139_a(slotId);
            if (slot instanceof SlotFake) {
                if (clickTypeIn == ClickType.PICKUP) {
                    if (slot.func_75216_d()) {
                        int stored = this.getItemDrive().getAmountStored(this.getDrive(), slot.func_75211_c());
                        if (stored <= 0) {
                            this.getItemDrive().deallocateType(this.getDrive(), slot.func_75211_c());
                            this.updateSlots();
                            player.field_71071_by.func_70299_a(this.driveSlotId, this.getDrive());
                        }
                        return null;
                    }
                    ItemStack cursor = player.field_71071_by.func_70445_o();
                    if (this.getItemDrive().getPartitioningMode(this.getDrive()) == ItemDrive.PartitioningMode.NONE) {
                        return cursor;
                    }
                    if (cursor != null && slot.func_75214_a(cursor)) {
                        this.getItemDrive().allocateType(this.getDrive(), cursor, 0);
                        this.updateSlots();
                        player.field_71071_by.func_70299_a(this.driveSlotId, this.getDrive());
                    }
                    return cursor;
                }
            } else if (clickTypeIn == ClickType.QUICK_MOVE) {
                ItemStack stack = slot.func_75211_c();
                if (this.getItemDrive().getPartitioningMode(this.getDrive()) == ItemDrive.PartitioningMode.NONE) {
                    return stack;
                }
                if (this.func_75139_a(1).func_75214_a(stack)) {
                    this.getItemDrive().allocateType(this.getDrive(), stack, 0);
                    this.updateSlots();
                    player.field_71071_by.func_70299_a(this.driveSlotId, this.getDrive());
                }
                return stack;
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack getDrive() {
        return this.driveSlot.func_75211_c();
    }

    public ItemDrive getItemDrive() {
        return (ItemDrive)this.getDrive().func_77973_b();
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return playerIn == this.player;
    }

    public class SlotFake
    extends Slot {
        private ItemStack stack;

        public SlotFake(int index, int xPosition, int yPosition) {
            super(null, index, xPosition, yPosition);
        }

        public ItemStack func_75211_c() {
            return this.stack;
        }

        public void func_75215_d(ItemStack stack) {
            this.stack = stack;
            this.func_75218_e();
        }

        public ItemStack func_75209_a(int amount) {
            if (this.stack == null) {
                return null;
            }
            ItemStack split = this.stack.func_77979_a(amount);
            if (this.stack.field_77994_a <= 0) {
                this.stack = null;
            }
            this.func_75218_e();
            return split;
        }

        public int func_178170_b(ItemStack stack) {
            return 1;
        }

        public boolean func_75217_a(IInventory inv, int slotIn) {
            return false;
        }

        public boolean func_111238_b() {
            return true;
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return false;
        }

        public boolean func_75214_a(ItemStack stack) {
            for (ItemStack s : ContainerDrive.this.prototypes) {
                if (!ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)s, (ItemStack)stack)) continue;
                return false;
            }
            return ContainerDrive.this.getItemDrive().getKilobitsFree(ContainerDrive.this.getDrive()) >= ContainerDrive.this.getItemDrive().getTypeAllocationKilobits(ContainerDrive.this.getDrive(), stack.serializeNBT());
        }

        public void func_75218_e() {
            ContainerDrive.this.getItemDrive().markDirty(ContainerDrive.this.getDrive());
            ((ContainerDrive)ContainerDrive.this).player.field_71071_by.func_70299_a(ContainerDrive.this.driveSlotId, ContainerDrive.this.getDrive());
        }
    }
}

