/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.inventory;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Ints;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.helper.Numbers;
import io.github.elytra.copo.inventory.ContainerTerminal$$Lambda$1;
import io.github.elytra.copo.inventory.ContainerTerminal$CraftingAmount$$Lambda$1;
import io.github.elytra.copo.inventory.ContainerTerminal$CraftingAmount$$Lambda$3;
import io.github.elytra.copo.inventory.ContainerTerminal$CraftingAmount$$Lambda$4;
import io.github.elytra.copo.inventory.ContainerTerminal$SortMode$$Lambda$1;
import io.github.elytra.copo.inventory.ContainerTerminal$SortMode$$Lambda$2;
import io.github.elytra.copo.inventory.ContainerTerminal$SortMode$$Lambda$3;
import io.github.elytra.copo.inventory.ContainerTerminal$SortMode$$Lambda$4;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.network.AddStatusLineMessage;
import io.github.elytra.copo.network.SetSearchQueryClientMessage;
import io.github.elytra.copo.network.SetSlotSizeMessage;
import io.github.elytra.copo.storage.ITerminal;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityTerminal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ContainerTerminal
extends Container {
    public ITerminal terminal;
    private World world;
    private EntityPlayer player;
    private int scrollOffset;
    private String searchQuery = "";
    public int rows;
    public SortMode sortMode = SortMode.QUANTITY;
    public boolean sortAscending = false;
    public CraftingAmount craftingAmount = CraftingAmount.ONE;
    public CraftingTarget craftingTarget = CraftingTarget.INVENTORY;
    private int lastChangeId;
    public InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 3, 3);
    public InventoryCraftResult craftResult = new InventoryCraftResult();
    public int slotsAcross;
    public int slotsTall;
    public int startX;
    public int startY;
    public int playerInventoryOffsetX;
    public int playerInventoryOffsetY;
    public boolean hasCraftingMatrix = true;
    public Slot floppySlot;
    private List<Integer> oldStackSizes = Lists.newArrayList();
    public List<String> status = Lists.newArrayList();

    public ContainerTerminal(IInventory playerInventory, EntityPlayer player, ITerminal terminal) {
        int j;
        int i;
        this.player = player;
        this.world = player.field_70170_p;
        this.terminal = terminal;
        this.initializeTerminalSize();
        int x = this.startX;
        int y = this.startY;
        if (!player.field_70170_p.field_72995_K) {
            ITerminal.UserPreferences prefs = terminal.getPreferences(player);
            this.sortMode = prefs.sortMode;
            this.sortAscending = prefs.sortAscending;
            this.searchQuery = prefs.lastSearchQuery;
            this.craftingTarget = prefs.craftingTarget;
        }
        if (terminal.supportsDumpSlot()) {
            this.func_75146_a(new Slot(terminal.getDumpSlotInventory(), 0, 25, 161));
        }
        if (terminal instanceof TileEntityTerminal) {
            TileEntityTerminal te = (TileEntityTerminal)terminal;
            this.floppySlot = new Slot(te, 1, -8000, -8000){

                public boolean func_111238_b() {
                    return false;
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    return false;
                }
            };
            this.func_75146_a(this.floppySlot);
        }
        for (i = 0; i < this.slotsTall; ++i) {
            for (j = 0; j < this.slotsAcross; ++j) {
                this.func_75146_a(new SlotVirtual(j + i * this.slotsAcross, x + j * 18, 18 + i * 18 + this.startY));
            }
        }
        this.updateSlots();
        if (this.hasCraftingMatrix) {
            this.func_75146_a((Slot)new SlotCrafting(player, this.craftMatrix, (IInventory)this.craftResult, 0, 26, 104));
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * 3, 7 + j * 18, 18 + i * 18));
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(playerInventory, j + i * 9 + 9, x + j * 18 + this.playerInventoryOffsetX, 103 + i * 18 + y + this.playerInventoryOffsetY));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(playerInventory, i, x + i * 18 + this.playerInventoryOffsetX, 161 + y + this.playerInventoryOffsetY));
        }
    }

    protected void initializeTerminalSize() {
        this.slotsTall = 6;
        this.slotsAcross = 9;
        this.startX = 69;
        this.startY = 0;
        this.playerInventoryOffsetX = 0;
        this.playerInventoryOffsetY = 37;
        this.hasCraftingMatrix = true;
    }

    public void updateSlots() {
        if (this.world.field_72995_K) {
            return;
        }
        this.lastChangeId = this.terminal.getStorage().getChangeId();
        List<ItemStack> typesAll = this.terminal.getStorage().getTypes();
        if (!this.searchQuery.isEmpty()) {
            Iterator<ItemStack> itr = typesAll.iterator();
            while (itr.hasNext()) {
                ItemStack is = itr.next();
                if (is.func_82833_r().toLowerCase().contains(this.searchQuery)) continue;
                itr.remove();
            }
        }
        ArrayList types = Lists.newArrayList();
        block1: for (ItemStack is : typesAll) {
            for (ItemStack existing : types) {
                if (!ItemStack.func_179545_c((ItemStack)is, (ItemStack)existing) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)existing)) continue;
                existing.field_77994_a += is.field_77994_a;
                continue block1;
            }
            types.add(is);
        }
        if (this.sortAscending) {
            Collections.sort(types, this.sortMode.comparator);
        } else {
            Collections.sort(types, ContainerTerminal$$Lambda$1.lambdaFactory$(this));
        }
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        int idx = this.scrollOffset * this.slotsAcross;
        for (Slot slot : this.field_75151_b) {
            if (!(slot instanceof SlotVirtual)) continue;
            SlotVirtual sv = (SlotVirtual)slot;
            if (idx < types.size()) {
                sv.setStack((ItemStack)types.get(idx));
            } else {
                sv.setStack(null);
            }
            ++idx;
        }
        this.rows = (int)Math.ceil((float)types.size() / (float)this.slotsAcross);
        for (IContainerListener crafter : this.field_75149_d) {
            crafter.func_71112_a((Container)this, 0, this.rows);
        }
    }

    public boolean func_75140_a(EntityPlayer playerIn, int id) {
        switch (id) {
            case -1: {
                this.sortAscending = true;
                break;
            }
            case -2: {
                this.sortAscending = false;
                break;
            }
            case -3: {
                this.sortMode = SortMode.QUANTITY;
                break;
            }
            case -4: {
                this.sortMode = SortMode.MOD_MINECRAFT_FIRST;
                break;
            }
            case -5: {
                this.sortMode = SortMode.MOD;
                break;
            }
            case -6: {
                this.sortMode = SortMode.NAME;
                break;
            }
            case -10: {
                this.craftingAmount = CraftingAmount.ONE;
                break;
            }
            case -11: {
                this.craftingAmount = CraftingAmount.STACK;
                break;
            }
            case -12: {
                this.craftingAmount = CraftingAmount.MAX;
                break;
            }
            case -20: {
                this.craftingTarget = CraftingTarget.INVENTORY;
                break;
            }
            case -21: {
                this.craftingTarget = CraftingTarget.NETWORK;
                break;
            }
            case -22: {
                break;
            }
            case -23: {
                if (!(this.terminal.getStorage() instanceof TileEntityController)) break;
                TileEntityController cont = (TileEntityController)this.terminal.getStorage();
                this.addStatusLine("total: " + Numbers.humanReadableBytes(cont.getMaxMemory() / 8L));
                this.addStatusLine("used: " + Numbers.humanReadableBytes(cont.getTotalUsedMemory() / 8L));
                this.addStatusLine("free: " + Numbers.humanReadableBytes(cont.getBitsMemoryFree() / 8L));
                this.addStatusLine("");
                this.addStatusLine("network: " + Numbers.humanReadableBytes(cont.getUsedNetworkMemory() / 8L));
                this.addStatusLine("wireless: " + Numbers.humanReadableBytes(cont.getUsedWirelessMemory() / 8L));
                this.addStatusLine("types: " + Numbers.humanReadableBytes(cont.getUsedTypeMemory() / 8L));
                this.addStatusLine("");
                break;
            }
            case -128: {
                for (int i = 0; i < 9; ++i) {
                    ItemStack is = this.craftMatrix.func_70301_a(i);
                    if (is == null) continue;
                    this.craftMatrix.func_70299_a(i, this.addItemToNetwork(is));
                }
                this.func_75142_b();
                break;
            }
            default: {
                this.scrollOffset = id;
            }
        }
        if (id > -10) {
            this.updateSlots();
        }
        return true;
    }

    public ItemStack addItemToNetwork(ItemStack stack) {
        String amt;
        if (this.player.field_70170_p.field_72995_K) {
            return null;
        }
        int oldBits = this.terminal.getStorage().getKilobitsStorageFree();
        int initialStackSize = stack.field_77994_a;
        ItemStack is = this.terminal.getStorage().addItemToNetwork(stack);
        int newBits = this.terminal.getStorage().getKilobitsStorageFree();
        int delta = oldBits - newBits;
        String string = amt = delta < 8 ? delta + " Kib" : delta / 8 + " KiB";
        if (is == null) {
            this.addStatusLine("Add " + initialStackSize + ": OK, used " + amt);
        } else if (is.field_77994_a < initialStackSize) {
            this.addStatusLine("Add " + (initialStackSize - is.field_77994_a) + ": OK, used " + amt);
        } else {
            int needed = ItemDrive.getNBTComplexity((NBTBase)stack.func_77978_p());
            needed += 64;
            this.addStatusLine("Add: Insufficient disk space.");
            this.addStatusLine("Need about " + (needed += stack.field_77994_a) + ", only " + newBits + " available");
        }
        return is;
    }

    private void addStatusLine(String line) {
        this.status.add(line);
        for (IContainerListener ic : this.field_75149_d) {
            if (!(ic instanceof EntityPlayerMP)) continue;
            EntityPlayerMP p = (EntityPlayerMP)ic;
            new AddStatusLineMessage(this.field_75152_c, line).sendTo((EntityPlayer)p);
        }
    }

    public ItemStack removeItemsFromNetwork(ItemStack prototype, int amount) {
        String amt;
        if (this.player.field_70170_p.field_72995_K) {
            return null;
        }
        int oldBits = this.terminal.getStorage().getKilobitsStorageFree();
        ItemStack is = this.terminal.getStorage().removeItemsFromNetwork(prototype, amount, true);
        int newBits = this.terminal.getStorage().getKilobitsStorageFree();
        int delta = newBits - oldBits;
        String string = amt = delta < 8 ? delta + " Kib" : delta / 8 + " KiB";
        if (is != null) {
            this.addStatusLine("Remove " + is.field_77994_a + ": OK, freed " + amt);
        }
        return is;
    }

    protected Slot func_75146_a(Slot slotIn) {
        this.oldStackSizes.add(0);
        return super.func_75146_a(slotIn);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            int old;
            ItemStack stack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            int cur = stack == null ? 0 : stack.field_77994_a;
            if (cur == (old = this.oldStackSizes.get(i).intValue())) continue;
            this.oldStackSizes.set(i, cur);
            if (cur <= 127 && cur >= -128) continue;
            for (IContainerListener ic : this.field_75149_d) {
                if (!(ic instanceof EntityPlayerMP)) continue;
                EntityPlayerMP p = (EntityPlayerMP)ic;
                if (cur <= 127) continue;
                new SetSlotSizeMessage(this.field_75152_c, i, cur).sendTo((EntityPlayer)p);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (!this.world.field_72995_K && this.terminal.hasStorage() && this.terminal.getStorage().getChangeId() != this.lastChangeId) {
            this.updateSlots();
        }
        return player == this.player && this.terminal.hasStorage() && this.terminal.getStorage().isPowered() && this.terminal.canContinueInteracting(player);
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a((Container)this, 0, this.rows);
        listener.func_71112_a((Container)this, 1, this.sortMode.ordinal());
        listener.func_71112_a((Container)this, 2, this.sortAscending ? 1 : 0);
        listener.func_71112_a((Container)this, 3, this.craftingTarget.ordinal());
        listener.func_71112_a((Container)this, 4, this.craftingAmount.ordinal());
        if (listener instanceof EntityPlayerMP) {
            new SetSearchQueryClientMessage(this.field_75152_c, this.searchQuery).sendTo((EntityPlayer)((EntityPlayerMP)listener));
        }
    }

    public void func_75137_b(int id, int data) {
        if (id == 0) {
            this.rows = data;
        } else if (id == 1) {
            SortMode[] values = SortMode.values();
            this.sortMode = values[data % values.length];
        } else if (id == 2) {
            this.sortAscending = data != 0;
        } else if (id == 3) {
            CraftingTarget[] values = CraftingTarget.values();
            this.craftingTarget = values[data % values.length];
        } else if (id == 4) {
            CraftingAmount[] values = CraftingAmount.values();
            this.craftingAmount = values[data % values.length];
        }
    }

    public ItemStack func_184996_a(int slotId, int clickedButton, ClickType clickTypeIn, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotId >= 0 ? this.func_75139_a(slotId) : null;
        if (slot instanceof SlotVirtual) {
            if (!player.field_70170_p.field_72995_K) {
                if (player.field_71071_by.func_70445_o() != null) {
                    if (clickTypeIn == ClickType.PICKUP) {
                        if (clickedButton == 0) {
                            this.addItemToNetwork(player.field_71071_by.func_70445_o());
                        } else if (clickedButton == 1) {
                            this.addItemToNetwork(player.field_71071_by.func_70445_o().func_77979_a(1));
                        }
                    }
                } else if (slot.func_75216_d()) {
                    if (clickTypeIn == ClickType.PICKUP) {
                        if (clickedButton == 0) {
                            player.field_71071_by.func_70437_b(this.removeItemsFromNetwork(slot.func_75211_c(), Math.min(64, slot.func_75211_c().func_77976_d())));
                        } else if (clickedButton == 1) {
                            player.field_71071_by.func_70437_b(this.removeItemsFromNetwork(slot.func_75211_c(), 1));
                        }
                    } else if (clickTypeIn == ClickType.QUICK_MOVE) {
                        ItemStack is = null;
                        if (clickedButton == 0) {
                            is = this.removeItemsFromNetwork(slot.func_75211_c(), Math.min(64, slot.func_75211_c().func_77976_d()));
                        } else if (clickedButton == 1) {
                            is = this.removeItemsFromNetwork(slot.func_75211_c(), 1);
                        }
                        if (is != null) {
                            if (!player.field_71071_by.func_70441_a(is)) {
                                this.addItemToNetwork(is);
                            }
                            this.func_75142_b();
                        }
                    } else if (clickTypeIn == ClickType.THROW) {
                        ItemStack is = null;
                        if (clickedButton == 0) {
                            is = this.removeItemsFromNetwork(slot.func_75211_c(), 1);
                        } else if (clickedButton == 1) {
                            is = this.removeItemsFromNetwork(slot.func_75211_c(), Math.min(64, slot.func_75211_c().func_77976_d()));
                        }
                        this.func_75142_b();
                        player.func_71019_a(is, false);
                    }
                }
            }
            if (player.field_71071_by.func_70445_o() != null && player.field_71071_by.func_70445_o().field_77994_a <= 0) {
                player.field_71071_by.func_70437_b(null);
            }
            return player.field_71071_by.func_70445_o();
        }
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            ItemStack stack;
            if (!player.field_70170_p.field_72995_K && slot != null && (stack = slot.func_75211_c()) != null) {
                if (slot instanceof SlotCrafting) {
                    ItemStack template = stack.func_77946_l();
                    for (int i = 0; i < (Integer)this.craftingAmount.amountToCraft.apply((Object)template) && (stack = slot.func_75211_c()) != null && ItemStack.func_179545_c((ItemStack)template, (ItemStack)stack); ++i) {
                        boolean success;
                        switch (this.craftingTarget) {
                            case INVENTORY: {
                                success = player.field_71071_by.func_70441_a(stack);
                                break;
                            }
                            case NETWORK: {
                                int amountOrig = stack.field_77994_a;
                                ItemStack res = this.addItemToNetwork(stack);
                                boolean bl = success = res == null || res.field_77994_a <= 0;
                                if (success || res == null) break;
                                this.removeItemsFromNetwork(stack, amountOrig - res.field_77994_a);
                                break;
                            }
                            default: {
                                success = false;
                            }
                        }
                        if (!success) break;
                        for (int j = 0; j < 9; ++j) {
                            ItemStack is;
                            ItemStack inSlot = this.craftMatrix.func_70301_a(j);
                            if (inSlot == null || (is = this.removeItemsFromNetwork(inSlot, 1)) == null || is.field_77994_a <= 0) continue;
                            inSlot.field_77994_a += is.field_77994_a;
                        }
                        slot.func_82870_a(player, stack);
                    }
                    if (this.craftingAmount == CraftingAmount.MAX) {
                        this.craftingAmount = CraftingAmount.ONE;
                        for (IContainerListener ic : this.field_75149_d) {
                            ic.func_71112_a((Container)this, 4, this.craftingAmount.ordinal());
                        }
                    }
                    this.func_75142_b();
                    return null;
                }
                ItemStack is = this.addItemToNetwork(stack);
                this.func_75139_a(slotId).func_75215_d(is);
                return is;
            }
            if (slotId >= 0) {
                return this.func_75139_a(slotId).func_75211_c();
            }
            return null;
        }
        return super.func_184996_a(slotId, clickedButton, clickTypeIn, player);
    }

    public void updateSearchQuery(String query) {
        this.searchQuery = query.toLowerCase();
        this.updateSlots();
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K) {
            for (int i = 0; i < 9; ++i) {
                ItemStack itemstack = this.craftMatrix.func_70304_b(i);
                if (itemstack == null) continue;
                player.func_71019_a(itemstack, false);
            }
        }
        ITerminal.UserPreferences prefs = this.terminal.getPreferences(player);
        prefs.sortMode = this.sortMode;
        prefs.sortAscending = this.sortAscending;
        prefs.craftingTarget = this.craftingTarget;
        prefs.lastSearchQuery = this.searchQuery;
        this.terminal.markUnderlyingStorageDirty();
    }

    public void func_75130_a(IInventory inventory) {
        this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.craftMatrix, this.player.field_70170_p));
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.craftResult && !(slot instanceof SlotVirtual) && super.func_94530_a(stack, slot);
    }

    private /* synthetic */ int lambda$updateSlots$0(ItemStack a, ItemStack b) {
        return this.sortMode.comparator.compare(b, a);
    }

    static /* synthetic */ int access$lambda$0(ContainerTerminal containerTerminal, ItemStack itemStack, ItemStack itemStack2) {
        return containerTerminal.lambda$updateSlots$0(itemStack, itemStack2);
    }

    public class SlotVirtual
    extends Slot {
        private ItemStack stack;
        private int count;

        public SlotVirtual(int index, int xPosition, int yPosition) {
            super(null, index, xPosition, yPosition);
        }

        public ItemStack func_75211_c() {
            ItemStack stack = this.stack;
            return stack;
        }

        public void func_75215_d(ItemStack stack) {
            if (((ContainerTerminal)ContainerTerminal.this).world.field_72995_K) {
                if (stack != null) {
                    int diff;
                    if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.stack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.stack) && stack.field_77994_a <= 127 && stack.field_77994_a >= -128 && (this.count < -128 || this.count > 127) && (diff = Math.abs(stack.field_77994_a - this.count)) > stack.func_77976_d()) {
                        return;
                    }
                    this.stack = stack.func_77946_l();
                    this.count = stack.field_77994_a;
                    this.stack.field_77994_a = 1;
                } else {
                    this.stack = null;
                    this.count = 0;
                }
            } else if (stack != null) {
                CoPo.log.warn("putStack was called on a virtual slot", new RuntimeException().fillInStackTrace());
                ContainerTerminal.this.addItemToNetwork(stack);
            }
        }

        public void func_75218_e() {
        }

        public int func_75219_a() {
            return Integer.MAX_VALUE;
        }

        public ItemStack func_75209_a(int amount) {
            ItemStack nw = this.stack.func_77946_l();
            nw.field_77994_a = 0;
            return nw;
        }

        public boolean func_75217_a(IInventory inv, int slotIn) {
            return false;
        }

        public int getCount() {
            return this.count;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }
    }

    public static enum CraftingAmount {
        ONE((Function<ItemStack, Integer>)ContainerTerminal$CraftingAmount$$Lambda$1.lambdaFactory$()),
        STACK((Function<ItemStack, Integer>)ContainerTerminal$CraftingAmount$$Lambda$3.lambdaFactory$()),
        MAX((Function<ItemStack, Integer>)ContainerTerminal$CraftingAmount$$Lambda$4.lambdaFactory$());

        public final String lowerName = this.name().toLowerCase(Locale.ROOT);
        public final Function<ItemStack, Integer> amountToCraft;

        private CraftingAmount(Function<ItemStack, Integer> amountToCraft) {
            this.amountToCraft = amountToCraft;
        }

        private static /* synthetic */ Integer lambda$static$2(ItemStack s) {
            return 6400;
        }

        private static /* synthetic */ Integer lambda$static$1(ItemStack s) {
            return s.func_77976_d() / Math.max(1, s.field_77994_a);
        }

        private static /* synthetic */ Integer lambda$static$0(ItemStack s) {
            return 1;
        }

        static /* synthetic */ Integer access$lambda$0(ItemStack itemStack) {
            return CraftingAmount.lambda$static$0(itemStack);
        }

        static /* synthetic */ Integer access$lambda$1(ItemStack itemStack) {
            return CraftingAmount.lambda$static$1(itemStack);
        }

        static /* synthetic */ Integer access$lambda$2(ItemStack itemStack) {
            return CraftingAmount.lambda$static$2(itemStack);
        }
    }

    public static enum CraftingTarget {
        NETWORK,
        INVENTORY;

        public final String lowerName = this.name().toLowerCase(Locale.ROOT);
    }

    public static enum SortMode {
        QUANTITY(ContainerTerminal$SortMode$$Lambda$1.lambdaFactory$()),
        MOD_MINECRAFT_FIRST(ContainerTerminal$SortMode$$Lambda$2.lambdaFactory$()),
        MOD(ContainerTerminal$SortMode$$Lambda$3.lambdaFactory$()),
        NAME(ContainerTerminal$SortMode$$Lambda$4.lambdaFactory$());

        public final Comparator<ItemStack> comparator;
        public final String lowerName = this.name().toLowerCase(Locale.ROOT);

        private SortMode(Comparator<ItemStack> comparator) {
            this.comparator = comparator;
        }

        private static String getModId(ItemStack is) {
            return ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)is.func_77973_b())).func_110624_b();
        }

        private static /* synthetic */ int lambda$static$3(ItemStack a, ItemStack b) {
            return Collator.getInstance().compare(a.func_82833_r(), b.func_82833_r());
        }

        private static /* synthetic */ int lambda$static$2(ItemStack a, ItemStack b) {
            int modComp = Collator.getInstance().compare(SortMode.getModId(a), SortMode.getModId(b));
            if (modComp != 0) {
                return modComp;
            }
            return Collator.getInstance().compare(a.func_82833_r(), b.func_82833_r());
        }

        private static /* synthetic */ int lambda$static$1(ItemStack a, ItemStack b) {
            String modA = SortMode.getModId(a);
            String modB = SortMode.getModId(b);
            boolean aMinecraft = "minecraft".equals(modA);
            boolean bMinecraft = "minecraft".equals(modB);
            if (aMinecraft || bMinecraft && aMinecraft != bMinecraft) {
                return Booleans.compare((boolean)aMinecraft, (boolean)bMinecraft);
            }
            int modComp = Collator.getInstance().compare(modA, modB);
            if (modComp != 0) {
                return modComp;
            }
            return Collator.getInstance().compare(a.func_82833_r(), b.func_82833_r());
        }

        private static /* synthetic */ int lambda$static$0(ItemStack a, ItemStack b) {
            int quantityComp = Ints.compare((int)a.field_77994_a, (int)b.field_77994_a);
            if (quantityComp != 0) {
                return quantityComp;
            }
            return Collator.getInstance().compare(a.func_82833_r(), b.func_82833_r());
        }

        static /* synthetic */ int access$lambda$0(ItemStack itemStack, ItemStack itemStack2) {
            return SortMode.lambda$static$0(itemStack, itemStack2);
        }

        static /* synthetic */ int access$lambda$1(ItemStack itemStack, ItemStack itemStack2) {
            return SortMode.lambda$static$1(itemStack, itemStack2);
        }

        static /* synthetic */ int access$lambda$2(ItemStack itemStack, ItemStack itemStack2) {
            return SortMode.lambda$static$2(itemStack, itemStack2);
        }

        static /* synthetic */ int access$lambda$3(ItemStack itemStack, ItemStack itemStack2) {
            return SortMode.lambda$static$3(itemStack, itemStack2);
        }
    }
}

