/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.item;

import com.google.common.collect.Lists;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.helper.ItemStacks;
import io.github.elytra.copo.helper.Numbers;
import io.github.elytra.copo.proxy.ClientProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemDrive
extends Item {
    private final int[] tierSizes = new int[]{8192, 32768, 131072, 524288, -1, 0x100000};

    public ItemDrive() {
        this.func_77625_d(1);
    }

    public int getFullnessColor(ItemStack stack) {
        int idx;
        boolean dirty;
        boolean bl = dirty = stack.func_77942_o() && stack.func_77978_p().func_74767_n("Dirty") && field_77697_d.nextBoolean();
        if (dirty && field_77697_d.nextInt(20) == 0) {
            stack.func_77978_p().func_82580_o("Dirty");
        }
        if (stack.func_77952_i() == 4) {
            int x;
            idx = x = (int)((MathHelper.func_76126_a((float)(ClientProxy.ticks / 20.0f)) + 1.0f) / 2.0f * 255.0f);
            if (!dirty) {
                idx += 256;
            }
        } else {
            idx = 512;
            float usedBits = (float)this.getKilobitsUsed(stack) / (float)this.getMaxKilobits(stack);
            int x = (int)(usedBits * 255.0f);
            idx += x;
            if (!dirty) {
                idx += 256;
            }
        }
        return CoPo.proxy.getColor("fullness", idx);
    }

    public int getTierColor(ItemStack stack) {
        if (stack.func_77960_j() == 4) {
            return CoPo.proxy.getColor("tier", 16);
        }
        int meta = stack.func_77960_j();
        if (meta > 4) {
            --meta;
        }
        return CoPo.proxy.getColor("tier", meta);
    }

    public int getBaseColor(ItemStack stack) {
        return stack.func_77952_i() == 4 ? CoPo.proxy.getColor("other", 33) : CoPo.proxy.getColor("other", 49);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_74837_a((String)"tooltip.correlatedpotentialistics.rf_usage", (Object[])new Object[]{this.getRFConsumptionRate(stack)}));
        if (stack.func_77952_i() == 4) {
            int i = 0;
            while (I18n.func_94522_b((String)("tooltip.correlatedpotentialistics.void_drive." + i))) {
                tooltip.add(I18n.func_74837_a((String)("tooltip.correlatedpotentialistics.void_drive." + i), (Object[])new Object[0]));
                ++i;
            }
        } else {
            int bytesUsed = this.getKilobitsUsed(stack) / 8 * 1024;
            int bytesMax = this.getMaxKilobits(stack) / 8 * 1024;
            int bytesPercent = (int)((double)bytesUsed / (double)bytesMax * 100.0);
            String max = Numbers.humanReadableBytes(bytesMax);
            tooltip.add(I18n.func_74837_a((String)"tooltip.correlatedpotentialistics.bytes_used", (Object[])new Object[]{Numbers.humanReadableBytes(bytesUsed), max, bytesPercent}));
        }
    }

    public int getRFConsumptionRate(ItemStack stack) {
        if (stack.func_77952_i() == 4) {
            return CoPo.inst.voidDriveUsage;
        }
        int dmg = stack.func_77952_i() + 1;
        if (stack.func_77952_i() == 6) {
            dmg = 8;
        }
        return (int)Math.pow(CoPo.inst.driveRfUsagePow, dmg) / CoPo.inst.driveRfUsageDiv;
    }

    public boolean func_77614_k() {
        return true;
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77960_j() == 4) {
            return I18n.func_74838_a((String)"item.correlatedpotentialistics.drive.void.name");
        }
        return I18n.func_74837_a((String)"item.correlatedpotentialistics.drive.normal.name", (Object[])new Object[]{Numbers.humanReadableBytes(this.getMaxKilobits(stack) / 8 * 1024)});
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (int i = 0; i < this.tierSizes.length; ++i) {
            subItems.add(new ItemStack(itemIn, 1, i));
        }
    }

    public int getMaxKilobits(ItemStack stack) {
        return this.tierSizes[stack.func_77952_i() % this.tierSizes.length];
    }

    public int getTypeAllocationKilobits(ItemStack stack, NBTTagCompound prototype) {
        return 32 + ItemDrive.getNBTComplexity(prototype == null ? null : prototype.func_74781_a("tag"));
    }

    public static int getNBTComplexity(NBTBase base) {
        if (base == null) {
            return 0;
        }
        int complexity = 0;
        switch (base.func_74732_a()) {
            case 1: {
                complexity += 4;
                break;
            }
            case 2: {
                complexity += 8;
                break;
            }
            case 3: {
                complexity += 16;
                break;
            }
            case 4: {
                complexity += 32;
                break;
            }
            case 7: {
                complexity += 8;
                complexity += ((NBTTagByteArray)base).func_150292_c().length * 4;
                break;
            }
            case 11: {
                complexity += 8;
                complexity += ((NBTTagIntArray)base).func_150302_c().length * 16;
                break;
            }
            case 8: {
                String str = ((NBTTagString)base).func_150285_a_();
                complexity += ItemDrive.getStringComplexity(str);
                break;
            }
            case 9: {
                NBTTagList li = (NBTTagList)base;
                complexity += 4;
                for (int i = 0; i < li.func_74745_c(); ++i) {
                    complexity += ItemDrive.getNBTComplexity(li.func_179238_g(i));
                }
                break;
            }
            case 10: {
                NBTTagCompound compound = (NBTTagCompound)base;
                complexity += 4;
                for (String k : compound.func_150296_c()) {
                    complexity += ItemDrive.getStringComplexity(k);
                    NBTBase tag = compound.func_74781_a(k);
                    if ("Count".equals(k) || "Amount".equals(k) && tag instanceof NBTPrimitive) {
                        complexity += ((NBTPrimitive)tag).func_150287_d();
                    }
                    complexity += ItemDrive.getNBTComplexity(compound.func_74781_a(k));
                }
                break;
            }
        }
        return complexity;
    }

    public static int getStringComplexity(String str) {
        int complexity = 8;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c < '\u00ff') {
                complexity += 4;
                continue;
            }
            complexity += 8;
        }
        return complexity;
    }

    public Priority getPriority(ItemStack stack) {
        return (Priority)((Object)ItemStacks.getEnum(stack, "Priority", Priority.class).or((Object)Priority.DEFAULT));
    }

    public void setPriority(ItemStack stack, Priority priority) {
        ItemStacks.ensureHasTag(stack).func_77978_p().func_74778_a("Priority", priority.name());
    }

    public PartitioningMode getPartitioningMode(ItemStack stack) {
        return (PartitioningMode)((Object)ItemStacks.getEnum(stack, "PartitioningMode", PartitioningMode.class).or((Object)PartitioningMode.NONE));
    }

    public void setPartitioningMode(ItemStack stack, PartitioningMode mode) {
        ItemStacks.ensureHasTag(stack).func_77978_p().func_74778_a("PartitioningMode", mode.name());
    }

    public void markDirty(ItemStack stack) {
        ItemStacks.ensureHasTag(stack).func_77978_p().func_74757_a("Dirty", true);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            playerIn.func_184185_a(CoPo.drive_disassemble, 0.4f, 0.875f + field_77697_d.nextFloat() / 4.0f);
            NBTTagList ingredients = ItemStacks.getCompoundList(itemStackIn, "Ingredients");
            if (!worldIn.field_72995_K) {
                for (int i = 0; i < ingredients.func_74745_c(); ++i) {
                    ItemStack is = ItemStack.func_77949_a((NBTTagCompound)ingredients.func_150305_b(i));
                    if (is.func_77973_b() == CoPo.misc && (is.func_77960_j() == 3 || is.func_77960_j() == 8)) continue;
                    playerIn.func_70099_a(is, 0.5f);
                }
            }
            if (!ItemStacks.getCompoundList(itemStackIn, "Data").func_82582_d()) {
                ItemStack dataCore = new ItemStack((Item)CoPo.misc, 1, 8);
                dataCore.func_77982_d(itemStackIn.func_77978_p().func_74737_b());
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)dataCore);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)new ItemStack((Item)CoPo.misc, 1, 3));
        }
        playerIn.openGui((Object)CoPo.inst, 1, worldIn, playerIn.field_71071_by.field_70461_c, 0, 0);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public int getKilobitsUsed(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        if (!stack.func_77978_p().func_150297_b("Data", 9) || ItemStacks.getCompoundList(stack, "Data").func_82582_d()) {
            return stack.func_77978_p().func_74762_e("UsedBits");
        }
        NBTTagList list = ItemStacks.getCompoundList(stack, "Data");
        int used = 0;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            used += this.getTypeAllocationKilobits(stack, list.func_150305_b(i).func_74775_l("Prototype"));
            used += list.func_150305_b(i).func_74762_e("Count");
        }
        return used;
    }

    public int getKilobitsFree(ItemStack stack) {
        if (this.getMaxKilobits(stack) == -1) {
            return Integer.MAX_VALUE;
        }
        return this.getMaxKilobits(stack) - this.getKilobitsUsed(stack);
    }

    protected NBTTagCompound createPrototype(ItemStack item) {
        if (item == null) {
            return null;
        }
        NBTTagCompound prototype = item.func_77955_b(new NBTTagCompound());
        prototype.func_82580_o("Count");
        return prototype;
    }

    protected NBTTagCompound findDataForPrototype(ItemStack drive, NBTTagCompound prototype) {
        int index = this.findDataIndexForPrototype(drive, prototype);
        if (index == -1) {
            return null;
        }
        return ItemStacks.getCompoundList(drive, "Data").func_150305_b(index);
    }

    protected int findDataIndexForPrototype(ItemStack drive, NBTTagCompound prototype) {
        if (prototype == null) {
            return -1;
        }
        NBTTagList list = ItemStacks.getCompoundList(drive, "Data");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (!tag.func_74775_l("Prototype").equals((Object)prototype)) continue;
            return i;
        }
        return -1;
    }

    public int getKilobitsFreeFor(ItemStack drive, ItemStack item) {
        if (this.getMaxKilobits(drive) == -1) {
            return Integer.MAX_VALUE;
        }
        NBTTagCompound prototype = this.createPrototype(item);
        NBTTagCompound data = this.findDataForPrototype(drive, prototype);
        if (data != null) {
            return this.getKilobitsFree(drive);
        }
        if (this.getPartitioningMode(drive) == PartitioningMode.NONE) {
            return Math.max(0, this.getKilobitsFree(drive) - this.getTypeAllocationKilobits(drive, prototype));
        }
        return 0;
    }

    public ItemStack addItem(ItemStack drive, ItemStack item) {
        if (this.getMaxKilobits(drive) == -1) {
            if (this.getPartitioningMode(drive) == PartitioningMode.NONE || this.findDataIndexForPrototype(drive, this.createPrototype(item)) != -1) {
                item.field_77994_a = 0;
                return null;
            }
            return item;
        }
        int bitsFree = this.getKilobitsFreeFor(drive, item);
        int amountTaken = Math.min(item.field_77994_a, bitsFree);
        int current = this.getAmountStored(drive, item);
        if (amountTaken > 0) {
            this.setAmountStored(drive, item, current + amountTaken);
            item.field_77994_a -= amountTaken;
            this.markDirty(drive);
        }
        if (item.field_77994_a <= 0) {
            return null;
        }
        return item;
    }

    public ItemStack removeItems(ItemStack drive, ItemStack stack, int amountWanted) {
        if (this.getMaxKilobits(drive) == -1) {
            return null;
        }
        int stored = this.getAmountStored(drive, stack);
        int amountGiven = Math.min(amountWanted, stored);
        if (amountGiven > 0) {
            this.setAmountStored(drive, stack, stored - amountGiven);
            stack.field_77994_a += amountGiven;
            this.markDirty(drive);
        }
        return stack;
    }

    public int getAmountStored(ItemStack drive, ItemStack item) {
        if (this.getMaxKilobits(drive) == -1) {
            return 0;
        }
        NBTTagCompound data = this.findDataForPrototype(drive, this.createPrototype(item));
        if (data == null) {
            return 0;
        }
        return data.func_74762_e("Count");
    }

    public void setAmountStored(ItemStack drive, ItemStack item, int amount) {
        if (this.getMaxKilobits(drive) == -1) {
            return;
        }
        NBTTagCompound prototype = this.createPrototype(item);
        NBTTagList list = ItemStacks.getCompoundList(drive, "Data");
        int index = this.findDataIndexForPrototype(drive, prototype);
        if (index == -1) {
            this.allocateType(drive, item, item.field_77994_a);
        } else if (amount <= 0 && this.getPartitioningMode(drive) == PartitioningMode.NONE) {
            this.deallocateType(drive, item);
        } else {
            list.func_150305_b(index).func_74768_a("Count", amount);
        }
        this.markDirty(drive);
    }

    public List<ItemStack> getPrototypes(ItemStack drive) {
        NBTTagList list = ItemStacks.getCompoundList(drive, "Data");
        ArrayList rtrn = Lists.newArrayList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Prototype"));
            if (is == null) {
                list.func_74744_a(i);
                continue;
            }
            rtrn.add(is);
        }
        return rtrn;
    }

    public List<ItemStack> getTypes(ItemStack drive) {
        if (this.getMaxKilobits(drive) == -1) {
            return Lists.newArrayList();
        }
        NBTTagList list = ItemStacks.getCompoundList(drive, "Data");
        ArrayList rtrn = Lists.newArrayList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int count = tag.func_74762_e("Count");
            if (count <= 0) continue;
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Prototype"));
            if (is == null) {
                list.func_74744_a(i);
                continue;
            }
            is.field_77994_a = count;
            rtrn.add(is);
        }
        return rtrn;
    }

    public void allocateType(ItemStack drive, ItemStack item, int count) {
        NBTTagCompound prototype = this.createPrototype(item);
        int idx = this.findDataIndexForPrototype(drive, prototype);
        if (idx == -1) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74782_a("Prototype", (NBTBase)prototype);
            data.func_74768_a("Count", count);
            ItemStacks.getCompoundList(drive, "Data").func_74742_a((NBTBase)data);
            this.markDirty(drive);
        }
    }

    public void deallocateType(ItemStack drive, ItemStack item) {
        NBTTagCompound prototype = this.createPrototype(item);
        int idx = this.findDataIndexForPrototype(drive, prototype);
        if (idx != -1) {
            ItemStacks.getCompoundList(drive, "Data").func_74744_a(idx);
            this.markDirty(drive);
        }
    }

    public static enum PartitioningMode {
        NONE,
        WHITELIST;

        public final String lowerName = this.name().toLowerCase(Locale.ROOT);
    }

    public static enum Priority {
        HIGHEST(TextFormatting.RED),
        HIGHER(TextFormatting.DARK_RED),
        HIGH(TextFormatting.GRAY),
        DEFAULT(TextFormatting.GRAY),
        LOW(TextFormatting.GRAY),
        LOWER(TextFormatting.DARK_GREEN),
        LOWEST(TextFormatting.GREEN);

        public final String lowerName = this.name().toLowerCase(Locale.ROOT);
        public final TextFormatting color;

        private Priority(TextFormatting color) {
            this.color = color;
        }
    }
}

