/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.item;

import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.CoPoWorldData;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityWirelessTransmitter;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemWirelessTerminal
extends Item {
    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && this.getTransmitter(stack, world, player, true) != null) {
            player.openGui((Object)CoPo.inst, 3, world, player.field_71071_by.field_70461_c, 0, 0);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityWirelessTransmitter) {
            TileEntityWirelessTransmitter tewt = (TileEntityWirelessTransmitter)te;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74772_a("TransmitterUUIDMost", tewt.getId().getMostSignificantBits());
            stack.func_77978_p().func_74772_a("TransmitterUUIDLeast", tewt.getId().getLeastSignificantBits());
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.terminal_linked", new Object[0]));
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public int getItemStackLimit(ItemStack is) {
        return 1;
    }

    public CoPoWorldData.Transmitter getTransmitter(ItemStack stack, World world, EntityPlayer player, boolean sendMessages) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("TransmitterUUIDMost")) {
            if (sendMessages) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.terminal_unlinked", new Object[0]));
            }
            return null;
        }
        UUID uuid = new UUID(stack.func_77978_p().func_74763_f("TransmitterUUIDMost"), stack.func_77978_p().func_74763_f("TransmitterUUIDLeast"));
        CoPoWorldData.Transmitter t = CoPo.getDataFor(world).getTransmitterById(uuid);
        if (t == null) {
            if (sendMessages) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.terminal_cantconnect", new Object[0]));
            }
            return null;
        }
        if (t.position.func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v) > t.range * t.range) {
            if (sendMessages) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.correlatedpotentialistics.terminal_outofrange", new Object[0]));
            }
            return null;
        }
        return t;
    }

    public TileEntityController getTransmitterController(ItemStack stack, World world, EntityPlayer player) {
        CoPoWorldData.Transmitter t = this.getTransmitter(stack, world, player, false);
        if (t == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(t.position);
        if (te != null && te instanceof TileEntityWirelessTransmitter) {
            return ((TileEntityWirelessTransmitter)te).getStorage();
        }
        return null;
    }
}

