/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.network;

import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.client.gui.GuiAutomaton;
import io.github.elytra.copo.client.gui.GuiDrive;
import io.github.elytra.copo.client.gui.GuiImporterChest;
import io.github.elytra.copo.client.gui.GuiInterface;
import io.github.elytra.copo.client.gui.GuiTerminal;
import io.github.elytra.copo.entity.EntityAutomaton;
import io.github.elytra.copo.inventory.ContainerAutomaton;
import io.github.elytra.copo.inventory.ContainerDrive;
import io.github.elytra.copo.inventory.ContainerImporterChest;
import io.github.elytra.copo.inventory.ContainerInterface;
import io.github.elytra.copo.inventory.ContainerTerminal;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.item.ItemWirelessTerminal;
import io.github.elytra.copo.storage.WirelessTerminal;
import io.github.elytra.copo.tile.TileEntityImporterChest;
import io.github.elytra.copo.tile.TileEntityInterface;
import io.github.elytra.copo.tile.TileEntityTerminal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class CoPoGuiHandler
implements IGuiHandler {
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (id) {
            case 0: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (te instanceof TileEntityTerminal) {
                    return new ContainerTerminal((IInventory)player.field_71071_by, player, (TileEntityTerminal)te);
                }
                CoPo.log.warn("Expected TileEntityTerminal at {}, {}, {} - got {} instead", new Object[]{x, y, z, te == null ? "null" : te.getClass()});
                break;
            }
            case 1: {
                ItemStack drive = player.field_71071_by.func_70301_a(x);
                if (drive != null && drive.func_77973_b() instanceof ItemDrive) {
                    return new ContainerDrive((IInventory)player.field_71071_by, x, player);
                }
                CoPo.log.warn("Expected a drive, got {} instead", new Object[]{drive});
                break;
            }
            case 2: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (te instanceof TileEntityInterface) {
                    return new ContainerInterface(player.field_71071_by, player, (TileEntityInterface)te);
                }
                CoPo.log.warn("Expected TileEntityInterface at {}, {}, {} - got {} instead", new Object[]{x, y, z, te == null ? "null" : te.getClass()});
                break;
            }
            case 3: {
                ItemStack terminal = player.field_71071_by.func_70301_a(x);
                if (terminal != null && terminal.func_77973_b() instanceof ItemWirelessTerminal) {
                    return new ContainerTerminal((IInventory)player.field_71071_by, player, new WirelessTerminal(world, player, (ItemWirelessTerminal)terminal.func_77973_b(), terminal));
                }
                CoPo.log.warn("Expected a wireless terminal, got {} instead", new Object[]{terminal});
                break;
            }
            case 4: {
                Entity ent = world.func_73045_a(x);
                if (ent != null && ent instanceof EntityAutomaton) {
                    return new ContainerAutomaton((IInventory)player.field_71071_by, player, (EntityAutomaton)ent);
                }
                CoPo.log.warn("Expected an Automaton, got {} instead", new Object[]{ent == null ? "null" : ent.getClass()});
                break;
            }
            case 5: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (te instanceof TileEntityImporterChest) {
                    return new ContainerImporterChest((IInventory)player.field_71071_by, player, (TileEntityImporterChest)te);
                }
                CoPo.log.warn("Expected TileEntityImporterChest at {}, {}, {} - got {} instead", new Object[]{x, y, z, te == null ? "null" : te.getClass()});
                break;
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (id) {
            case 0: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (te instanceof TileEntityTerminal) {
                    return new GuiTerminal(new ContainerTerminal((IInventory)player.field_71071_by, player, (TileEntityTerminal)te));
                }
                CoPo.log.warn("Expected TileEntityTerminal at {}, {}, {} - got {} instead", new Object[]{x, y, z, te == null ? "null" : te.getClass()});
                break;
            }
            case 1: {
                ItemStack drive = player.field_71071_by.func_70301_a(x);
                if (drive != null && drive.func_77973_b() instanceof ItemDrive) {
                    return new GuiDrive(new ContainerDrive((IInventory)player.field_71071_by, x, player));
                }
                CoPo.log.warn("Expected a drive, got {} instead", new Object[]{drive});
                break;
            }
            case 2: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (te instanceof TileEntityInterface) {
                    return new GuiInterface(new ContainerInterface(player.field_71071_by, player, (TileEntityInterface)te));
                }
                CoPo.log.warn("Expected TileEntityInterface at {}, {}, {} - got {} instead", new Object[]{x, y, z, te == null ? "null" : te.getClass()});
                break;
            }
            case 3: {
                ItemStack terminal = player.field_71071_by.func_70301_a(x);
                if (terminal != null && terminal.func_77973_b() instanceof ItemWirelessTerminal) {
                    return new GuiTerminal(new ContainerTerminal((IInventory)player.field_71071_by, player, new WirelessTerminal(world, player, (ItemWirelessTerminal)terminal.func_77973_b(), terminal)));
                }
                CoPo.log.warn("Expected a wireless terminal, got {} instead", new Object[]{terminal});
                break;
            }
            case 4: {
                Entity ent = world.func_73045_a(x);
                if (ent != null && ent instanceof EntityAutomaton) {
                    return new GuiAutomaton(new ContainerAutomaton((IInventory)player.field_71071_by, player, (EntityAutomaton)ent));
                }
                CoPo.log.warn("Expected an Automaton, got {} instead", new Object[]{ent == null ? "null" : ent.getClass()});
                break;
            }
            case 5: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (te instanceof TileEntityImporterChest) {
                    return new GuiImporterChest(new ContainerImporterChest((IInventory)player.field_71071_by, player, (TileEntityImporterChest)te));
                }
                CoPo.log.warn("Expected TileEntityImporterChest at {}, {}, {} - got {} instead", new Object[]{x, y, z, te == null ? "null" : te.getClass()});
                break;
            }
        }
        return null;
    }
}

