/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.network;

import com.google.common.collect.Lists;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.entity.automaton.Instruction;
import io.github.elytra.copo.entity.automaton.Opcode;
import io.github.elytra.copo.helper.ItemStacks;
import io.github.elytra.copo.inventory.ContainerTerminal;
import io.github.elytra.copo.item.ItemFloppy;
import io.github.elytra.copo.network.SetEditorStatusMessage;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.Message;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.NetworkContext;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.annotation.field.MarshalledAs;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.annotation.type.ReceivedOn;
import io.github.elytra.copo.tile.TileEntityTerminal;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.relauncher.Side;

@ReceivedOn(value=Side.SERVER)
public class SaveProgramMessage
extends Message {
    @MarshalledAs(value="string-list")
    public List<String> opcodes;
    @MarshalledAs(value="string-list-list")
    public List<List<String>> arguments;

    public SaveProgramMessage(NetworkContext ctx) {
        super(ctx);
    }

    public SaveProgramMessage(List<String> opcodes, List<List<String>> arguments) {
        super(CoPo.inst.network);
        this.opcodes = opcodes;
        this.arguments = arguments;
    }

    @Override
    protected void handle(EntityPlayer sender) {
        NBTTagList src;
        EntityPlayerMP p = (EntityPlayerMP)sender;
        Container c = p.field_71070_bA;
        if (!(c instanceof ContainerTerminal)) {
            return;
        }
        int wi = p.field_71139_cq;
        TileEntityTerminal tet = (TileEntityTerminal)((ContainerTerminal)c).terminal;
        ItemStack floppy = tet.func_70301_a(1);
        if (floppy != null && floppy.func_77973_b() instanceof ItemFloppy) {
            ItemFloppy item = (ItemFloppy)floppy.func_77973_b();
            if (item.isWriteProtected(floppy)) {
                new SetEditorStatusMessage(wi, "Write protect error").sendTo(sender);
                return;
            }
            ItemStacks.ensureHasTag(floppy).func_77978_p().func_82580_o("Compiled");
            src = new NBTTagList();
            for (int i = 0; i < this.opcodes.size(); ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("Opcode", this.opcodes.get(i));
                NBTTagList args = new NBTTagList();
                for (int j = 0; j < this.arguments.get(i).size(); ++j) {
                    args.func_74742_a((NBTBase)new NBTTagString(this.arguments.get(i).get(j)));
                }
                tag.func_74782_a("Arguments", (NBTBase)args);
                src.func_74742_a((NBTBase)tag);
            }
        } else {
            new SetEditorStatusMessage(wi, "Not ready reading drive A").sendTo(sender);
            return;
        }
        ItemStacks.ensureHasTag(floppy).func_77978_p().func_74782_a("SourceCode", (NBTBase)src);
        try {
            ArrayList li = Lists.newArrayList();
            String lastWarning = null;
            String error = null;
            int warn = 0;
            int cap = 0;
            block6: for (int i = 0; i < this.opcodes.size(); ++i) {
                Object o;
                Opcode oc = Opcode.lookup(this.opcodes.get(i));
                List<String> args = this.arguments.get(i);
                if (oc == null) {
                    ++cap;
                    li.add(null);
                    ++warn;
                    lastWarning = "line " + (i + 1) + ": Bad opcode " + this.opcodes.get(i);
                    continue;
                }
                if (args.size() != oc.getArgumentSpec().size()) {
                    error = "line " + (i + 1) + ": Not enough arguments";
                    break;
                }
                Instruction ins = new Instruction();
                ins.opcode = oc;
                int size = 0;
                ArrayList parsed = Lists.newArrayList();
                for (int j = 0; j < oc.getArgumentSpec().size(); ++j) {
                    Opcode.ArgumentSpec as = (Opcode.ArgumentSpec)((Object)oc.getArgumentSpec().get(j));
                    String str = (String)args.get(j);
                    try {
                        o = as.parser.apply((Object)str);
                        parsed.add(o);
                        size += as.sizer.apply(o);
                        continue;
                    }
                    catch (Exception e) {
                        error = "line " + (i + 1) + ", Invalid argument " + j;
                        break block6;
                    }
                }
                ByteBuf buf = Unpooled.buffer((int)size, (int)size);
                for (int j = 0; j < oc.getArgumentSpec().size(); ++j) {
                    Opcode.ArgumentSpec as = (Opcode.ArgumentSpec)((Object)oc.getArgumentSpec().get(j));
                    o = parsed.get(j);
                    as.writer.accept(buf, o);
                }
                ins.arguments = buf;
                li.add(ins);
                ++cap;
                cap += size;
            }
            if (error != null) {
                new SetEditorStatusMessage(wi, "Save OK, compile fail: " + error).sendTo(sender);
                return;
            }
            String status = warn <= 0 ? "Save and compile OK" : (warn == 1 ? "Save OK, compile warn: " + lastWarning : "Save OK, compile warn x" + warn);
            ByteBuf buf = Unpooled.buffer((int)cap);
            for (Instruction ins : li) {
                if (ins == null || ins.opcode == null) {
                    buf.writeByte(255);
                    continue;
                }
                buf.writeByte(ins.opcode.getBytecode());
                buf.writeBytes(ins.arguments);
            }
            byte[] bys = new byte[buf.readableBytes()];
            ItemStacks.ensureHasTag(floppy).func_77978_p().func_74773_a("Compiled", bys);
            new SetEditorStatusMessage(wi, status).sendTo(sender);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            new SetEditorStatusMessage(wi, "Save OK, compile fail: Internal error").sendTo(sender);
            return;
        }
    }
}

