/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.proxy;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.client.ParticleWeldthrower;
import io.github.elytra.copo.client.gui.GuiAbortRetryFail;
import io.github.elytra.copo.client.gui.GuiFakeReboot;
import io.github.elytra.copo.client.gui.GuiGlitchedMainMenu;
import io.github.elytra.copo.client.render.entity.RenderThrownItem;
import io.github.elytra.copo.client.render.tile.RenderController;
import io.github.elytra.copo.client.render.tile.RenderDriveBay;
import io.github.elytra.copo.client.render.tile.RenderImporterChest;
import io.github.elytra.copo.client.render.tile.RenderMemoryBay;
import io.github.elytra.copo.client.render.tile.RenderTerminal;
import io.github.elytra.copo.client.render.tile.RenderWirelessReceiver;
import io.github.elytra.copo.client.render.tile.RenderWirelessTransmitter;
import io.github.elytra.copo.entity.EntityAutomaton;
import io.github.elytra.copo.entity.EntityThrownItem;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.item.ItemKeycard;
import io.github.elytra.copo.item.ItemMemory;
import io.github.elytra.copo.item.ItemMisc;
import io.github.elytra.copo.item.ItemModule;
import io.github.elytra.copo.proxy.ClientProxy$$Lambda$1;
import io.github.elytra.copo.proxy.ClientProxy$$Lambda$2;
import io.github.elytra.copo.proxy.ClientProxy$$Lambda$3;
import io.github.elytra.copo.proxy.ClientProxy$$Lambda$4;
import io.github.elytra.copo.proxy.ClientProxy$$Lambda$5;
import io.github.elytra.copo.proxy.Proxy;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityDriveBay;
import io.github.elytra.copo.tile.TileEntityImporterChest;
import io.github.elytra.copo.tile.TileEntityMemoryBay;
import io.github.elytra.copo.tile.TileEntityTerminal;
import io.github.elytra.copo.tile.TileEntityWirelessReceiver;
import io.github.elytra.copo.tile.TileEntityWirelessTransmitter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.codecs.CodecIBXM;

public class ClientProxy
extends Proxy {
    public static float ticks = 0.0f;
    public static int glitchTicks = -1;
    private BitSet glitchJpeg;
    private int jpegTexture = -1;
    private Random rand = new Random();
    private Set<String> knownColorTypes = Sets.newHashSet((Object[])new String[]{"tier", "fullness", "other", "pci"});
    private Map<String, int[]> colors = Maps.newHashMap();
    private Future<BufferedImage> corruptionFuture;
    private ExecutorService jpegCorruptor = Executors.newFixedThreadPool(1, ClientProxy$$Lambda$1.lambdaFactory$());
    private Callable<BufferedImage> jpegCorruptionTask = ClientProxy$$Lambda$2.lambdaFactory$(this);

    @Override
    public void preInit() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityController.class, (TileEntitySpecialRenderer)new RenderController());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDriveBay.class, (TileEntitySpecialRenderer)new RenderDriveBay());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMemoryBay.class, (TileEntitySpecialRenderer)new RenderMemoryBay());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTerminal.class, (TileEntitySpecialRenderer)new RenderTerminal());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWirelessReceiver.class, (TileEntitySpecialRenderer)new RenderWirelessReceiver());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWirelessTransmitter.class, (TileEntitySpecialRenderer)new RenderWirelessTransmitter());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityImporterChest.class, (TileEntitySpecialRenderer)new RenderImporterChest());
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)CoPo.wireless_endpoint), (int)0, TileEntityWirelessReceiver.class);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)CoPo.wireless_endpoint), (int)1, TileEntityWirelessTransmitter.class);
        RenderingRegistry.registerEntityRenderingHandler(EntityThrownItem.class, (IRenderFactory)ClientProxy$$Lambda$3.lambdaFactory$());
        RenderingRegistry.registerEntityRenderingHandler(EntityAutomaton.class, (IRenderFactory)ClientProxy$$Lambda$4.lambdaFactory$());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(ClientProxy$$Lambda$5.lambdaFactory$(this));
        ModelLoader.setCustomModelResourceLocation((Item)CoPo.floppy, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("correlatedpotentialistics", "floppy_write_enabled"), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)CoPo.floppy, (int)1, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("correlatedpotentialistics", "floppy_write_disabled"), "inventory"));
        int idx = 0;
        for (String s : ItemMisc.items) {
            ModelLoader.setCustomModelResourceLocation((Item)CoPo.misc, (int)idx++, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("correlatedpotentialistics", s), "inventory"));
        }
        idx = 0;
        for (String s : ItemKeycard.colors) {
            ModelLoader.setCustomModelResourceLocation((Item)CoPo.keycard, (int)idx++, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("correlatedpotentialistics", "keycard_" + s), "inventory"));
        }
    }

    @Override
    public int getColor(String group, int index) {
        if (index < 0) {
            return -1;
        }
        if (!this.colors.containsKey(group)) {
            return -1;
        }
        int[] rgb = this.colors.get(group);
        if (rgb == null || index >= rgb.length) {
            return -1;
        }
        return rgb[index] | 0xFF000000;
    }

    @Override
    public void postInit() {
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (stack == null || !(stack.func_77973_b() instanceof ItemModule)) {
                    return -1;
                }
                ItemModule id = (ItemModule)stack.func_77973_b();
                if (tintIndex == 1) {
                    return id.getTypeColor(stack);
                }
                return -1;
            }
        }, new Item[]{CoPo.module});
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (stack == null || !(stack.func_77973_b() instanceof ItemMemory)) {
                    return -1;
                }
                ItemMemory id = (ItemMemory)stack.func_77973_b();
                if (tintIndex == 1) {
                    return id.getTierColor(stack);
                }
                return -1;
            }
        }, new Item[]{CoPo.memory});
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (stack == null || !(stack.func_77973_b() instanceof ItemDrive)) {
                    return -1;
                }
                ItemDrive id = (ItemDrive)stack.func_77973_b();
                if (tintIndex == 1) {
                    return id.getFullnessColor(stack);
                }
                if (tintIndex == 2) {
                    return id.getTierColor(stack);
                }
                if (tintIndex == 3) {
                    switch (id.getPartitioningMode(stack)) {
                        case NONE: {
                            return ClientProxy.this.getColor("other", 1);
                        }
                        case WHITELIST: {
                            return ClientProxy.this.getColor("other", 0);
                        }
                    }
                } else if (tintIndex >= 4 && tintIndex <= 6) {
                    int uncolored = stack.func_77952_i() == 4 ? ClientProxy.this.getColor("other", 32) : ClientProxy.this.getColor("other", 48);
                    int red = ClientProxy.this.getColor("other", 16);
                    int green = ClientProxy.this.getColor("other", 17);
                    int left = uncolored;
                    int middle = uncolored;
                    int right = uncolored;
                    switch (id.getPriority(stack)) {
                        case HIGHEST: {
                            right = red;
                        }
                        case HIGHER: {
                            middle = red;
                        }
                        case HIGH: {
                            left = red;
                            break;
                        }
                        case LOWEST: {
                            left = green;
                        }
                        case LOWER: {
                            middle = green;
                        }
                        case LOW: {
                            right = green;
                            break;
                        }
                    }
                    if (tintIndex == 4) {
                        return left;
                    }
                    if (tintIndex == 5) {
                        return middle;
                    }
                    if (tintIndex == 6) {
                        return right;
                    }
                }
                return id.getBaseColor(stack);
            }
        }, new Item[]{CoPo.drive});
    }

    @Override
    public void registerItemModel(Item item, int variants) {
        block4: {
            ResourceLocation loc;
            block5: {
                block3: {
                    loc = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
                    if (variants < -1) {
                        variants = variants * -1 - 1;
                        loc = new ResourceLocation("correlatedpotentialistics", "tesrstack");
                    }
                    if (variants != -1) break block3;
                    ArrayList li = Lists.newArrayList();
                    item.func_150895_a(item, CoPo.creativeTab, (List)li);
                    for (ItemStack is : li) {
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)is.func_77952_i(), (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
                    }
                    break block4;
                }
                if (variants != 0) break block5;
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
                break block4;
            }
            if (variants <= 0) break block4;
            for (int i = 0; i < variants; ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory" + i));
            }
        }
    }

    @Override
    public void weldthrowerTick(EntityPlayer player) {
        Vec3d look = player.func_70040_Z();
        Vec3d right = look.func_178785_b(-90.0f);
        double dist = 0.5;
        double gap = 1.0;
        double fuzz = 0.05;
        look.func_178785_b(20.0f);
        for (int i = 0; i < 5; ++i) {
            Random rand = player.field_70170_p.field_73012_v;
            ParticleWeldthrower dust = new ParticleWeldthrower(player.field_70170_p, player.field_70165_t + right.field_72450_a * dist + look.field_72450_a * gap, player.field_70163_u + ((double)player.func_70047_e() - 0.1) + right.field_72448_b * dist + look.field_72448_b * gap, player.field_70161_v + right.field_72449_c * dist + look.field_72449_c * gap, 1.0f);
            dust.func_70538_b(0.0f, 0.972549f - rand.nextFloat() / 5.0f, 0.8235294f - rand.nextFloat() / 5.0f);
            dust.setMotion(look.field_72450_a + rand.nextGaussian() * fuzz, look.field_72448_b + rand.nextGaussian() * fuzz, look.field_72449_c + rand.nextGaussian() * fuzz);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)dust);
        }
    }

    @Override
    public void weldthrowerHeal(EntityAutomaton ent) {
        for (int i = 0; i < 5; ++i) {
            Random rand = ent.field_70170_p.field_73012_v;
            ParticleWeldthrower dust = new ParticleWeldthrower(ent.field_70170_p, ent.field_70165_t + rand.nextGaussian() * 0.2, ent.field_70163_u + rand.nextGaussian() * 0.2, ent.field_70161_v + rand.nextGaussian() * 0.2, 1.0f);
            dust.func_70538_b(0.0f, 0.972549f - rand.nextFloat() / 5.0f, 0.8235294f - rand.nextFloat() / 5.0f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)dust);
        }
    }

    @Override
    public void smokeTick(EntityAutomaton ent) {
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71441_e.func_82737_E() < 10L) {
            return;
        }
        Random rand = ent.field_70170_p.field_73012_v;
        int i = 0;
        while ((float)i < ent.func_110138_aP() - ent.func_110143_aJ()) {
            if (rand.nextInt(5) == 0) {
                Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), ent.field_70165_t + rand.nextGaussian() * 0.2, ent.field_70163_u + rand.nextGaussian() * 0.2, ent.field_70161_v + rand.nextGaussian() * 0.2, 0.0, 0.0, 0.0, new int[0]);
            }
            ++i;
        }
        if (ent.func_110143_aJ() < ent.func_110138_aP() / 2.0f && rand.nextInt(10) == 0) {
            Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.LAVA.func_179348_c(), ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            ticks += 1.0f;
            if (glitchTicks > -1 && Minecraft.func_71410_x().field_71441_e == null) {
                glitchTicks = -1;
            }
            if (glitchTicks > -1 && this.jpegTexture != -1 && !Minecraft.func_71410_x().func_147113_T()) {
                if (++glitchTicks >= 240) {
                    glitchTicks = -1;
                    Minecraft.func_71410_x().func_147118_V().func_147690_c();
                    if (Minecraft.func_71410_x().field_71439_g != null && !Minecraft.func_71410_x().field_71439_g.field_70128_L) {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiFakeReboot());
                    }
                }
                if (this.glitchJpeg != null && this.corruptionFuture == null) {
                    this.corruptionFuture = this.jpegCorruptor.submit(this.jpegCorruptionTask);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderTick(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            ticks = (float)((int)ticks) + e.renderTickTime;
        } else if (e.phase == TickEvent.Phase.END && (Minecraft.func_71410_x().field_71462_r == null || Minecraft.func_71410_x().field_71462_r instanceof GuiGlitchedMainMenu)) {
            this.drawGlitch();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Pre e) {
        if (!(e.getGui() instanceof GuiGlitchedMainMenu)) {
            this.drawGlitch();
        }
    }

    @SubscribeEvent
    public void onSoundSetup(SoundSetupEvent e) throws SoundSystemException {
        SoundSystemConfig.setCodec((String)"xm", CodecIBXM.class);
        SoundSystemConfig.setCodec((String)"s3m", CodecIBXM.class);
        SoundSystemConfig.setCodec((String)"mod", CodecIBXM.class);
    }

    @SubscribeEvent
    public void onSoundPlay(PlaySoundEvent e) {
        if ((glitchTicks >= 0 || Minecraft.func_71410_x().field_71462_r instanceof GuiFakeReboot || Minecraft.func_71410_x().field_71462_r instanceof GuiGlitchedMainMenu) && e.getSound() != null && !e.getSound().func_147650_b().func_110624_b().equals("correlatedpotentialistics") && !e.getSound().func_147650_b().func_110623_a().contains("glitch")) {
            e.setResultSound(null);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent e) {
        if (glitchTicks >= 0 && e.getGui() != null && !(e.getGui() instanceof GuiIngameMenu)) {
            e.setCanceled(true);
        } else if (Minecraft.func_71410_x().field_71441_e != null && !Minecraft.func_71410_x().field_71441_e.func_72912_H().func_76093_s() && e.getGui() instanceof GuiGameOver && !(e.getGui() instanceof GuiAbortRetryFail) && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71093_bK == CoPo.limboDimId) {
            e.setGui((GuiScreen)new GuiAbortRetryFail((ITextComponent)ReflectionHelper.getPrivateValue(GuiGameOver.class, (Object)((GuiGameOver)e.getGui()), (String[])new String[]{"field_184871_f", "causeOfDeath", "f"})));
        }
    }

    private void drawGlitch() {
        if (glitchTicks == 0) {
            if (this.jpegTexture != -1) {
                TextureUtil.func_147942_a((int)this.jpegTexture);
                this.jpegTexture = -1;
            }
            this.jpegTexture = TextureUtil.func_110996_a();
            BufferedImage raw = ScreenShotHelper.func_186719_a((int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d, (Framebuffer)Minecraft.func_71410_x().func_147110_a());
            Image scaled = raw.getScaledInstance(854, 480, 16);
            BufferedImage screenshot = new BufferedImage(854, 480, 5);
            Graphics2D g = screenshot.createGraphics();
            g.drawImage(scaled, 0, 0, null);
            g.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                if (this.corruptionFuture != null) {
                    this.corruptionFuture.cancel(true);
                    this.corruptionFuture = null;
                }
                ImageIO.write((RenderedImage)screenshot, "JPEG", baos);
                this.glitchJpeg = BitSet.valueOf(baos.toByteArray());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else if (glitchTicks == -1) {
            if (this.jpegTexture != -1) {
                if (this.corruptionFuture != null) {
                    this.corruptionFuture.cancel(true);
                    this.corruptionFuture = null;
                }
                TextureUtil.func_147942_a((int)this.jpegTexture);
                this.jpegTexture = -1;
            }
        } else if (glitchTicks > 0) {
            if (this.corruptionFuture != null && this.corruptionFuture.isDone()) {
                try {
                    TextureUtil.func_110987_a((int)this.jpegTexture, (BufferedImage)this.corruptionFuture.get());
                    this.corruptionFuture = null;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            Tessellator tess = Tessellator.func_178181_a();
            VertexBuffer vb = tess.func_178180_c();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179144_i((int)this.jpegTexture);
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(0.0, (double)res.func_78328_b(), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            vb.func_181662_b((double)res.func_78326_a(), (double)res.func_78328_b(), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            vb.func_181662_b((double)res.func_78326_a(), 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            vb.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179126_j();
        }
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre e) {
        e.getMap().func_174942_a(new ResourceLocation("correlatedpotentialistics", "blocks/wireless_endpoint_error"));
        e.getMap().func_174942_a(new ResourceLocation("correlatedpotentialistics", "blocks/wireless_endpoint_linked"));
        e.getMap().func_174942_a(new ResourceLocation("correlatedpotentialistics", "items/wireless_terminal_glow"));
        e.getMap().func_174942_a(new ResourceLocation("correlatedpotentialistics", "items/doc_tablet_glow"));
        e.getMap().func_174942_a(new ResourceLocation("correlatedpotentialistics", "items/keycard_glow"));
    }

    @SubscribeEvent
    public void onSoundLoad(SoundLoadEvent e) {
        for (String snd : CoPo.records) {
            String file = snd.substring(0, snd.indexOf(46));
            final String ext = snd.substring(snd.indexOf(46) + 1);
            Sound danslarue = new Sound("correlatedpotentialistics:" + file, 1.0f, 1.0f, 1, Sound.Type.FILE, true){

                public ResourceLocation func_188721_b() {
                    return new ResourceLocation(this.func_188719_a().func_110624_b(), "sounds/music/" + this.func_188719_a().func_110623_a() + "." + ext);
                }
            };
            SoundList li = new SoundList((List)Lists.newArrayList((Object[])new Sound[]{danslarue}), false, null);
            Method m = ReflectionHelper.findMethod(SoundHandler.class, (Object)e.getManager().field_148622_c, (String[])new String[]{"func_147693_a", "loadSoundResource", "a"}, (Class[])new Class[]{ResourceLocation.class, SoundList.class});
            try {
                m.invoke((Object)e.getManager().field_148622_c, new ResourceLocation("correlatedpotentialistics", file), li);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderSpecificHandEvent e) {
        if (e.getItemStack() != null) {
            float equippedProgress;
            float prevEquippedProgress;
            EnumHandSide handSide;
            Item item = e.getItemStack().func_77973_b();
            if (item != CoPo.wireless_terminal && item != CoPo.drive && item != CoPo.memory && item != CoPo.keycard) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP p = mc.field_71439_g;
            EnumHand hand = e.getHand();
            ItemRenderer ir = mc.func_175597_ag();
            boolean isMain = hand == EnumHand.MAIN_HAND;
            EnumHandSide enumHandSide = handSide = isMain ? p.func_184591_cq() : p.func_184591_cq().func_188468_a();
            if (isMain) {
                prevEquippedProgress = ir.field_187470_g;
                equippedProgress = ir.field_187469_f;
            } else {
                prevEquippedProgress = ir.field_187472_i;
                equippedProgress = ir.field_187471_h;
            }
            float partialTicks = e.getPartialTicks();
            float swingProgress = p.func_70678_g(partialTicks);
            EnumHand swingingHand = (EnumHand)Objects.firstNonNull((Object)p.field_184622_au, (Object)EnumHand.MAIN_HAND);
            float interpPitch = p.field_70127_C + (p.field_70125_A - p.field_70127_C) * partialTicks;
            float interpYaw = p.field_70126_B + (p.field_70177_z - p.field_70126_B) * partialTicks;
            float swing = swingingHand == hand ? swingProgress : 0.0f;
            float equip = 1.0f - (prevEquippedProgress + (equippedProgress - prevEquippedProgress) * partialTicks);
            ir.func_178101_a(interpPitch, interpYaw);
            ir.func_187464_b();
            ir.func_187458_c(partialTicks);
            GlStateManager.func_179091_B();
            ir.func_187457_a((AbstractClientPlayer)p, partialTicks, interpPitch, hand, swing, e.getItemStack(), equip);
            ItemCameraTransforms.TransformType transform = handSide == EnumHandSide.RIGHT ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
            IBakedModel model = mc.func_175599_af().func_184393_a(e.getItemStack(), (World)mc.field_71441_e, (EntityLivingBase)p);
            GlStateManager.func_179094_E();
            float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swing) * (float)Math.PI));
            float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swing) * ((float)Math.PI * 2)));
            float f2 = -0.2f * MathHelper.func_76126_a((float)(swing * (float)Math.PI));
            int i = isMain ? 1 : -1;
            GlStateManager.func_179109_b((float)((float)i * f), (float)f1, (float)f2);
            ir.func_187459_b(handSide, equip);
            ir.func_187453_a(handSide, swing);
            ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transform, (handSide == EnumHandSide.LEFT ? 1 : 0) != 0);
            GlStateManager.func_179129_p();
            GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)0.03225f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glDisable((int)2896);
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            if (item == CoPo.wireless_terminal) {
                this.drawSprite(mc.func_147117_R().func_110572_b("correlatedpotentialistics:items/wireless_terminal_glow"));
            } else if (item == CoPo.drive) {
                TextureAtlasSprite fullness = mc.func_147117_R().func_110572_b("correlatedpotentialistics:items/drive_fullness_light");
                TextureAtlasSprite tier = mc.func_147117_R().func_110572_b("correlatedpotentialistics:items/drive_tier_light");
                TextureAtlasSprite partition = mc.func_147117_R().func_110572_b("correlatedpotentialistics:items/drive_partition_light");
                TextureAtlasSprite priority_left = mc.func_147117_R().func_110572_b("correlatedpotentialistics:items/drive_priority_light_left");
                TextureAtlasSprite priority_mid = mc.func_147117_R().func_110572_b("correlatedpotentialistics:items/drive_priority_light_middle");
                TextureAtlasSprite priority_right = mc.func_147117_R().func_110572_b("correlatedpotentialistics:items/drive_priority_light_right");
                int uncolored = e.getItemStack().func_77952_i() == 4 ? this.getColor("other", 32) : this.getColor("other", 48);
                int priorityLeftColor = mc.getItemColors().func_186728_a(e.getItemStack(), 4);
                int priorityMidColor = mc.getItemColors().func_186728_a(e.getItemStack(), 5);
                int priorityRightColor = mc.getItemColors().func_186728_a(e.getItemStack(), 6);
                this.color(mc.getItemColors().func_186728_a(e.getItemStack(), 1));
                this.drawSprite(fullness);
                this.color(mc.getItemColors().func_186728_a(e.getItemStack(), 2));
                this.drawSprite(tier);
                this.color(mc.getItemColors().func_186728_a(e.getItemStack(), 3));
                this.drawSprite(partition);
                if (priorityLeftColor != uncolored) {
                    this.color(priorityLeftColor);
                    this.drawSprite(priority_left);
                }
                if (priorityMidColor != uncolored) {
                    this.color(priorityMidColor);
                    this.drawSprite(priority_mid);
                }
                if (priorityRightColor != uncolored) {
                    this.color(priorityRightColor);
                    this.drawSprite(priority_right);
                }
            } else if (item == CoPo.memory) {
                TextureAtlasSprite tier = mc.func_147117_R().func_110572_b("correlatedpotentialistics:items/ram_tier_light");
                this.color(mc.getItemColors().func_186728_a(e.getItemStack(), 1));
                this.drawSprite(tier);
            } else if (item == CoPo.keycard) {
                this.drawSprite(mc.func_147117_R().func_110572_b("correlatedpotentialistics:items/keycard_glow"));
            }
            GL11.glEnable((int)2896);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            ir.func_187464_b();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
        }
    }

    private void color(int packed) {
        GlStateManager.func_179124_c((float)((float)(packed >> 16 & 0xFF) / 255.0f), (float)((float)(packed >> 8 & 0xFF) / 255.0f), (float)((float)(packed & 0xFF) / 255.0f));
    }

    public void drawSprite(TextureAtlasSprite tas) {
        float minU = tas.func_94209_e();
        float minV = tas.func_94206_g();
        float maxU = tas.func_94212_f();
        float maxV = tas.func_94210_h();
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer vb = tess.func_178180_c();
        vb.func_181668_a(8, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        vb.func_181662_b(1.0, 0.0, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        vb.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        vb.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        tess.func_78381_a();
    }

    private /* synthetic */ void lambda$preInit$3(IResourceManager rm) {
        this.colors.clear();
        for (String s : this.knownColorTypes) {
            try {
                IResource res = rm.func_110536_a(new ResourceLocation("correlatedpotentialistics", "textures/misc/" + s + "_colors.png"));
                InputStream in = res.func_110527_b();
                BufferedImage img = ImageIO.read(in);
                in.close();
                int[] rgb = new int[img.getWidth() * img.getHeight()];
                img.getRGB(0, 0, img.getWidth(), img.getHeight(), rgb, 0, img.getWidth());
                this.colors.put(s, rgb);
                CoPo.log.info("Successfully loaded {} colors", new Object[]{s});
            }
            catch (IOException e) {
                CoPo.log.info("Error while loading {} colors", new Object[]{s});
            }
        }
    }

    private static /* synthetic */ Render lambda$preInit$2(RenderManager rm) {
        return new RenderThrownItem(rm, Minecraft.func_71410_x().func_175599_af());
    }

    private /* synthetic */ BufferedImage lambda$new$1() throws Exception {
        int tries = 0;
        while (++tries <= 20) {
            int idx = this.rand.nextInt(this.glitchJpeg.size());
            this.glitchJpeg.flip(idx);
            try {
                BufferedImage jpeg = ImageIO.read(new ByteArrayInputStream(this.glitchJpeg.toByteArray()));
                return jpeg;
            }
            catch (IOException e1) {
                this.glitchJpeg.flip(idx);
                continue;
            }
            break;
        }
        return null;
    }

    private static /* synthetic */ Thread lambda$new$0(Runnable r) {
        return new Thread(r, "JPEG Corruption Thread");
    }

    static /* synthetic */ Thread access$lambda$0(Runnable runnable) {
        return ClientProxy.lambda$new$0(runnable);
    }

    static /* synthetic */ BufferedImage access$lambda$1(ClientProxy clientProxy) {
        return clientProxy.lambda$new$1();
    }

    static /* synthetic */ Render access$lambda$2(RenderManager renderManager) {
        return ClientProxy.lambda$preInit$2(renderManager);
    }

    static /* synthetic */ void access$lambda$3(ClientProxy clientProxy, IResourceManager iResourceManager) {
        clientProxy.lambda$preInit$3(iResourceManager);
    }
}

