/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.com.sun.speech.freetts;

import io.github.elytra.copo.repackage.com.sun.speech.freetts.PhoneSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PhoneSetImpl
implements PhoneSet {
    private int lineCount = 0;
    private Map phonesetMap = new HashMap();

    public PhoneSetImpl(URL url) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        ++this.lineCount;
        while (line != null) {
            if (!line.startsWith("***")) {
                this.parseAndAdd(line);
            }
            line = reader.readLine();
        }
        reader.close();
    }

    private void parseAndAdd(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        try {
            String phoneme = tokenizer.nextToken();
            String feature = tokenizer.nextToken();
            String value = tokenizer.nextToken();
            this.phonesetMap.put(this.getKey(phoneme, feature), value);
        }
        catch (NoSuchElementException nse) {
            throw new Error("part of speech data in bad format at line " + this.lineCount);
        }
    }

    private String getKey(String phoneme, String feature) {
        return phoneme + feature;
    }

    public String getPhoneFeature(String phone, String featureName) {
        return (String)this.phonesetMap.get(this.getKey(phone, featureName));
    }
}

