/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.com.sun.speech.freetts.audio;

import io.github.elytra.copo.repackage.com.sun.speech.freetts.audio.AudioPlayer;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.util.Utilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class MultiFileAudioPlayer
implements AudioPlayer {
    private AudioFormat currentFormat = null;
    private int fileCount = 0;
    private String baseName;
    private byte[] outputData;
    private int curIndex = 0;
    private AudioFileFormat.Type outputType;

    public MultiFileAudioPlayer() {
        this(Utilities.getProperty("io.github.elytra.copo.repackage.com.sun.speech.freetts.AudioPlayer.baseName", "freetts"), AudioFileFormat.Type.WAVE);
    }

    public MultiFileAudioPlayer(String baseName, AudioFileFormat.Type type) {
        this.baseName = baseName;
        this.outputType = type;
    }

    public synchronized void setAudioFormat(AudioFormat format) {
        this.currentFormat = format;
    }

    public AudioFormat getAudioFormat() {
        return this.currentFormat;
    }

    public void pause() {
    }

    public synchronized void resume() {
    }

    public void startFirstSampleTimer() {
    }

    public synchronized void cancel() {
    }

    public synchronized void reset() {
    }

    public synchronized void close() {
    }

    public float getVolume() {
        return 1.0f;
    }

    public void setVolume(float volume) {
    }

    public void begin(int size) {
        this.outputData = new byte[size];
        this.curIndex = 0;
    }

    public boolean end() {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.outputData);
        AudioInputStream ais = new AudioInputStream(bais, this.currentFormat, this.outputData.length / this.currentFormat.getFrameSize());
        String name = this.baseName;
        name = name + this.fileCount;
        name = name + "." + this.outputType.getExtension();
        File file = new File(name);
        try {
            AudioSystem.write(ais, this.outputType, file);
            System.out.println("Wrote synthesized speech to " + name);
        }
        catch (IOException ioe) {
            System.err.println("Can't write audio to " + file);
            return false;
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Can't write audio type " + this.outputType);
            return false;
        }
        ++this.fileCount;
        return true;
    }

    public boolean drain() {
        return true;
    }

    public synchronized long getTime() {
        return -1L;
    }

    public synchronized void resetTime() {
    }

    public boolean write(byte[] audioData) {
        return this.write(audioData, 0, audioData.length);
    }

    public boolean write(byte[] bytes, int offset, int size) {
        System.arraycopy(bytes, offset, this.outputData, this.curIndex, size);
        this.curIndex += size;
        return true;
    }

    public String toString() {
        return "FileAudioPlayer";
    }

    public void showMetrics() {
    }
}

