/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.com.sun.speech.freetts.clunits;

import io.github.elytra.copo.repackage.com.sun.speech.freetts.Unit;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.clunits.ClusterUnitDatabase;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.Sample;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.SampleSet;

class ClusterUnit
implements Unit {
    private ClusterUnitDatabase db;
    private String name;
    private int start;
    private int end;

    public ClusterUnit(ClusterUnitDatabase db, String name, int start, int end) {
        this.db = db;
        this.start = start;
        this.end = end;
        this.name = name;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.db.getSts().getUnitSize(this.start, this.end);
    }

    public Sample getNearestSample(float index) {
        int iSize = 0;
        SampleSet sts = this.db.getSts();
        for (int i = this.start; i < this.end; ++i) {
            Sample sample = sts.getSample(i);
            int nSize = iSize + sample.getResidualSize();
            if (Math.abs(index - (float)iSize) < Math.abs(index - (float)nSize)) {
                return sample;
            }
            iSize = nSize;
        }
        return sts.getSample(this.end - 1);
    }

    public String toString() {
        return this.getName();
    }

    public void dump() {
    }
}

