/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.com.sun.speech.freetts.clunits;

import io.github.elytra.copo.repackage.com.sun.speech.freetts.Item;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.ProcessException;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Utterance;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.UtteranceProcessor;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.LPCResult;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.SampleSet;

public class ClusterUnitPitchmarkGenerator
implements UtteranceProcessor {
    public void processUtterance(Utterance utterance) throws ProcessException {
        int unitEnd;
        int unitStart;
        int unitEntry;
        int pitchmarks = 0;
        int uttSize = 0;
        SampleSet sts = (SampleSet)utterance.getObject("sts_list");
        LPCResult lpcResult = new LPCResult();
        for (Item unit = utterance.getRelation("Unit").getHead(); unit != null; unit = unit.getNext()) {
            unitEntry = unit.getFeatures().getInt("unit_entry");
            unitStart = unit.getFeatures().getInt("unit_start");
            unitEnd = unit.getFeatures().getInt("unit_end");
            pitchmarks += unitEnd - unitStart;
            unit.getFeatures().setInt("target_end", uttSize += sts.getUnitSize(unitStart, unitEnd));
        }
        lpcResult.resizeFrames(pitchmarks);
        pitchmarks = 0;
        uttSize = 0;
        int[] targetTimes = lpcResult.getTimes();
        for (Item unit = utterance.getRelation("Unit").getHead(); unit != null; unit = unit.getNext()) {
            unitEntry = unit.getFeatures().getInt("unit_entry");
            unitStart = unit.getFeatures().getInt("unit_start");
            unitEnd = unit.getFeatures().getInt("unit_end");
            int i = unitStart;
            while (i < unitEnd) {
                targetTimes[pitchmarks] = uttSize += sts.getSample(i).getResidualSize();
                ++i;
                ++pitchmarks;
            }
        }
        utterance.setObject("target_lpcres", lpcResult);
    }

    public String toString() {
        return "ClusterUnitPitchmarkGenerator";
    }
}

