/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.com.sun.speech.freetts.diphone;

import io.github.elytra.copo.repackage.com.sun.speech.freetts.diphone.AliasDiphone;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.Sample;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Diphone {
    protected static final int MAGIC = 262988031;
    protected static final int ALIAS_MAGIC = 195800832;
    protected static final int NAME_LENGTH = 8;
    private String name;
    private int midPoint;
    private Sample[] samples;
    private int unitSizePart1;
    private int unitSizePart2;

    public Diphone(String name, Sample[] samples, int midPoint) {
        int i;
        this.name = name;
        this.midPoint = midPoint;
        this.samples = samples;
        this.unitSizePart1 = 0;
        this.unitSizePart2 = 0;
        for (i = 0; i < midPoint; ++i) {
            this.unitSizePart1 += samples[i].getResidualSize();
        }
        for (i = midPoint; i < samples.length; ++i) {
            this.unitSizePart2 += samples[i].getResidualSize();
        }
    }

    protected Diphone(String name) {
        this.name = name;
        this.midPoint = 0;
        this.samples = null;
        this.unitSizePart1 = 0;
        this.unitSizePart2 = 0;
    }

    public Sample[] getSamples() {
        return this.samples;
    }

    public Sample getSamples(int which) {
        return this.samples[which];
    }

    public String getName() {
        return this.name;
    }

    public int getMidPoint() {
        return this.midPoint;
    }

    public int getPbPositionMillis() {
        return this.getMidPoint();
    }

    public Sample nearestSample(float uIndex, int unitPart) {
        int iSize = 0;
        int start = unitPart == 1 ? 0 : this.midPoint;
        int end = unitPart == 1 ? this.midPoint : this.samples.length;
        for (int i = start; i < end; ++i) {
            int nSize = iSize + this.samples[i].getResidualSize();
            if (Math.abs(uIndex - (float)iSize) < Math.abs(uIndex - (float)nSize)) {
                return this.samples[i];
            }
            iSize = nSize;
        }
        return this.samples[end - 1];
    }

    public int getUnitSize(int unitPart) {
        if (unitPart == 1) {
            return this.unitSizePart1;
        }
        return this.unitSizePart2;
    }

    public void dump() {
        System.out.println("Diphone: " + this.name);
        System.out.println("    MP : " + this.midPoint);
        for (int i = 0; i < this.samples.length; ++i) {
            this.samples[i].dump();
        }
    }

    public void dumpBinary(ByteBuffer bb) throws IOException {
        int i;
        char[] nameArray = (this.name + "        ").toCharArray();
        bb.putInt(262988031);
        for (i = 0; i < 8; ++i) {
            bb.putChar(nameArray[i]);
        }
        bb.putInt(this.midPoint);
        bb.putInt(this.samples.length);
        for (i = 0; i < this.samples.length; ++i) {
            this.samples[i].dumpBinary(bb);
        }
    }

    public void dumpBinary(DataOutputStream os) throws IOException {
        int i;
        char[] nameArray = (this.name + "        ").toCharArray();
        os.writeInt(262988031);
        for (i = 0; i < 8; ++i) {
            os.writeChar(nameArray[i]);
        }
        os.writeInt(this.midPoint);
        os.writeInt(this.samples.length);
        for (i = 0; i < this.samples.length; ++i) {
            this.samples[i].dumpBinary(os);
        }
    }

    boolean compare(Diphone other) {
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (this.midPoint != other.getMidPoint()) {
            return false;
        }
        if (this.samples.length != other.getSamples().length) {
            return false;
        }
        for (int i = 0; i < this.samples.length; ++i) {
            if (this.samples[i].compare(other.getSamples(i))) continue;
            return false;
        }
        return true;
    }

    public static Diphone loadBinary(ByteBuffer bb) throws IOException {
        int i;
        StringBuffer sb = new StringBuffer();
        int magic = bb.getInt();
        if (magic == 195800832) {
            for (int i2 = 0; i2 < 8; ++i2) {
                char c = bb.getChar();
                if (Character.isWhitespace(c)) continue;
                sb.append(c);
            }
            String name = sb.toString().trim();
            sb.setLength(0);
            for (int i3 = 0; i3 < 8; ++i3) {
                char c = bb.getChar();
                if (Character.isWhitespace(c)) continue;
                sb.append(c);
            }
            String origName = sb.toString().trim();
            return new AliasDiphone(name, origName);
        }
        if (magic != 262988031) {
            throw new Error("Bad magic number in diphone");
        }
        for (i = 0; i < 8; ++i) {
            char c = bb.getChar();
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        int midPoint = bb.getInt();
        int numSamples = bb.getInt();
        Sample[] samples = new Sample[numSamples];
        for (i = 0; i < numSamples; ++i) {
            samples[i] = Sample.loadBinary(bb);
        }
        return new Diphone(sb.toString().trim(), samples, midPoint);
    }

    public static Diphone loadBinary(DataInputStream dis) throws IOException {
        int i;
        StringBuffer sb = new StringBuffer();
        int magic = dis.readInt();
        if (magic == 195800832) {
            for (int i2 = 0; i2 < 8; ++i2) {
                char c = dis.readChar();
                if (Character.isWhitespace(c)) continue;
                sb.append(c);
            }
            String name = sb.toString().trim();
            sb.setLength(0);
            for (int i3 = 0; i3 < 8; ++i3) {
                char c = dis.readChar();
                if (Character.isWhitespace(c)) continue;
                sb.append(c);
            }
            String origName = sb.toString().trim();
            return new AliasDiphone(name, origName);
        }
        if (magic != 262988031) {
            throw new Error("Bad magic number in diphone");
        }
        for (i = 0; i < 8; ++i) {
            char c = dis.readChar();
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        int midPoint = dis.readInt();
        int numSamples = dis.readInt();
        Sample[] samples = new Sample[numSamples];
        for (i = 0; i < numSamples; ++i) {
            samples[i] = Sample.loadBinary(dis);
        }
        return new Diphone(sb.toString().trim(), samples, midPoint);
    }
}

