/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.com.sun.speech.freetts.diphone;

import io.github.elytra.copo.repackage.com.sun.speech.freetts.diphone.AliasDiphone;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.diphone.Diphone;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.Sample;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.SampleInfo;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.util.BulkTimer;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.util.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiphoneUnitDatabase {
    private static final Logger LOGGER = Logger.getLogger(DiphoneUnitDatabase.class.getName());
    private String name;
    private int sampleRate;
    private int numChannels;
    private int residualFold = 1;
    private float lpcMin;
    private float lpcRange;
    private int lineCount = 0;
    private Diphone defaultDiphone;
    private Map diphoneMap = null;
    private Map diphoneIndex;
    private SampleInfo sampleInfo;
    private boolean useNewIO = Utilities.getProperty("io.github.elytra.copo.repackage.com.sun.speech.freetts.useNewIO", "true").equals("true");
    private String cacheType = Utilities.getProperty("io.github.elytra.copo.repackage.com.sun.speech.freetts.diphone.UnitDatabase.cacheType", "preload");
    private boolean useIndexing = !this.cacheType.equals("preload");
    private boolean useCache = !this.cacheType.equals("demand");
    private boolean useSoftCache = this.cacheType.equals("soft");
    private static final int MAGIC = -17958194;
    private static final int INDEX_MAGIC = 16435934;
    private static final int VERSION = 1;
    private static final int MAX_DB_SIZE = 0x400000;
    private String indexName = null;
    private MappedByteBuffer mbb = null;
    private int defaultIndex = -1;

    public DiphoneUnitDatabase(URL url, boolean isBinary) throws IOException {
        this.diphoneMap = new LinkedHashMap();
        InputStream is = Utilities.getInputStream(url);
        this.indexName = this.getIndexName(url.toString());
        if (isBinary) {
            this.loadBinary(is);
        } else {
            this.loadText(is);
        }
        is.close();
        this.sampleInfo = new SampleInfo(this.sampleRate, this.numChannels, this.residualFold, this.lpcMin, this.lpcRange, 0.0f);
    }

    SampleInfo getSampleInfo() {
        return this.sampleInfo;
    }

    private String getIndexName(String databaseName) {
        String indexName = null;
        if (databaseName.lastIndexOf(".") != -1) {
            indexName = databaseName.substring(0, databaseName.lastIndexOf(".")) + ".idx";
        }
        return indexName;
    }

    private void loadText(InputStream is) {
        if (is == null) {
            throw new Error("Can't load diphone db file.");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line = reader.readLine();
            ++this.lineCount;
            while (line != null) {
                if (!line.startsWith("***")) {
                    this.parseAndAdd(line, reader);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new Error(e.getMessage() + " at line " + this.lineCount);
        }
    }

    private void parseAndAdd(String line, BufferedReader reader) {
        block15: {
            try {
                StringTokenizer tokenizer = new StringTokenizer(line, " ");
                String tag = tokenizer.nextToken();
                if (tag.equals("NAME")) {
                    this.name = tokenizer.nextToken();
                    break block15;
                }
                if (tag.equals("SAMPLE_RATE")) {
                    this.sampleRate = Integer.parseInt(tokenizer.nextToken());
                    break block15;
                }
                if (tag.equals("NUM_CHANNELS")) {
                    this.numChannels = Integer.parseInt(tokenizer.nextToken());
                    break block15;
                }
                if (tag.equals("LPC_MIN")) {
                    this.lpcMin = Float.parseFloat(tokenizer.nextToken());
                    break block15;
                }
                if (tag.equals("COEFF_MIN")) {
                    this.lpcMin = Float.parseFloat(tokenizer.nextToken());
                    break block15;
                }
                if (tag.equals("COEFF_RANGE")) {
                    this.lpcRange = Float.parseFloat(tokenizer.nextToken());
                    break block15;
                }
                if (tag.equals("LPC_RANGE")) {
                    this.lpcRange = Float.parseFloat(tokenizer.nextToken());
                    break block15;
                }
                if (tag.equals("ALIAS")) {
                    String name = tokenizer.nextToken();
                    String origName = tokenizer.nextToken();
                    AliasDiphone diphone = new AliasDiphone(name, origName);
                    this.add(diphone);
                    break block15;
                }
                if (tag.equals("DIPHONE")) {
                    String name = tokenizer.nextToken();
                    int start = Integer.parseInt(tokenizer.nextToken());
                    int mid = Integer.parseInt(tokenizer.nextToken());
                    int end = Integer.parseInt(tokenizer.nextToken());
                    int numSamples = end - start;
                    int midPoint = mid - start;
                    if (this.numChannels <= 0) {
                        throw new Error("For diphone '" + name + "': Bad number of channels " + this.numChannels);
                    }
                    if (numSamples <= 0) {
                        throw new Error("For diphone '" + name + "': Bad number of samples " + numSamples);
                    }
                    Sample[] samples = new Sample[numSamples];
                    for (int i = 0; i < samples.length; ++i) {
                        samples[i] = new Sample(reader, this.numChannels);
                    }
                    Diphone diphone = new Diphone(name, samples, midPoint);
                    this.add(diphone);
                    break block15;
                }
                throw new Error("Unsupported tag " + tag);
            }
            catch (NoSuchElementException nse) {
                throw new Error("Error parsing db " + nse.getMessage());
            }
            catch (NumberFormatException nfe) {
                throw new Error("Error parsing numbers in db " + nfe.getMessage());
            }
        }
    }

    private void add(Diphone diphone) {
        if (diphone instanceof AliasDiphone) {
            AliasDiphone adiph = (AliasDiphone)diphone;
            Diphone original = (Diphone)this.diphoneMap.get(adiph.getOriginalName());
            if (original != null) {
                adiph.setOriginalDiphone(original);
            } else {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("For diphone alias " + adiph.getName() + ", could not find original " + adiph.getOriginalName());
                }
                return;
            }
        }
        this.diphoneMap.put(diphone.getName(), diphone);
        if (this.defaultDiphone == null) {
            this.defaultDiphone = diphone;
        }
    }

    public Diphone getUnit(String unitName) {
        Diphone diphone;
        block10: {
            diphone = null;
            if (this.useIndexing) {
                int index;
                diphone = this.getFromCache(unitName);
                if (diphone == null && (index = this.getIndex(unitName)) != -1) {
                    this.mbb.position(index);
                    try {
                        diphone = Diphone.loadBinary(this.mbb);
                        if (diphone == null) break block10;
                        if (diphone instanceof AliasDiphone) {
                            AliasDiphone adiph = (AliasDiphone)diphone;
                            Diphone original = this.getUnit(adiph.getOriginalName());
                            if (original != null) {
                                adiph.setOriginalDiphone(original);
                                this.putIntoCache(unitName, adiph);
                            } else {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("For diphone alias " + adiph.getName() + ", could not find original " + adiph.getOriginalName());
                                }
                                diphone = null;
                            }
                            break block10;
                        }
                        this.putIntoCache(unitName, diphone);
                    }
                    catch (IOException ioe) {
                        System.err.println("Can't load diphone " + unitName);
                        diphone = null;
                    }
                }
            } else {
                diphone = (Diphone)this.diphoneMap.get(unitName);
            }
        }
        if (diphone == null) {
            System.err.println("Can't find diphone " + unitName);
            diphone = this.defaultDiphone;
        }
        return diphone;
    }

    private Diphone getFromCache(String name) {
        if (this.diphoneMap == null) {
            return null;
        }
        Diphone diphone = null;
        if (this.useSoftCache) {
            Reference ref = (Reference)this.diphoneMap.get(name);
            if (ref != null && (diphone = (Diphone)ref.get()) == null) {
                this.diphoneMap.remove(name);
            }
        } else {
            diphone = (Diphone)this.diphoneMap.get(name);
        }
        return diphone;
    }

    private void putIntoCache(String diphoneName, Diphone diphone) {
        if (this.diphoneMap == null) {
            return;
        }
        if (this.useSoftCache) {
            this.diphoneMap.put(diphoneName, new WeakReference<Diphone>(diphone));
        } else {
            this.diphoneMap.put(diphoneName, diphone);
        }
    }

    private void dumpCacheSize() {
        int empty = 0;
        int full = 0;
        System.out.println("Entries: " + this.diphoneMap.size());
        Iterator i = this.diphoneMap.values().iterator();
        while (i.hasNext()) {
            Reference ref = (Reference)i.next();
            if (ref.get() == null) {
                ++empty;
                continue;
            }
            ++full;
        }
        System.out.println("   empty: " + empty);
        System.out.println("    full: " + full);
    }

    public String getName() {
        return this.name;
    }

    public void dump() {
        System.out.println("Name        " + this.name);
        System.out.println("SampleRate  " + this.sampleRate);
        System.out.println("NumChannels " + this.numChannels);
        System.out.println("lpcMin      " + this.lpcMin);
        System.out.println("lpcRange    " + this.lpcRange);
        Iterator i = this.diphoneMap.values().iterator();
        while (i.hasNext()) {
            Diphone diphone = (Diphone)i.next();
            diphone.dump();
        }
    }

    public void dumpBinary(String path) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            DataOutputStream os = new DataOutputStream(fos);
            os.writeInt(-17958194);
            os.writeInt(1);
            os.writeInt(this.sampleRate);
            os.writeInt(this.numChannels);
            os.writeFloat(this.lpcMin);
            os.writeFloat(this.lpcRange);
            os.writeInt(this.diphoneMap.size());
            Iterator i = this.diphoneMap.values().iterator();
            while (i.hasNext()) {
                Diphone diphone = (Diphone)i.next();
                diphone.dumpBinary(os);
            }
            os.flush();
            fos.close();
        }
        catch (FileNotFoundException fe) {
            throw new Error("Can't dump binary database " + fe.getMessage());
        }
        catch (IOException ioe) {
            throw new Error("Can't write binary database " + ioe.getMessage());
        }
    }

    void dumpBinaryIndex(String path) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            DataOutputStream dos = new DataOutputStream(fos);
            dos.writeInt(16435934);
            dos.writeInt(this.diphoneIndex.keySet().size());
            Iterator i = this.diphoneIndex.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                int pos = (Integer)this.diphoneIndex.get(key);
                dos.writeUTF(key);
                dos.writeInt(pos);
            }
            dos.close();
        }
        catch (FileNotFoundException fe) {
            throw new Error("Can't dump binary index " + fe.getMessage());
        }
        catch (IOException ioe) {
            throw new Error("Can't write binary index " + ioe.getMessage());
        }
    }

    private void loadBinaryIndex(URL url) {
        this.diphoneIndex = new HashMap();
        try {
            InputStream is = Utilities.getInputStream(url);
            DataInputStream dis = new DataInputStream(is);
            if (dis.readInt() != 16435934) {
                throw new Error("Bad index file format");
            }
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                String diphoneName = dis.readUTF();
                int pos = dis.readInt();
                this.diphoneIndex.put(diphoneName, new Integer(pos));
            }
            dis.close();
        }
        catch (FileNotFoundException fe) {
            throw new Error("Can't load binary index " + fe.getMessage());
        }
        catch (IOException ioe) {
            throw new Error("Can't read binary index " + ioe.getMessage());
        }
    }

    private int getIndex(String diphone) {
        Integer index = (Integer)this.diphoneIndex.get(diphone);
        if (index != null) {
            int idx = index;
            if (this.defaultIndex == -1) {
                this.defaultIndex = idx;
            }
            return idx;
        }
        System.out.println("Can't find index entry for " + diphone);
        return this.defaultIndex;
    }

    private void loadBinary(InputStream is) throws IOException {
        if (this.useNewIO && is instanceof FileInputStream) {
            FileInputStream fis = (FileInputStream)is;
            if (this.useIndexing) {
                this.loadBinaryIndex(new URL(this.indexName));
                this.mapDatabase(fis);
            } else {
                this.loadMappedBinary(fis);
            }
        } else {
            this.useIndexing = false;
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            this.loadBinary(dis);
        }
    }

    private void loadBinary(DataInputStream dis) throws IOException {
        if (dis.readInt() != -17958194) {
            throw new Error("Bad magic in db");
        }
        if (dis.readInt() != 1) {
            throw new Error("Bad VERSION in db");
        }
        this.sampleRate = dis.readInt();
        this.numChannels = dis.readInt();
        this.lpcMin = dis.readFloat();
        this.lpcRange = dis.readFloat();
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            Diphone diphone = Diphone.loadBinary(dis);
            this.add(diphone);
        }
    }

    private void loadMappedBinary(FileInputStream is) throws IOException {
        FileChannel fc = is.getChannel();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        bb.load();
        this.loadDatabase(bb);
        is.close();
    }

    private void mapDatabase(FileInputStream is) throws IOException {
        FileChannel fc = is.getChannel();
        this.mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        this.mbb.load();
        this.loadDatabaseHeader(this.mbb);
    }

    private void loadDatabaseHeader(ByteBuffer bb) throws IOException {
        if (bb.getInt() != -17958194) {
            throw new Error("Bad magic in db");
        }
        if (bb.getInt() != 1) {
            throw new Error("Bad VERSION in db");
        }
        this.sampleRate = bb.getInt();
        this.numChannels = bb.getInt();
        this.lpcMin = bb.getFloat();
        this.lpcRange = bb.getFloat();
    }

    private void loadDatabase(ByteBuffer bb) throws IOException {
        this.loadDatabaseHeader(bb);
        int size = bb.getInt();
        this.diphoneIndex = new HashMap();
        for (int i = 0; i < size; ++i) {
            int pos = bb.position();
            Diphone diphone = Diphone.loadBinary(bb);
            this.add(diphone);
            this.diphoneIndex.put(diphone.getName(), new Integer(pos));
        }
    }

    public boolean compare(DiphoneUnitDatabase other) {
        if (this.sampleRate != other.sampleRate) {
            return false;
        }
        if (this.numChannels != other.numChannels) {
            return false;
        }
        if (this.lpcMin != other.lpcMin) {
            return false;
        }
        if (this.lpcRange != other.lpcRange) {
            return false;
        }
        Iterator i = this.diphoneMap.values().iterator();
        while (i.hasNext()) {
            Diphone otherDiphone;
            Diphone diphone = (Diphone)i.next();
            if (diphone.compare(otherDiphone = other.getUnit(diphone.getName()))) continue;
            System.out.println("Diphones differ:");
            System.out.println("THis:");
            diphone.dump();
            System.out.println("Other:");
            otherDiphone.dump();
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        boolean showTimes = false;
        String srcPath = ".";
        String destPath = ".";
        try {
            if (args.length > 0) {
                BulkTimer timer = BulkTimer.LOAD;
                timer.start();
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-src")) {
                        srcPath = args[++i];
                        continue;
                    }
                    if (args[i].equals("-dest")) {
                        destPath = args[++i];
                        continue;
                    }
                    if (args[i].equals("-generate_binary")) {
                        String nameArg;
                        String name = "diphone_units.txt";
                        if (i + 1 < args.length && !(nameArg = args[++i]).startsWith("-")) {
                            name = nameArg;
                        }
                        int suffixPos = name.lastIndexOf(".txt");
                        String binaryName = "diphone_units.bin";
                        if (suffixPos != -1) {
                            binaryName = name.substring(0, suffixPos) + ".bin";
                        }
                        String indexName = "diphone_units.idx";
                        if (suffixPos != -1) {
                            indexName = name.substring(0, suffixPos) + ".idx";
                        }
                        System.out.println("Loading " + name);
                        timer.start("load_text");
                        DiphoneUnitDatabase udb = new DiphoneUnitDatabase(new URL("file:" + srcPath + "/" + name), false);
                        timer.stop("load_text");
                        System.out.println("Dumping " + binaryName);
                        timer.start("dump_binary");
                        udb.dumpBinary(destPath + "/" + binaryName);
                        timer.stop("dump_binary");
                        timer.start("load_binary");
                        DiphoneUnitDatabase budb = new DiphoneUnitDatabase(new URL("file:" + destPath + "/" + binaryName), true);
                        timer.stop("load_binary");
                        System.out.println("Dumping " + indexName);
                        timer.start("dump index");
                        budb.dumpBinaryIndex(destPath + "/" + indexName);
                        timer.stop("dump index");
                        continue;
                    }
                    if (args[i].equals("-compare")) {
                        timer.start("load_text");
                        DiphoneUnitDatabase udb = new DiphoneUnitDatabase(new URL("file:./diphone_units.txt"), false);
                        timer.stop("load_text");
                        timer.start("load_binary");
                        DiphoneUnitDatabase budb = new DiphoneUnitDatabase(new URL("file:./diphone_units.bin"), true);
                        timer.stop("load_binary");
                        timer.start("compare");
                        if (udb.compare(budb)) {
                            System.out.println("other compare ok");
                        } else {
                            System.out.println("other compare different");
                        }
                        timer.stop("compare");
                        continue;
                    }
                    if (args[i].equals("-showtimes")) {
                        showTimes = true;
                        continue;
                    }
                    System.out.println("Unknown option " + args[i]);
                }
                timer.stop();
                if (showTimes) {
                    timer.show("DiphoneUnitDatabase");
                }
            } else {
                System.out.println("Options: ");
                System.out.println("    -src path");
                System.out.println("    -dest path");
                System.out.println("    -compare");
                System.out.println("    -generate_binary");
                System.out.println("    -showTimes");
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
    }
}

