/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.com.sun.speech.freetts.en.us;

import io.github.elytra.copo.repackage.com.sun.speech.freetts.Age;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Gender;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.UtteranceProcessor;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.diphone.DiphonePitchmarkGenerator;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.diphone.DiphoneUnitSelector;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.en.us.CMUDiphoneVoicePostLexicalAnalyzer;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.en.us.CMULexicon;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.en.us.CMUVoice;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.UnitConcatenator;
import io.github.elytra.copo.repackage.de.dfki.lt.freetts.ConcatenativeVoice;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;

public class CMUDiphoneVoice
extends CMUVoice
implements ConcatenativeVoice {
    protected URL database;

    public CMUDiphoneVoice() {
        this(null, null, null, null, null, null, null, null, null);
    }

    public CMUDiphoneVoice(String name, Gender gender, Age age, String description, Locale locale, String domain, String organization, CMULexicon lexicon, URL database) {
        super(name, gender, age, description, locale, domain, organization, lexicon);
        this.setRate(150.0f);
        this.setPitch(100.0f);
        this.setPitchRange(11.0f);
        this.database = database;
    }

    public URL getDatabase() {
        if (this.database == null) {
            String name = this.getFeatures().getString("databaseName");
            this.database = this.getClass().getResource(name);
        }
        return this.database;
    }

    protected void setupFeatureSet() throws IOException {
        super.setupFeatureSet();
    }

    protected UtteranceProcessor getPostLexicalAnalyzer() throws IOException {
        return new CMUDiphoneVoicePostLexicalAnalyzer();
    }

    public UtteranceProcessor getPitchmarkGenerator() throws IOException {
        return new DiphonePitchmarkGenerator();
    }

    public UtteranceProcessor getUnitConcatenator() throws IOException {
        return new UnitConcatenator();
    }

    public UtteranceProcessor getUnitSelector() throws IOException {
        return new DiphoneUnitSelector(this.getDatabase());
    }

    public String toString() {
        return "CMUDiphoneVoice";
    }
}

