/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.com.sun.speech.freetts.relp;

import io.github.elytra.copo.repackage.com.sun.speech.freetts.FeatureSet;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Item;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.ProcessException;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Relation;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Unit;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Utterance;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.UtteranceProcessor;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.LPCResult;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.Sample;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.SampleInfo;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.util.Utilities;

public class UnitConcatenator
implements UtteranceProcessor {
    private static final int ADD_RESIDUAL_PULSE = 1;
    private static final int ADD_RESIDUAL_WINDOWED = 2;
    private static final int ADD_RESIDUAL = 3;
    public static final String PROP_OUTPUT_LPC = "io.github.elytra.copo.repackage.com.sun.speech.freetts.outputLPC";
    private boolean outputLPC = Utilities.getBoolean("io.github.elytra.copo.repackage.com.sun.speech.freetts.outputLPC");

    public void processUtterance(Utterance utterance) throws ProcessException {
        SampleInfo sampleInfo;
        float uIndex = 0.0f;
        int pmI = 0;
        int targetResidualPosition = 0;
        int targetStart = 0;
        Relation unitRelation = utterance.getRelation("Unit");
        int addResidualMethod = 3;
        String residualType = utterance.getString("residual_type");
        if (residualType != null) {
            if (residualType.equals("pulse")) {
                addResidualMethod = 1;
            } else if (residualType.equals("windowed")) {
                addResidualMethod = 2;
            }
        }
        if ((sampleInfo = (SampleInfo)utterance.getObject("SampleInfo")) == null) {
            throw new IllegalStateException("UnitConcatenator: SampleInfo does not exist");
        }
        LPCResult lpcResult = (LPCResult)utterance.getObject("target_lpcres");
        lpcResult.setValues(sampleInfo.getNumberOfChannels(), sampleInfo.getSampleRate(), sampleInfo.getResidualFold(), sampleInfo.getCoeffMin(), sampleInfo.getCoeffRange());
        int[] targetTimes = lpcResult.getTimes();
        int[] residualSizes = lpcResult.getResidualSizes();
        int samplesSize = 0;
        if (lpcResult.getNumberOfFrames() > 0) {
            samplesSize = targetTimes[lpcResult.getNumberOfFrames() - 1];
        }
        lpcResult.resizeResiduals(samplesSize);
        for (Item unitItem = unitRelation.getHead(); unitItem != null; unitItem = unitItem.getNext()) {
            FeatureSet featureSet = unitItem.getFeatures();
            String unitName = featureSet.getString("name");
            int targetEnd = featureSet.getInt("target_end");
            Unit unit = (Unit)featureSet.getObject("unit");
            int unitSize = unit.getSize();
            uIndex = 0.0f;
            float m = (float)unitSize / (float)(targetEnd - targetStart);
            int numberFrames = lpcResult.getNumberOfFrames();
            while (pmI < numberFrames && targetTimes[pmI] <= targetEnd) {
                int residualSize;
                Sample sample = unit.getNearestSample(uIndex);
                lpcResult.setFrame(pmI, sample.getFrameData());
                residualSizes[pmI] = residualSize = lpcResult.getFrameShift(pmI);
                byte[] residualData = sample.getResidualData();
                if (addResidualMethod == 1) {
                    lpcResult.copyResidualsPulse(residualData, targetResidualPosition, residualSize);
                } else {
                    lpcResult.copyResiduals(residualData, targetResidualPosition, residualSize);
                }
                targetResidualPosition += residualSize;
                uIndex += (float)residualSize * m;
                ++pmI;
            }
            targetStart = targetEnd;
        }
        lpcResult.setNumberOfFrames(pmI);
        if (this.outputLPC) {
            lpcResult.dump();
        }
    }

    public String toString() {
        return "UnitConcatenator";
    }
}

