/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.com.sun.speech.freetts.util;

import io.github.elytra.copo.repackage.com.sun.speech.freetts.FeatureSet;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Item;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Relation;

public class SegmentRelationUtils {
    public static Item getItem(Relation segmentRelation, float time) {
        Item lastSegment = segmentRelation.getTail();
        float lastSegmentEndTime = SegmentRelationUtils.getSegmentEnd(lastSegment);
        if (time < 0.0f || lastSegmentEndTime < time) {
            return null;
        }
        if (lastSegmentEndTime - time > time) {
            return SegmentRelationUtils.findFromFront(segmentRelation, time);
        }
        return SegmentRelationUtils.findFromEnd(segmentRelation, time);
    }

    public static float getSegmentEnd(Item segment) {
        FeatureSet segmentFeatureSet = segment.getFeatures();
        return segmentFeatureSet.getFloat("end");
    }

    public static Item findFromFront(Relation segmentRelation, float time) {
        Item item;
        for (item = segmentRelation.getHead(); item != null && time > SegmentRelationUtils.getSegmentEnd(item); item = item.getNext()) {
        }
        return item;
    }

    public static Item findFromEnd(Relation segmentRelation, float time) {
        Item item;
        for (item = segmentRelation.getTail(); item != null && SegmentRelationUtils.getSegmentEnd(item) > time; item = item.getPrevious()) {
        }
        if (item != segmentRelation.getTail()) {
            item = item.getNext();
        }
        return item;
    }
}

