/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.de.dfki.lt.freetts;

import io.github.elytra.copo.repackage.com.sun.speech.freetts.Age;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Gender;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.PartOfSpeechImpl;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.PhoneSet;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.PhoneSetImpl;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Tokenizer;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.UtteranceProcessor;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Voice;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.clunits.ClusterUnitPitchmarkGenerator;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.clunits.ClusterUnitSelector;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.en.us.CMULexicon;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.en.us.FeatureProcessors;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.lexicon.Lexicon;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.AudioOutput;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.SampleInfo;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.relp.UnitConcatenator;
import io.github.elytra.copo.repackage.de.dfki.lt.freetts.ClusterUnitNamer;
import io.github.elytra.copo.repackage.de.dfki.lt.freetts.ConcatenativeVoice;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;

public class ClusterUnitVoice
extends Voice
implements ConcatenativeVoice {
    private PhoneSet phoneSet;
    protected URL database;
    protected URL phonesetURL;
    protected URL partOfSpeechURL;
    protected ClusterUnitSelector unitSelector;
    private ClusterUnitNamer unitNamer;

    public ClusterUnitVoice(String name, Gender gender, Age age, String description, Locale locale, String domain, String organization, Lexicon lexicon, URL database) {
        this(name, gender, age, description, locale, domain, organization, lexicon, database, null, null, null);
    }

    public ClusterUnitVoice(String name, Gender gender, Age age, String description, Locale locale, String domain, String organization, Lexicon lexicon, URL database, ClusterUnitNamer unitNamer, URL phonesetURL, URL partOfSpeechURL) {
        super(name, gender, age, description, locale, domain, organization);
        this.setRate(150.0f);
        this.setPitch(100.0f);
        this.setPitchRange(12.0f);
        if (lexicon != null) {
            this.setLexicon(lexicon);
        } else {
            this.setLexicon(new CMULexicon("cmutimelex"));
        }
        this.database = database;
        this.unitNamer = unitNamer;
        this.phonesetURL = phonesetURL;
        this.partOfSpeechURL = partOfSpeechURL;
        try {
            this.unitSelector = new ClusterUnitSelector(this.getDatabase(), unitNamer);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public SampleInfo getSampleInfo() {
        return this.unitSelector.getSampleInfo();
    }

    public Tokenizer getTokenizer() {
        return null;
    }

    protected void loader() throws IOException {
        this.setupFeatureProcessors();
    }

    protected UtteranceProcessor getAudioOutput() throws IOException {
        return new AudioOutput();
    }

    public URL getDatabase() {
        return this.database;
    }

    public UtteranceProcessor getUnitSelector() throws IOException {
        return this.unitSelector;
    }

    public UtteranceProcessor getPitchmarkGenerator() throws IOException {
        return new ClusterUnitPitchmarkGenerator();
    }

    public UtteranceProcessor getUnitConcatenator() throws IOException {
        return new UnitConcatenator();
    }

    protected void setupFeatureProcessors() throws IOException {
        if (this.phonesetURL != null) {
            this.phoneSet = new PhoneSetImpl(this.phonesetURL);
        }
        if (this.partOfSpeechURL != null) {
            PartOfSpeechImpl pos = new PartOfSpeechImpl(this.partOfSpeechURL, "content");
            this.addFeatureProcessor("gpos", new FeatureProcessors.Gpos(pos));
        }
        this.addFeatureProcessor("word_break", new FeatureProcessors.WordBreak());
        this.addFeatureProcessor("word_punc", new FeatureProcessors.WordPunc());
        this.addFeatureProcessor("word_numsyls", new FeatureProcessors.WordNumSyls());
        this.addFeatureProcessor("ssyl_in", new FeatureProcessors.StressedSylIn());
        this.addFeatureProcessor("syl_in", new FeatureProcessors.SylIn());
        this.addFeatureProcessor("syl_out", new FeatureProcessors.SylOut());
        this.addFeatureProcessor("ssyl_out", new FeatureProcessors.StressedSylOut());
        this.addFeatureProcessor("syl_break", new FeatureProcessors.SylBreak());
        this.addFeatureProcessor("old_syl_break", new FeatureProcessors.SylBreak());
        this.addFeatureProcessor("num_digits", new FeatureProcessors.NumDigits());
        this.addFeatureProcessor("month_range", new FeatureProcessors.MonthRange());
        this.addFeatureProcessor("token_pos_guess", new FeatureProcessors.TokenPosGuess());
        this.addFeatureProcessor("segment_duration", new FeatureProcessors.SegmentDuration());
        this.addFeatureProcessor("sub_phrases", new FeatureProcessors.SubPhrases());
        this.addFeatureProcessor("asyl_in", new FeatureProcessors.AccentedSylIn());
        this.addFeatureProcessor("last_accent", new FeatureProcessors.LastAccent());
        this.addFeatureProcessor("pos_in_syl", new FeatureProcessors.PosInSyl());
        this.addFeatureProcessor("position_type", new FeatureProcessors.PositionType());
        this.addFeatureProcessor("ph_cplace", new FeatureProcessors.PH_CPlace());
        this.addFeatureProcessor("ph_ctype", new FeatureProcessors.PH_CType());
        this.addFeatureProcessor("ph_cvox", new FeatureProcessors.PH_CVox());
        this.addFeatureProcessor("ph_vc", new FeatureProcessors.PH_VC());
        this.addFeatureProcessor("ph_vfront", new FeatureProcessors.PH_VFront());
        this.addFeatureProcessor("ph_vheight", new FeatureProcessors.PH_VHeight());
        this.addFeatureProcessor("ph_vlng", new FeatureProcessors.PH_VLength());
        this.addFeatureProcessor("ph_vrnd", new FeatureProcessors.PH_VRnd());
        this.addFeatureProcessor("seg_coda_fric", new FeatureProcessors.SegCodaFric());
        this.addFeatureProcessor("seg_onset_fric", new FeatureProcessors.SegOnsetFric());
        this.addFeatureProcessor("seg_coda_stop", new FeatureProcessors.SegCodaStop());
        this.addFeatureProcessor("seg_onset_stop", new FeatureProcessors.SegOnsetStop());
        this.addFeatureProcessor("seg_coda_nasal", new FeatureProcessors.SegCodaNasal());
        this.addFeatureProcessor("seg_onset_nasal", new FeatureProcessors.SegOnsetNasal());
        this.addFeatureProcessor("seg_coda_glide", new FeatureProcessors.SegCodaGlide());
        this.addFeatureProcessor("seg_onset_glide", new FeatureProcessors.SegOnsetGlide());
        this.addFeatureProcessor("seg_onsetcoda", new FeatureProcessors.SegOnsetCoda());
        this.addFeatureProcessor("syl_codasize", new FeatureProcessors.SylCodaSize());
        this.addFeatureProcessor("syl_onsetsize", new FeatureProcessors.SylOnsetSize());
        this.addFeatureProcessor("accented", new FeatureProcessors.Accented());
    }

    public String getPhoneFeature(String phone, String featureName) {
        if (this.phoneSet != null) {
            return this.phoneSet.getPhoneFeature(phone, featureName);
        }
        return null;
    }
}

